package cn.lollypop.android.thermometer.ble.model;

import java.util.Calendar;
import java.util.Date;

import android.content.Context;
import android.text.TextUtils;
import com.basic.util.ACache;
import com.basic.util.CommonUtil;
import com.basic.util.GsonUtil;

public class AlarmTimeModel {

  public static int EVERY_DAY = 1;
  private static int NO_DAY = 0;

  private int alarmWeek; // 一个BIt数据，用7个Bit位来表示7天，0表示不响

  private int alarmHour;

  private int alarmMin;

  private boolean isSelected;

  public AlarmTimeModel(int alarmWeek, int alarmHour,
                        int alarmMin, boolean isSelected) {
    this.alarmWeek = alarmWeek;
    this.alarmHour = alarmHour;
    this.alarmMin = alarmMin;
    this.isSelected = isSelected;
  }

  public static byte[] generateSystemTime(Date date) {
    Calendar c = Calendar.getInstance();
    c.setTime(date);
    Integer year = c.get(Calendar.YEAR);
    year = year % 2000;
    Integer month = c.get(Calendar.MONTH) + 1;
    Integer day = c.get(Calendar.DAY_OF_MONTH);
    Integer week = c.get(Calendar.DAY_OF_WEEK) - 1;
    Integer hour = c.get(Calendar.HOUR_OF_DAY);
    Integer min = c.get(Calendar.MINUTE);
    Integer second = c.get(Calendar.SECOND);

    return new byte[]{
        year.byteValue(), month.byteValue(), day.byteValue(), week.byteValue(),
        hour.byteValue(), min.byteValue(), second.byteValue()};
  }

  public byte[] generateAlarm() {
    return new byte[]{(byte) alarmWeek, (byte) alarmHour, (byte) alarmMin};
  }

  public static AlarmTimeModel getSingle(Context context) {
    String json = ACache.get(context).getAsString("AlarmTimeModel");
    AlarmTimeModel alarmTimeModel;
    if (TextUtils.isEmpty(json)) {
      alarmTimeModel = new AlarmTimeModel(AlarmTimeModel.NO_DAY, 8, 0, false);
    } else {
      alarmTimeModel =
          GsonUtil.getGson().fromJson(json, AlarmTimeModel.class);
    }
    return alarmTimeModel;
  }

  public static void updateSingle(Context context,
                                  int week, int hour, int min) {
    AlarmTimeModel alarmTimeModel = getSingle(context);
    alarmTimeModel.setAlarmWeek(week);
    alarmTimeModel.setAlarmHour(hour);
    alarmTimeModel.setAlarmMin(min);
    String json = GsonUtil.getGson().toJson(alarmTimeModel);
    ACache.get(context).put("AlarmTimeModel", json);
  }

  public static String getShow(AlarmTimeModel alarmTimeModel) {
    if (alarmTimeModel != null) {
      return CommonUtil.convert10ToString(alarmTimeModel.getAlarmHour())
          + ":" + CommonUtil.convert10ToString(alarmTimeModel.getAlarmMin());
    }
    return "NA";
  }

  public int getAlarmWeek() {
    return alarmWeek;
  }

  public void setAlarmWeek(int alarmWeek) {
    this.alarmWeek = alarmWeek;
  }

  public int getAlarmHour() {
    return alarmHour;
  }

  public void setAlarmHour(int alarmHour) {
    this.alarmHour = alarmHour;
  }

  public int getAlarmMin() {
    return alarmMin;
  }

  public void setAlarmMin(int alarmMin) {
    this.alarmMin = alarmMin;
  }

  public boolean isSelected() {
    return isSelected;
  }

  public void setIsSelected(boolean isSelected) {
    this.isSelected = isSelected;
  }

  @Override
  public String toString() {
    return "AlarmTimeModel{" +
        "alarmWeek=" + alarmWeek +
        ", alarmHour=" + alarmHour +
        ", alarmMin=" + alarmMin +
        ", isSelected=" + isSelected +
        '}';
  }
}
