package cn.lollypop.android.thermometer.ble.action.request;

import com.basic.util.ClsUtil;
import com.orhanobut.logger.Logger;

import cn.lollypop.android.thermometer.ble.Constants;
import cn.lollypop.android.thermometer.ble.model.User;

/**
 * Copyright (c) 2016, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */

public class UserAddRequest extends BleRequest {
  public UserAddRequest(User user) {
    this.characteristicUUID = Constants.UUID_CUSTOM_DATA;
    this.actionType = BleRequestActionType.WRITE;
    this.valueType = BleRequestValueType.BYTE;
    byte[] names = ClsUtil.HexString2Bytes(
        ClsUtil.convertStringToHex(user.getName()));
    this.value = new byte[names.length + 3];
    this.value[0] = 0x03;
    this.value[1] = user.getId();
    this.value[2] = (byte) names.length;
    System.arraycopy(names, 0, this.value, 3, names.length);
    Logger.i("ble add user : " + ClsUtil.Bytes2HexString(value));
  }
}
