package cn.lollypop.android.thermometer.ble.action.request;

import android.content.Context;
import com.orhanobut.logger.Logger;

import cn.lollypop.android.thermometer.ble.BleCallback;
import cn.lollypop.android.thermometer.ble.Constants;

/**
 * Copyright (c) 2015, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public class TemperatureIntervalRequest extends BleRequest {
  public TemperatureIntervalRequest(int value, int offset) {
    this.characteristicUUID = Constants.UUID_MEASUREMENT_INTERVAL;
    this.actionType = BleRequestActionType.WRITE;
    this.valueType = BleRequestValueType.UINT16;

    this.valueInt = value;
    this.offset = offset;
  }

  @Override
  public boolean analyzeData(Context context, byte[] data) {
    if (valueInt == Constants.INTERVAL) {
      currentBleStatus = BleCallback.BleStatus.MEASURE_START;
      Logger.i("ble start listening temperature");
    }
    return true;
  }
}
