package cn.lollypop.android.thermometer.ble.action.request;

import android.content.Context;
import com.orhanobut.logger.Logger;

import cn.lollypop.android.thermometer.ble.Constants;
import cn.lollypop.android.thermometer.ble.utils.DeviceInformationServiceUtil;

/**
 * Copyright (c) 2015, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public class SoftwareRevisionRequest extends BleRequest {
  public SoftwareRevisionRequest() {
    characteristicUUID = Constants.UUID_SOFTWARE_REVISION;
    actionType = BleRequestActionType.READ;
    valueType = BleRequestValueType.NO_VALUE;
  }

  @Override
  public boolean analyzeData(Context context, byte[] data) {
    String version = DeviceInformationServiceUtil.getSoftwareRevision(data);
    DeviceInformationServiceUtil.setFirmwareVersion(context, version);
    version = DeviceInformationServiceUtil.getFirmwareVersion(context);
    Logger.i("ble get software revision : " + version);
    return !"0.0.0".equals(version);
  }
}
