package cn.lollypop.android.thermometer.ble.action.request;

import android.content.Context;
import com.orhanobut.logger.Logger;

import cn.lollypop.android.thermometer.ble.Constants;
import cn.lollypop.android.thermometer.ble.utils.DeviceInformationServiceUtil;

/**
 * Copyright (c) 2015, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public class HardwareRevisionRequest extends BleRequest {
  public HardwareRevisionRequest() {
    characteristicUUID = Constants.UUID_HARDWARE_REVISION;
    actionType = BleRequestActionType.READ;
    valueType = BleRequestValueType.NO_VALUE;
  }

  @Override
  public boolean analyzeData(Context context, byte[] data) {
    String version = DeviceInformationServiceUtil.getHardwareRevision(data);
    DeviceInformationServiceUtil.setHardwareVersion(context, version);
    version = DeviceInformationServiceUtil.getHardwareVersion(context);
    Logger.i("ble get hardware revision : " + version);
    return !"".equals(version);
  }
}
