package cn.lollypop.android.thermometer.ble.action.request;

import java.util.UUID;

import android.content.Context;
import com.basic.util.ClsUtil;

import cn.lollypop.android.thermometer.ble.BleCallback;

/**
 * Copyright (c) 2015, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public class BleRequest {
  protected UUID characteristicUUID;
  protected BleRequestActionType actionType;
  protected byte[] value;
  protected int valueInt;
  protected BleRequestValueType valueType;
  protected int offset;
  protected boolean valueBoolean;
  protected BleCallback.BleStatus currentBleStatus;
  protected Object object;

  public BleRequest() {}

  public BleRequest(UUID uuid, BleRequestActionType actionType) {
    characteristicUUID = uuid;
    this.actionType = actionType;
    this.valueType = BleRequestValueType.NO_VALUE;
  }

  public BleRequest(UUID uuid, BleRequestActionType actionType, byte[] value) {
    characteristicUUID = uuid;
    this.actionType = actionType;
    this.value = value;
    this.valueType = BleRequestValueType.BYTE;
  }

  public BleRequest(UUID uuid, BleRequestActionType actionType,
                    int value, int offset) {
    characteristicUUID = uuid;
    this.actionType = actionType;
    this.valueInt = value;
    this.offset = offset;
    this.valueType = BleRequestValueType.UINT16;
  }

  public BleRequest(UUID uuid, BleRequestActionType actionType, boolean b) {
    characteristicUUID = uuid;
    this.actionType = actionType;
    this.valueBoolean = b;
    this.valueType = BleRequestValueType.BOOLEAN;
  }

  // 返回的数据进行分析
  public boolean analyzeData(Context context, byte[] data) {
    return true;
  }

  public UUID getCharacteristicUUID() {
    return characteristicUUID;
  }

  public void setCharacteristicUUID(UUID characteristicUUID) {
    this.characteristicUUID = characteristicUUID;
  }

  public BleRequestActionType getActionType() {
    return actionType;
  }

  public void setActionType(BleRequestActionType actionType) {
    this.actionType = actionType;
  }

  public byte[] getValue() {
    return value;
  }

  public void setValue(byte[] value) {
    this.value = value;
  }

  public BleRequestValueType getValueType() {
    return valueType;
  }

  public void setValueType(BleRequestValueType valueType) {
    this.valueType = valueType;
  }

  public int getOffset() {
    return offset;
  }

  public void setOffset(int offset) {
    this.offset = offset;
  }

  public int getValueInt() {
    return valueInt;
  }

  public void setValueInt(int valueInt) {
    this.valueInt = valueInt;
  }

  public boolean isValueBoolean() {
    return valueBoolean;
  }

  public void setValueBoolean(boolean valueBoolean) {
    this.valueBoolean = valueBoolean;
  }

  public BleCallback.BleStatus getCurrentBleStatus() {
    return currentBleStatus;
  }

  public Object getObject() {
    return object;
  }

  @Override
  public String toString() {
    String valueStr = "";
    if (value != null) {
      valueStr = ClsUtil.Bytes2HexString(value);
    }
    return characteristicUUID + "，" + actionType.toString() + "，" + valueStr;
  }
}