package cn.lollypop.android.thermometer.ble.action.request;

import android.content.Context;
import com.orhanobut.logger.Logger;

import cn.lollypop.android.thermometer.ble.BleCallback;
import cn.lollypop.android.thermometer.ble.Constants;
import cn.lollypop.android.thermometer.ble.utils.BatteryServiceUtil;
import cn.lollypop.android.thermometer.ble.utils.CustomServiceUtil;

/**
 * Copyright (c) 2015, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public class BatteryRequest extends BleRequest {

  public BatteryRequest() {
    characteristicUUID = Constants.UUID_BATTERY_LEVEL;
    actionType = BleRequestActionType.READ;
    valueType = BleRequestValueType.NO_VALUE;
  }

  @Override
  public boolean analyzeData(Context context, byte[] data) {
    int battery = BatteryServiceUtil.getBatteryLevel(data);
    Logger.i("ble get battery data : " + battery);
    BatteryServiceUtil.setBatteryLevel(context, battery);
    CustomServiceUtil.setBatteryLevel(context, battery);

    currentBleStatus = BleCallback.BleStatus.GET_BATTERY;
    object = BatteryServiceUtil.getBatteryLevel(context);
    return true;
  }
}
