/*
 * Copyright (C) 2013 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.lollypop.android.thermometer.ble;

/**
 * This class includes a small subset of standard GATT attributes
 * for demonstration purposes.
 */
public class GattAttributes {
  //SERVICES
  public static String HEALTH_THERMOMETER_SERVICE =
      "00001809-0000-1000-8000-00805f9b34fb";
  public static String BATTERY_SERVICE =
      "0000180F-0000-1000-8000-00805f9b34fb";
  public static String DEVICE_INFORMATION_SERVICE =
      "0000180a-0000-1000-8000-00805f9b34fb";
  public static String CUSTOM_SERVICE = "0f0e0d0c-0b0a-0908-0706-050403020100";
  public static String CURRENT_TIME_SERVICE =
      "00001805-0000-1000-8000-00805f9b34fb";
  public static String REFERENCE_TIME_UPDATE_SERVICE =
      "00001806-0000-1000-8000-00805f9b34fb";

  //CHARACTERISTICS
  public static String TEMPERATURE_MEASUREMENT =
      "00002a1c-0000-1000-8000-00805f9b34fb";
  public static String MEASUREMENT_INTERVAL =
      "00002a21-0000-1000-8000-00805f9b34fb";
  public static String BATTERY_LEVEL = "00002a19-0000-1000-8000-00805f9b34fb";
  public static String CLIENT_CHARACTERISTIC_CONFIG =
      "00002902-0000-1000-8000-00805f9b34fb";
  public static String SOFTWARE_REVISION =
      "00002a28-0000-1000-8000-00805f9b34fb";
  public static String HARDWARE_REVISION =
      "00002a27-0000-1000-8000-00805f9b34fb";
  public static String SN = "00002a25-0000-1000-8000-00805f9b34fb";
  public static String CUSTOM_DATA = "1f1e1d1c-1b1a-1918-1716-151413121110";
  public static String CUSTOM_REFRESH = "2f2e2d2c-2b2a-2928-2726-252423222120";
  public static String CURRENT_TIME = "00002a2b-0000-1000-8000-00805f9b34fb";
  public static String TIME_UPDATE_CONTROL_POINT =
      "00002a16-0000-1000-8000-00805f9b34fb";

  public static String SAMPLE_DATA_UUID =
      "3f3e3d3c-3b3a-3938-3736-353433323130";
}