/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.ops;

import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.ops.AVOp;
import com.avos.avoscloud.ops.CollectionAddOp;
import com.avos.avoscloud.ops.CompoundOp;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class AddUniqueOp
extends CollectionAddOp {
    private Set<Object> values = new HashSet<Object>();

    @Override
    public Set<Object> getValues() {
        return this.values;
    }

    public AddUniqueOp() {
    }

    public AddUniqueOp(String key, Object ... values) {
        super(key, AVOp.OpType.AddUnique);
        if (values != null) {
            for (Object obj : values) {
                this.values.add(obj);
            }
        }
    }

    @Override
    public Map<String, Object> encodeOp() {
        return AVUtils.createArrayOpMap(this.key, this.type.name(), this.getParsedValues());
    }

    @Override
    public Object apply(Object oldValue) {
        HashSet result = new HashSet();
        if (oldValue != null) {
            result.addAll((Collection)oldValue);
        }
        if (this.getValues() != null) {
            result.addAll(this.getValues());
        }
        return new LinkedList(result);
    }

    @Override
    public AVOp merge(AVOp other) {
        this.assertKeyEquals(other);
        switch (other.type()) {
            case Null: {
                return this;
            }
            case Set: {
                return other;
            }
            case AddUnique: {
                this.values.addAll(other.cast(AddUniqueOp.class).values);
                return this;
            }
            case AddRelation: 
            case Remove: 
            case Add: 
            case RemoveRelation: {
                return new CompoundOp(this.key, this, other);
            }
            case Increment: {
                throw new UnsupportedOperationException("Could not increment an non-numberic value.");
            }
            case Delete: {
                return other;
            }
            case Compound: {
                other.cast(CompoundOp.class).addFirst(this);
                return other;
            }
        }
        throw new IllegalStateException("Unknow op type " + (Object)((Object)other.type()));
    }
}

