/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.ops;

import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.ops.AVOp;
import com.avos.avoscloud.ops.CollectionAddOp;
import com.avos.avoscloud.ops.CompoundOp;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AddRelationOp
extends CollectionAddOp {
    private Set<AVObject> values = new HashSet<AVObject>();

    public AddRelationOp() {
    }

    @Override
    public Set<AVObject> getValues() {
        return this.values;
    }

    public AddRelationOp(String key, AVObject ... values) {
        super(key, AVOp.OpType.AddRelation);
        if (values != null) {
            for (AVObject obj : values) {
                this.values.add(obj);
            }
        }
    }

    @Override
    public Object apply(Object oldValue) {
        return oldValue;
    }

    @Override
    public Map<String, Object> encodeOp() {
        return AVUtils.createPointerArrayOpMap(this.key, this.type.name(), this.getValues());
    }

    @Override
    public AVOp merge(AVOp other) {
        this.assertKeyEquals(other);
        switch (other.type()) {
            case Null: {
                return this;
            }
            case Set: {
                return other;
            }
            case AddRelation: {
                this.values.addAll(other.cast(AddRelationOp.class).values);
                return this;
            }
            case AddUnique: 
            case Remove: 
            case Add: 
            case RemoveRelation: {
                return new CompoundOp(this.key, this, other);
            }
            case Increment: {
                throw new UnsupportedOperationException("Could not increment an non-numberic value.");
            }
            case Delete: {
                return other;
            }
            case Compound: {
                other.cast(CompoundOp.class).addFirst(this);
                return other;
            }
        }
        throw new IllegalStateException("Unknow op type " + (Object)((Object)other.type()));
    }
}

