/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.provider.Settings;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.PaasClient;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.loopj.android.http.ResponseHandlerInterface;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;

class RequestStatisticsUtil {
    private static final String REQUEST_DATA = "com.avos.avoscloud.RequestStatisticsUtil.data";
    private static final String LAST_SENDTIME = "lastSendTime";
    private static int TIME_INTERVAL = 86400000;
    private static RequestStatisticsUtil sInstance;
    private long lastSendTime = 0L;
    private RequestStatistics requestStatistics;

    private RequestStatisticsUtil() {
        this.getLastSendTime();
        this.requestStatistics = new RequestStatistics();
    }

    public static synchronized RequestStatisticsUtil getInstance() {
        if (sInstance == null) {
            sInstance = new RequestStatisticsUtil();
        }
        return sInstance;
    }

    public void recordRequestTime(int statusCode, boolean isTimeOut, long time) {
        if (time > 0L && time < (long)(AVOSCloud.getNetworkTimeout() * 2)) {
            this.requestStatistics.addRequestData(statusCode, isTimeOut, time);
            this.requestStatistics.saveToPreference();
        }
    }

    public void sendToServer() {
        if (this.isNeedToSend()) {
            this.sendData(new RequestStatistics());
        }
    }

    private Map<String, Object> getClientInfo(Context context) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String packageName = context.getApplicationContext().getPackageName();
        map.put("platform", "Android");
        try {
            PackageInfo info = context.getPackageManager().getPackageInfo(packageName, 0);
            map.put("app_version", info.versionName);
            map.put("sdk_version", "v3.7.5");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String macAddress = null;
        try {
            WifiManager wifiManager = (WifiManager)AVOSCloud.applicationContext.getSystemService("wifi");
            WifiInfo wInfo = wifiManager.getConnectionInfo();
            macAddress = wInfo.getMacAddress();
        }
        catch (Exception e) {
            // empty catch block
        }
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        String deviceId = AVUtils.isBlankString(macAddress) ? androidId : AVUtils.md5(macAddress + androidId);
        map.put("id", deviceId);
        return map;
    }

    private void sendData(final RequestStatistics requestData) {
        if (requestData.totalNum > 0) {
            HashMap<String, Map<String, Object>> data = new HashMap<String, Map<String, Object>>();
            data.put("client", this.getClientInfo(AVOSCloud.applicationContext));
            data.put("attributes", requestData.toPostDataMap());
            PaasClient client = PaasClient.storageInstance();
            AsyncHttpClient asyncClient = client.clientInstance(true);
            String url = client.buildUrl("always_collect");
            try {
                ByteArrayEntity entity = new ByteArrayEntity(AVUtils.jsonStringFromMapWithNull(data).getBytes("UTF-8"));
                asyncClient.post(null, url, (HttpEntity)entity, "UTF-8", (ResponseHandlerInterface)new AsyncHttpResponseHandler(){

                    public void onSuccess(int statusCode, Header[] headers, byte[] body) {
                        if (200 == statusCode) {
                            RequestStatisticsUtil.this.updateLastSendTime();
                            RequestStatisticsUtil.this.requestStatistics.minus(requestData);
                            RequestStatisticsUtil.this.requestStatistics.saveToPreference();
                        }
                    }

                    public void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
                    }
                });
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else {
            this.updateLastSendTime();
        }
    }

    private boolean isNeedToSend() {
        return System.currentTimeMillis() > this.lastSendTime + (long)TIME_INTERVAL;
    }

    private void updateLastSendTime() {
        this.lastSendTime = System.currentTimeMillis();
        SharedPreferences preferences = AVOSCloud.applicationContext.getSharedPreferences(REQUEST_DATA, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putLong(LAST_SENDTIME, this.lastSendTime);
        editor.commit();
    }

    private void getLastSendTime() {
        SharedPreferences preferences = AVOSCloud.applicationContext.getSharedPreferences(REQUEST_DATA, 0);
        this.lastSendTime = preferences.getLong(LAST_SENDTIME, 0L);
        this.lastSendTime = preferences.getLong(LAST_SENDTIME, 0L);
    }

    private static class RequestStatistics {
        private static final String REQUEST_TOTAL_NUM = "request_total_num";
        private static final String REQUEST_TIMEOUT_NUM = "request_timeout_num";
        private static final String REQUEST_2xx_TOTAL_TIME = "request_2xx_total_time";
        private static final String REQUEST_2xx_NUM = "request_2xx_num";
        private static final String REQUEST_4xx_NUM = "request_4xx_num";
        private static final String REQUEST_5xx_NUM = "request_5xx_num";
        private int totalNum = 0;
        private int timeoutNum = 0;
        private int request2xxNum = 0;
        private int request4xxNum = 0;
        private int request5xxNum = 0;
        private long request2xxTotalTime = 0L;

        public RequestStatistics() {
            this.updateFromPreference();
        }

        public synchronized void addRequestData(int statusCode, boolean isTimeOut, long time) {
            ++this.totalNum;
            if (isTimeOut) {
                ++this.timeoutNum;
            } else if (statusCode > 100) {
                int beginCode = statusCode / 100;
                if (beginCode == 2) {
                    ++this.request2xxNum;
                    this.request2xxTotalTime += time;
                } else if (beginCode == 4) {
                    ++this.request4xxNum;
                } else if (beginCode == 5) {
                    ++this.request5xxNum;
                }
            }
        }

        public synchronized void minus(RequestStatistics requestStatistics) {
            if (requestStatistics != null) {
                this.totalNum -= requestStatistics.totalNum;
                this.timeoutNum -= requestStatistics.timeoutNum;
                this.request2xxNum -= requestStatistics.request2xxNum;
                this.request4xxNum -= requestStatistics.request4xxNum;
                this.request5xxNum -= requestStatistics.request5xxNum;
                this.request2xxTotalTime -= requestStatistics.request2xxTotalTime;
            }
        }

        public synchronized void saveToPreference() {
            SharedPreferences preferences = AVOSCloud.applicationContext.getSharedPreferences(RequestStatisticsUtil.REQUEST_DATA, 0);
            SharedPreferences.Editor editor = preferences.edit();
            editor.putInt(REQUEST_TIMEOUT_NUM, this.timeoutNum);
            editor.putInt(REQUEST_TOTAL_NUM, this.totalNum);
            editor.putInt(REQUEST_2xx_NUM, this.request2xxNum);
            editor.putInt(REQUEST_4xx_NUM, this.request4xxNum);
            editor.putInt(REQUEST_5xx_NUM, this.request5xxNum);
            editor.putLong(REQUEST_2xx_TOTAL_TIME, this.request2xxTotalTime);
            editor.commit();
        }

        public synchronized Map<String, Object> toPostDataMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("total", this.totalNum);
            map.put("timeout", this.timeoutNum);
            map.put("2xx", this.request2xxNum);
            map.put("4xx", this.request4xxNum);
            map.put("5xx", this.request5xxNum);
            map.put("avg", 0 == this.request2xxNum ? 0L : this.request2xxTotalTime / (long)this.request2xxNum);
            return map;
        }

        private synchronized void updateFromPreference() {
            SharedPreferences preferences = AVOSCloud.applicationContext.getSharedPreferences(RequestStatisticsUtil.REQUEST_DATA, 0);
            this.timeoutNum = preferences.getInt(REQUEST_TIMEOUT_NUM, 0);
            this.totalNum = preferences.getInt(REQUEST_TOTAL_NUM, 0);
            this.request2xxNum = preferences.getInt(REQUEST_2xx_NUM, 0);
            this.request4xxNum = preferences.getInt(REQUEST_4xx_NUM, 0);
            this.request5xxNum = preferences.getInt(REQUEST_5xx_NUM, 0);
            this.request2xxTotalTime = preferences.getLong(REQUEST_2xx_TOTAL_TIME, 0L);
        }
    }
}

