/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.AVFile;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVUploader;
import com.avos.avoscloud.ProgressCallback;
import com.avos.avoscloud.SaveCallback;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public abstract class HttpClientUploader
extends AVUploader {
    protected static DefaultHttpClient httpClient;
    protected final AtomicReference<HttpPost> httpPostRef = new AtomicReference();
    private static AtomicInteger counter;

    protected HttpClientUploader(AVFile parseFile, SaveCallback saveCallback, ProgressCallback progressCallback) {
        super(parseFile, saveCallback, progressCallback);
    }

    protected static synchronized DefaultHttpClient getHttpClient() {
        if (httpClient != null) {
            return httpClient;
        }
        BasicHttpParams params = new BasicHttpParams();
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        SSLSocketFactory sslSocketFactory = SSLSocketFactory.getSocketFactory();
        schemeRegistry.register(new Scheme("https", (SocketFactory)sslSocketFactory, 443));
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)AVOSCloud.getNetworkTimeout());
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)AVOSCloud.getNetworkTimeout());
        HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)true);
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
        httpClient = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)params);
        return httpClient;
    }

    @Override
    public void interruptImmediately() {
        HttpPost httpPost = this.httpPostRef.get();
        if (httpPost != null) {
            httpPost.abort();
        }
        super.interruptImmediately();
    }

    protected void closeExpiredConnections() {
        if (counter.incrementAndGet() % 10 == 0) {
            try {
                if (httpClient != null && httpClient.getConnectionManager() != null) {
                    httpClient.getConnectionManager().closeExpiredConnections();
                    httpClient.getConnectionManager().closeIdleConnections(60L, TimeUnit.SECONDS);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        counter = new AtomicInteger(0);
    }
}

