/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.os.Looper;
import com.avos.avoscloud.AVCacheManager;
import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVQuery;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.ArchiveRequestTaskController;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.RequestStatisticsUtil;
import com.loopj.android.http.AsyncHttpResponseHandler;
import org.apache.http.Header;

public class GetHttpResponseHandler
extends AsyncHttpResponseHandler {
    private GenericObjectCallback callback;
    private String absoluteURLString;
    private AVQuery.CachePolicy policy = AVQuery.CachePolicy.IGNORE_CACHE;
    private long requestStartTime = 0L;

    public GetHttpResponseHandler(GenericObjectCallback cb) {
        super(Looper.getMainLooper());
        this.callback = cb;
    }

    public GetHttpResponseHandler(GenericObjectCallback cb, AVQuery.CachePolicy policy, String absoluteURLString) {
        this(cb);
        this.policy = policy;
        this.absoluteURLString = absoluteURLString;
    }

    void setCallback(GenericObjectCallback cb) {
        this.callback = cb;
    }

    GenericObjectCallback getCallback() {
        return this.callback;
    }

    private boolean isNotModifiedStatus(int code) {
        return code == 304;
    }

    private boolean isUnAuthorize(int code) {
        return code == 401;
    }

    private void tryLastModifyCache(String lastModifiedValue) {
        if (this.getCallback() == null) {
            return;
        }
        if (lastModifiedValue == null) {
            LogUtil.log.d("null last-modified value");
        } else if (PaasClient.getLastModify(this.absoluteURLString) == null) {
            PaasClient.updateLastModify(this.absoluteURLString, lastModifiedValue);
        }
        AVCacheManager.sharedInstance().get(this.absoluteURLString, Long.MAX_VALUE, lastModifiedValue, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                GetHttpResponseHandler.this.getCallback().onSuccess(content, null);
            }

            @Override
            public void onFailure(Throwable error, String content) {
                PaasClient.removeLastModifyForUrl(GetHttpResponseHandler.this.absoluteURLString);
                GetHttpResponseHandler.this.getCallback().onFailure(error, content);
            }
        });
    }

    public void onStart() {
        super.onStart();
        this.requestStartTime = System.currentTimeMillis();
    }

    public void onSuccess(int statusCode, Header[] headers, byte[] body) {
        String contentType;
        long timeInterval = System.currentTimeMillis() - this.requestStartTime;
        RequestStatisticsUtil.getInstance().recordRequestTime(statusCode, false, timeInterval);
        String content = AVUtils.stringFromBytes(body);
        if (AVOSCloud.isDebugLogEnabled()) {
            LogUtil.avlog.d(content);
        }
        if (AVUtils.checkResponseType(statusCode, content, contentType = PaasClient.extractContentType(headers), this.getCallback())) {
            return;
        }
        int code = AVErrorUtils.errorCode(content);
        if (code > 0) {
            if (this.getCallback() != null) {
                this.getCallback().onFailure(AVErrorUtils.createException(code, content), content);
            }
            return;
        }
        if (this.policy != AVQuery.CachePolicy.IGNORE_CACHE && !AVUtils.isBlankString(this.absoluteURLString)) {
            AVCacheManager.sharedInstance().save(this.absoluteURLString, content, null);
        }
        if (!AVUtils.isBlankString(this.absoluteURLString) && PaasClient.isLastModifyEnabled()) {
            String lastModify = PaasClient.lastModifyFromHeaders(headers);
            if (AVCacheManager.sharedInstance().save(this.absoluteURLString, content, lastModify)) {
                PaasClient.updateLastModify(this.absoluteURLString, lastModify);
            }
        }
        if (this.getCallback() != null) {
            this.getCallback().onSuccess(content, null);
        }
        ArchiveRequestTaskController.schedule();
    }

    public void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
        String contentType;
        long timeInterval = System.currentTimeMillis() - this.requestStartTime;
        RequestStatisticsUtil.getInstance().recordRequestTime(statusCode, statusCode == 0, timeInterval);
        String content = AVUtils.stringFromBytes(responseBody);
        if (this.isNotModifiedStatus(statusCode)) {
            if (AVOSCloud.showInternalDebugLog()) {
                LogUtil.avlog.i("Last modify matched.");
            }
            String lastModifiedValue = PaasClient.lastModifyFromHeaders(headers);
            this.tryLastModifyCache(lastModifiedValue);
            return;
        }
        if (this.isUnAuthorize(statusCode)) {
            LogUtil.avlog.e(content + "\nerror:" + error + " for request:" + this.absoluteURLString);
        }
        if (AVOSCloud.isDebugLogEnabled()) {
            LogUtil.avlog.e(content + "\nerror:" + error);
        }
        if (AVUtils.checkResponseType(statusCode, content, contentType = PaasClient.extractContentType(headers), this.getCallback())) {
            return;
        }
        if (this.getCallback() != null) {
            this.getCallback().onFailure(statusCode, error, content);
        }
    }
}

