/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVQuery;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.GenericRetryCallback;
import com.avos.avoscloud.PaasClient;
import com.loopj.android.http.RequestParams;
import java.util.Map;

class DataFetchCallbackWithFailureRetry<T extends AVObject>
extends GenericRetryCallback {
    boolean retry = true;
    String relativePath;
    RequestParams parameters;
    boolean sync;
    Map<String, String> inputHeader;
    AVQuery.CachePolicy policy;

    public DataFetchCallbackWithFailureRetry(String relativePath, RequestParams parameters, boolean sync, Map<String, String> inputHeader, GenericObjectCallback callback, AVQuery.CachePolicy policy) {
        super(callback);
        this.relativePath = relativePath;
        this.parameters = parameters;
        this.sync = sync;
        this.inputHeader = inputHeader;
        this.callback = callback;
        this.policy = policy;
    }

    @Override
    public boolean isRetryNeeded(int statusCode, Throwable error) {
        return this.retry && error != null && this.isLastModifyCacheMissingError(error.getMessage());
    }

    @Override
    public void retry(Throwable error, String content) {
        PaasClient.storageInstance().getObject(this.relativePath, this.parameters, this.sync, this.inputHeader, this.callback, this.policy, false, false);
    }

    @Override
    public void onFailure(Throwable error, String content) {
        if (this.retry && error != null && this.isLastModifyCacheMissingError(error.getMessage())) {
            this.retry = false;
            PaasClient.storageInstance().getObject(this.relativePath, this.parameters, this.sync, this.inputHeader, this.callback, this.policy, false);
        } else if (this.callback != null) {
            this.callback.onFailure(error, content);
        }
    }

    private boolean isLastModifyCacheMissingError(String errorString) {
        return "Cache Missing".equalsIgnoreCase(errorString);
    }
}

