/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.Looper;
import android.util.Base64;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVFile;
import com.avos.avoscloud.AVGeoPoint;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVPersistenceUtils;
import com.avos.avoscloud.AVPowerfulUtils;
import com.avos.avoscloud.AVRole;
import com.avos.avoscloud.AVRuntimeException;
import com.avos.avoscloud.AVUser;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.JSONHelper;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.RequestParams;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

@SuppressLint(value={"NewApi"})
public class AVUtils {
    private static final String dateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String classNameTag = "className";
    public static final String typeTag = "__type";
    public static final String objectIdTag = "objectId";
    private static Map<Class<?>, Field[]> fieldsMap = Collections.synchronizedMap(new WeakHashMap());
    static Pattern pattern = Pattern.compile("^[a-zA-Z_][a-zA-Z_0-9]*$");
    static Pattern emailPattern = Pattern.compile("^\\w+?@\\w+?[.]\\w+");
    static Pattern phoneNumPattern = Pattern.compile("1\\d{10}");
    static Pattern verifyCodePattern = Pattern.compile("\\d{6}");
    private static final ThreadLocal<SimpleDateFormat> THREAD_LOCAL_DATE_FORMAT = new ThreadLocal();
    static Random random = new Random();
    static AtomicInteger acu = new AtomicInteger(-65536);
    public static final int TYPE_WIFI = 1;
    public static final int TYPE_MOBILE = 2;
    public static final int TYPE_NOT_CONNECTED = 0;

    public static Map<String, Object> createArrayOpMap(String key, String op, Collection<?> objects) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("__op", op);
        ArrayList<Object> array = new ArrayList<Object>();
        for (Object obj : objects) {
            array.add(AVUtils.getParsedObject(obj));
        }
        map.put("objects", array);
        HashMap<String, Object> ops = new HashMap<String, Object>();
        ops.put(key, map);
        return ops;
    }

    public static Field[] getAllFiels(Class<?> clazz) {
        if (clazz == null || clazz == Object.class) {
            return new Field[0];
        }
        Field[] theResult = fieldsMap.get(clazz);
        if (theResult != null) {
            return theResult;
        }
        ArrayList<Field[]> fields = new ArrayList<Field[]>();
        int length = 0;
        while (clazz != null && clazz != Object.class) {
            Field[] declaredFields = clazz.getDeclaredFields();
            length += declaredFields != null ? declaredFields.length : 0;
            fields.add(declaredFields);
            clazz = clazz.getSuperclass();
        }
        theResult = new Field[length];
        int i = 0;
        for (Field[] someFields : fields) {
            if (someFields == null) continue;
            for (Field field : someFields) {
                field.setAccessible(true);
            }
            System.arraycopy(someFields, 0, theResult, i, someFields.length);
            i += someFields.length;
        }
        fieldsMap.put(clazz, theResult);
        return theResult;
    }

    public static boolean checkEmailAddress(String email) {
        return emailPattern.matcher(email).find();
    }

    public static boolean checkMobilePhoneNumber(String phoneNumber) {
        return phoneNumPattern.matcher(phoneNumber).find();
    }

    public static boolean checkMobileVerifyCode(String verifyCode) {
        return verifyCodePattern.matcher(verifyCode).find();
    }

    public static void checkClassName(String className) {
        if (AVUtils.isBlankString(className)) {
            throw new IllegalArgumentException("Blank class name");
        }
        if (!pattern.matcher(className).matches()) {
            throw new IllegalArgumentException("Invalid class name");
        }
    }

    public static boolean isBlankString(String str) {
        return str == null || str.trim().equals("");
    }

    public static boolean isBlankContent(String content) {
        return AVUtils.isBlankString(content) || content.trim().equals("{}");
    }

    public static boolean contains(Map<String, Object> map, String key) {
        return map.containsKey(key);
    }

    public static Map<String, Object> createDeleteOpMap(String key) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("__op", "Delete");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(key, map);
        return result;
    }

    public static Map<String, Object> createPointerArrayOpMap(String key, String op, Collection<AVObject> objects) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("__op", op);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (AVObject obj : objects) {
            list.add(AVUtils.mapFromPointerObject(obj));
        }
        map.put("objects", list);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(key, map);
        return result;
    }

    public static Map<String, Object> createStringObjectMap(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        return map;
    }

    public static Map<String, Object> mapFromPointerObject(AVObject object) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(typeTag, "Pointer");
        result.put(classNameTag, object.internalClassName());
        if (!AVUtils.isBlankString(object.getObjectId())) {
            result.put(objectIdTag, object.getObjectId());
        }
        return result;
    }

    public static Map<String, Object> mapFromUserObjectId(String userObjectId) {
        if (AVUtils.isBlankString(userObjectId)) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(typeTag, "Pointer");
        result.put(classNameTag, "_User");
        result.put(objectIdTag, userObjectId);
        return result;
    }

    public static Map<String, String> mapFromChildObject(AVObject object, String key) {
        String cid = object.internalId();
        HashMap<String, String> child = new HashMap<String, String>(3);
        child.put("cid", cid);
        child.put(classNameTag, object.getClassName());
        child.put("key", key);
        return child;
    }

    public static boolean isDigitString(String s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static Date dateFromString(String content) {
        if (AVUtils.isBlankString(content)) {
            return null;
        }
        if (AVUtils.isDigitString(content)) {
            return new Date(Long.parseLong(content));
        }
        Date date = null;
        SimpleDateFormat format = THREAD_LOCAL_DATE_FORMAT.get();
        if (format == null) {
            format = new SimpleDateFormat(dateFormat);
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            THREAD_LOCAL_DATE_FORMAT.set(format);
        }
        try {
            date = format.parse(content);
        }
        catch (Exception exception) {
            LogUtil.log.e(exception.toString());
        }
        return date;
    }

    public static String stringFromDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(dateFormat);
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        String isoDate = df.format(date);
        return isoDate;
    }

    public static Map<String, Object> mapFromDate(Date date) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(typeTag, "Date");
        result.put("iso", AVUtils.stringFromDate(date));
        return result;
    }

    public static Date dateFromMap(Map<String, Object> map) {
        String value = (String)map.get("iso");
        return AVUtils.dateFromString(value);
    }

    public static Map<String, Object> mapFromGeoPoint(AVGeoPoint point) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(typeTag, "GeoPoint");
        result.put("latitude", point.getLatitude());
        result.put("longitude", point.getLongitude());
        return result;
    }

    public static AVGeoPoint geoPointFromMap(Map<String, Object> map) {
        double la = ((Number)map.get("latitude")).doubleValue();
        double lo = ((Number)map.get("longitude")).doubleValue();
        AVGeoPoint point = new AVGeoPoint(la, lo);
        return point;
    }

    public static AVObject objectFromRelationMap(Map<String, Object> map) {
        String className = (String)map.get(classNameTag);
        AVObject object = AVUtils.objectFromClassName(className);
        return object;
    }

    public static Map<String, Object> mapFromByteArray(byte[] data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(typeTag, "Bytes");
        result.put("base64", Base64.encodeToString((byte[])data, (int)2));
        return result;
    }

    public static byte[] dataFromMap(Map<String, Object> map) {
        String value = (String)map.get("base64");
        return Base64.decode((String)value, (int)2);
    }

    public static String jsonStringFromMapWithNull(Object map) {
        if (AVOSCloud.showInternalDebugLog()) {
            return JSON.toJSONString((Object)map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.PrettyFormat});
        }
        return JSON.toJSONString((Object)map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.WriteNullNumberAsZero});
    }

    public static String jsonStringFromObjectWithNull(Object map) {
        if (AVOSCloud.showInternalDebugLog()) {
            return JSON.toJSONString((Object)map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.PrettyFormat});
        }
        return JSON.toJSONString((Object)map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.WriteNullNumberAsZero});
    }

    public static Map<String, Object> mapFromFile(AVFile file) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(typeTag, AVFile.className());
        result.put("metaData", file.getMetaData());
        switch (AVOSCloud.getStorageType()) {
            case StorageTypeAV: {
                result.put("name", file.getName());
                break;
            }
            case StorageTypeQiniu: 
            case StorageTypeS3: {
                result.put("id", file.getName());
                break;
            }
        }
        return result;
    }

    public static AVFile fileFromMap(Map<String, Object> map) {
        AVFile file = new AVFile("", "");
        AVUtils.copyPropertiesFromMapToObject(map, file);
        Object metadata = map.get("metaData");
        if (metadata != null && metadata instanceof Map) {
            file.getMetaData().putAll((Map)metadata);
        }
        if (AVUtils.isBlankString((String)file.getMetaData("_name"))) {
            file.getMetaData().put("_name", file.getName());
        }
        switch (AVOSCloud.getStorageType()) {
            case StorageTypeAV: {
                break;
            }
            case StorageTypeQiniu: 
            case StorageTypeS3: {
                file.setName((String)map.get(objectIdTag));
                break;
            }
        }
        return file;
    }

    public static AVObject parseObjectFromMap(Map<String, Object> map) {
        AVObject object = AVUtils.newAVObjectByClassName((String)map.get(classNameTag));
        object.setObjectId((String)map.get(objectIdTag));
        AVUtils.copyPropertiesFromMapToAVObject(map, object);
        return object;
    }

    public static String restfulServerData(Map<String, ?> data) {
        if (data == null) {
            return "{}";
        }
        Map<String, Object> map = AVUtils.getParsedMap(data);
        return AVUtils.jsonStringFromMapWithNull(map);
    }

    public static boolean hasProperty(Class<?> clazz, String property) {
        Field[] fields;
        for (Field f : fields = AVUtils.getAllFiels(clazz)) {
            if (!f.getName().equals(property)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkAndSetValue(Class<?> clazz, Object parent, String property, Object value) {
        if (clazz == null) {
            return false;
        }
        try {
            Field[] fields;
            for (Field f : fields = AVUtils.getAllFiels(clazz)) {
                if (!f.getName().equals(property) || !f.getType().isInstance(value) && value != null) continue;
                f.set(parent, value);
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void updatePropertyFromMap(AVObject parent, String key, Map<String, Object> map) {
        String objectId = (String)map.get(objectIdTag);
        String type = (String)map.get(typeTag);
        if (type == null && objectId == null) {
            parent.put(key, map, false);
            return;
        }
        if (AVUtils.isGeoPoint(type)) {
            AVGeoPoint point = AVUtils.geoPointFromMap(map);
            parent.put(key, point, false);
        } else if (AVUtils.isDate(type)) {
            Date date = AVUtils.dateFromMap(map);
            parent.put(key, date, false);
        } else if (AVUtils.isData(type)) {
            byte[] data = AVUtils.dataFromMap(map);
            parent.put(key, data, false);
        } else if (AVUtils.isFile(type)) {
            AVFile file = AVUtils.fileFromMap(map);
            parent.put(key, file, false);
        } else if (AVUtils.isFileFromUrulu(map)) {
            AVFile file = AVUtils.fileFromMap(map);
            parent.put(key, file, false);
        } else if (AVUtils.isRelation(type)) {
            parent.addRelationFromServer(key, (String)map.get(classNameTag), false);
        } else if (AVUtils.isPointer(type) || !AVUtils.isBlankString(objectId) && type != null) {
            AVObject object = AVUtils.parseObjectFromMap(map);
            parent.put(key, object, false);
        } else {
            parent.put(key, map, false);
        }
    }

    public static void updatePropertyFromList(AVObject object, String key, Collection<Object> list) {
        List data = AVUtils.getObjectFrom(list);
        object.put(key, data, false);
    }

    public static void copyPropertiesFromJsonStringToAVObject(String content, AVObject object) {
        if (AVUtils.isBlankString(content)) {
            return;
        }
        try {
            Map<String, Object> map = JSONHelper.mapFromString(content);
            AVUtils.copyPropertiesFromMapToAVObject(map, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void copyPropertiesFromMapToAVObject(Map<String, Object> map, AVObject object) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            if (key != null && key.startsWith("_")) continue;
            Object valueObject = entry.getValue();
            if (AVUtils.checkAndSetValue(object.getClass(), object, key, valueObject)) {
                if (key.startsWith("_") || AVObject.INVALID_KEYS.contains(key)) continue;
                object.put(key, valueObject, false);
                continue;
            }
            if (valueObject instanceof Collection) {
                AVUtils.updatePropertyFromList(object, key, (Collection)valueObject);
                continue;
            }
            if (valueObject instanceof Map) {
                AVUtils.updatePropertyFromMap(object, key, (Map)valueObject);
                continue;
            }
            if (key.startsWith("_")) continue;
            object.put(key, valueObject, false);
        }
    }

    public static void copyPropertiesFromMapToObject(Map<String, Object> map, Object object) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object valueObject = entry.getValue();
            if (!AVUtils.checkAndSetValue(object.getClass(), object, key, valueObject)) continue;
        }
    }

    public static Class getClass(Map<String, ?> map) {
        Object type = map.get(typeTag);
        if (type == null || !(type instanceof String)) {
            return Map.class;
        }
        if (type.equals("Pointer")) {
            return AVObject.class;
        }
        if (type.equals("GeoPoint")) {
            return AVGeoPoint.class;
        }
        if (type.equals("Bytes")) {
            return byte[].class;
        }
        if (type.equals("Date")) {
            return Date.class;
        }
        return Map.class;
    }

    public static boolean isRelation(String type) {
        return type != null && type.equals("Relation");
    }

    public static boolean isPointer(String type) {
        return type != null && type.equals("Pointer");
    }

    public static boolean isGeoPoint(String type) {
        return type != null && type.equals("GeoPoint");
    }

    public static boolean isACL(String type) {
        return type != null && type.equals("ACL");
    }

    public static boolean isDate(String type) {
        return type != null && type.equals("Date");
    }

    public static boolean isData(String type) {
        return type != null && type.equals("Bytes");
    }

    public static boolean isFile(String type) {
        return type != null && type.equals("File");
    }

    public static boolean isFileFromUrulu(Map<String, Object> map) {
        boolean result = true;
        return result &= map.get("mime_type") != null;
    }

    public static AVObject objectFromClassName(String className) {
        if (className.equals(AVPowerfulUtils.getAVClassName(AVUser.class.getSimpleName()))) {
            return AVUser.newAVUser();
        }
        AVObject object = AVUtils.newAVObjectByClassName(className);
        return object;
    }

    public static AVObject newAVObjectByClassName(String name) {
        if (name.equals("_Role")) {
            return new AVRole();
        }
        if (name.equals(AVUser.userClassName())) {
            return AVUser.newAVUser();
        }
        Class<? extends AVObject> subClazz = AVObject.getSubClass(name);
        if (subClazz != null) {
            try {
                return subClazz.newInstance();
            }
            catch (Exception e) {
                throw new AVRuntimeException("New subclass instance failed.", e);
            }
        }
        return new AVObject(name);
    }

    public static Class<? extends AVObject> getAVObjectClassByClassName(String name) {
        if (name.equals("_Role")) {
            return AVRole.class;
        }
        if (name.equals(AVUser.userClassName())) {
            return AVUser.class;
        }
        Class<? extends AVObject> subClazz = AVObject.getSubClass(name);
        return subClazz;
    }

    public static AVObject newAVObjectByClassName(String className, String defaultClassName) {
        String objectClassName = AVUtils.isBlankString(className) ? defaultClassName : className;
        return AVUtils.newAVObjectByClassName(objectClassName);
    }

    public static final <T> T getFromJSON(String json, Class<T> clazz) {
        return (T)JSON.parseObject((String)json, clazz);
    }

    public static final <T> String toJSON(T clazz) {
        if (AVOSCloud.showInternalDebugLog()) {
            return JSON.toJSONString(clazz, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
        }
        return JSON.toJSONString(clazz);
    }

    static Map<String, Object> getParsedMap(Map<String, Object> map) {
        HashMap<String, Object> newMap = new HashMap<String, Object>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object o = entry.getValue();
            newMap.put(key, AVUtils.getParsedObject(o));
        }
        return newMap;
    }

    static List getParsedList(Collection list) {
        ArrayList<Object> newList = new ArrayList<Object>(list.size());
        for (Object o : list) {
            newList.add(AVUtils.getParsedObject(o));
        }
        return newList;
    }

    public static Object getParsedObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Map) {
            return AVUtils.getParsedMap((Map)object);
        }
        if (object instanceof Collection) {
            return AVUtils.getParsedList((Collection)object);
        }
        if (object instanceof AVObject) {
            return AVUtils.mapFromPointerObject((AVObject)object);
        }
        if (object instanceof AVGeoPoint) {
            return AVUtils.mapFromGeoPoint((AVGeoPoint)object);
        }
        if (object instanceof Date) {
            return AVUtils.mapFromDate((Date)object);
        }
        if (object instanceof byte[]) {
            return AVUtils.mapFromByteArray((byte[])object);
        }
        if (object instanceof AVFile) {
            return AVUtils.mapFromFile((AVFile)object);
        }
        if (object instanceof JSONObject) {
            return JSON.parse((String)object.toString());
        }
        if (object instanceof JSONArray) {
            return JSON.parse((String)object.toString());
        }
        return object;
    }

    static List getObjectFrom(Collection list) {
        ArrayList<Object> newList = new ArrayList<Object>();
        for (Object obj : list) {
            newList.add(AVUtils.getObjectFrom(obj));
        }
        return newList;
    }

    static Object getObjectFrom(Map<String, Object> map) {
        Object type = map.get(typeTag);
        if (type == null || !(type instanceof String)) {
            HashMap<String, Object> newMap = new HashMap<String, Object>(map.size());
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object o = entry.getValue();
                newMap.put(key, AVUtils.getObjectFrom(o));
            }
            return newMap;
        }
        if (type.equals("Pointer") || type.equals("Object")) {
            AVObject parseObject = AVUtils.objectFromClassName((String)map.get(classNameTag));
            map.remove(typeTag);
            AVUtils.copyPropertiesFromMapToAVObject(map, parseObject);
            return parseObject;
        }
        if (type.equals("GeoPoint")) {
            return AVUtils.geoPointFromMap(map);
        }
        if (type.equals("Bytes")) {
            return AVUtils.dataFromMap(map);
        }
        if (type.equals("Date")) {
            return AVUtils.dateFromMap(map);
        }
        if (type.equals("Relation")) {
            return AVUtils.objectFromRelationMap(map);
        }
        if (type.equals("File")) {
            return AVUtils.fileFromMap(map);
        }
        return map;
    }

    static Object getObjectFrom(Object obj) {
        if (obj instanceof Collection) {
            return AVUtils.getObjectFrom((Collection)obj);
        }
        if (obj instanceof Map) {
            return AVUtils.getObjectFrom((Map)obj);
        }
        return obj;
    }

    public static String md5(String string) {
        byte[] hash = null;
        try {
            hash = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Huh,UTF-8 should be supported?", e);
        }
        return AVUtils.computeMD5(hash);
    }

    public static String getRandomString(int length) {
        String letters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuilder randomString = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            randomString.append(letters.charAt(random.nextInt(letters.length())));
        }
        return randomString.toString();
    }

    public static int getNextIMRequestId() {
        int val = acu.incrementAndGet();
        if (val > 65535) {
            while (val > 65535 && !acu.compareAndSet(val, -65536)) {
                val = acu.get();
            }
            return val;
        }
        return val;
    }

    public static boolean isWifi(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetInfo != null && activeNetInfo.getType() == 1;
    }

    public static boolean isConnected(Context context) {
        try {
            ConnectivityManager conMgr = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo activeNetwork = conMgr.getActiveNetworkInfo();
            if (activeNetwork != null && activeNetwork.isConnected()) {
                return true;
            }
        }
        catch (SecurityException e) {
            LogUtil.log.e("Please add ACCESS_NETWORK_STATE permission in your manifest", e);
            return true;
        }
        catch (Exception e) {
            LogUtil.log.e("Exception: ", e);
        }
        return false;
    }

    public static long getCurrentTimestamp() {
        return System.currentTimeMillis();
    }

    public static String joinCollection(Collection<String> collection, String separator) {
        StringBuilder builder = new StringBuilder();
        boolean wasFirst = true;
        for (String value : collection) {
            if (wasFirst) {
                wasFirst = false;
                builder.append(value);
                continue;
            }
            builder.append(separator).append(value);
        }
        return builder.toString();
    }

    public static String stringFromBytes(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean checkPermission(Context context, String permission) {
        if (context == null) {
            LogUtil.log.e("context is null");
            return false;
        }
        return 0 == context.checkCallingOrSelfPermission(permission);
    }

    public static boolean isPushServiceAvailable(Context context, Class cls) {
        Intent intent;
        PackageManager packageManager = context.getPackageManager();
        List resolveInfo = packageManager.queryIntentServices(intent = new Intent(context, cls), 65536);
        return resolveInfo.size() > 0;
    }

    public static boolean isMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static String fileMd5(String fileName) throws IOException {
        return AVUtils.computeMD5(AVUtils.readFile(fileName));
    }

    public static byte[] readFile(String file) throws IOException {
        return AVUtils.readFile(new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(File file) throws IOException {
        RandomAccessFile f = new RandomAccessFile(file, "r");
        try {
            long longlength = f.length();
            int length = (int)longlength;
            if ((long)length != longlength) {
                throw new IOException("File size >= 2 GB");
            }
            byte[] data = new byte[length];
            f.readFully(data);
            byte[] byArray = data;
            return byArray;
        }
        finally {
            AVPersistenceUtils.closeQuietly(f);
        }
    }

    public static String computeMD5(byte[] input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(input, 0, input.length);
            byte[] md5bytes = md.digest();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < md5bytes.length; ++i) {
                String hex = Integer.toHexString(0xFF & md5bytes[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    static String getJSONString(com.alibaba.fastjson.JSONObject object, String key, String defaultValue) {
        if (object.containsKey((Object)key)) {
            return object.getString(key);
        }
        return defaultValue;
    }

    static long getJSONInteger(com.alibaba.fastjson.JSONObject object, String key, long defaultValue) {
        if (object.containsKey((Object)key)) {
            return object.getInteger(key).intValue();
        }
        return defaultValue;
    }

    public static int getConnectivityStatus(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        if (null != activeNetwork) {
            if (!activeNetwork.isConnected()) {
                return 0;
            }
            if (activeNetwork.getType() == 1) {
                return 1;
            }
            if (activeNetwork.getType() == 0) {
                return 2;
            }
        }
        return 0;
    }

    public static String getConnectivityStatusString(Context context) {
        int conn = AVUtils.getConnectivityStatus(context);
        String status = null;
        if (conn == 1) {
            status = "Wifi enabled";
        } else if (conn == 2) {
            status = "Mobile data enabled";
        } else if (conn == 0) {
            status = "Not connected to Internet";
        }
        return status;
    }

    public static String getArchiveRequestFileName(String objectId, String _internalId, String method, String relativePath, String paramString) {
        if (method.equalsIgnoreCase("put")) {
            return AVUtils.md5(relativePath + paramString);
        }
        if (method.equalsIgnoreCase("post")) {
            return _internalId;
        }
        if (method.equalsIgnoreCase("delete")) {
            return AVUtils.isBlankString(objectId) ? _internalId : AVUtils.md5(relativePath + paramString);
        }
        return AVUtils.md5(relativePath + paramString);
    }

    public static int collectionNonNullCount(Collection collection) {
        int count = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() == null) continue;
            ++count;
        }
        return count;
    }

    public static String urlCleanLastSlash(String url) {
        if (!AVUtils.isBlankString(url) && url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static String getSessionKey(String selfId) {
        StringBuilder sb = new StringBuilder(AVOSCloud.applicationId);
        sb.append(selfId);
        return sb.toString();
    }

    public static boolean isEmptyList(List e) {
        return e == null || e.isEmpty();
    }

    public static void ensureElementsNotNull(List<String> e, String errorLog) {
        for (String i : e) {
            if (i != null) continue;
            throw new NullPointerException(errorLog);
        }
    }

    public static boolean compareNumberString(String firstNumber, String secondNumber) {
        return Double.compare(Double.parseDouble(firstNumber), Double.parseDouble(secondNumber)) == 1;
    }

    public static String Base64Encode(String data) {
        return Base64.encodeToString((byte[])data.getBytes(), (int)10);
    }

    public static AsyncHttpClient getDirectlyClientForUse() {
        return PaasClient.storageInstance().clientInstance(false);
    }

    public static Handler getUIThreadHandler() {
        return AVOSCloud.handler;
    }

    public static Map<String, Object> createMap(String cmp, Object value) {
        HashMap<String, Object> dict = new HashMap<String, Object>();
        dict.put(cmp, value);
        return dict;
    }

    public static boolean checkResponseType(int statusCode, String content, String contentType, GenericObjectCallback callback) {
        if (statusCode > 0 && !PaasClient.isJSONResponse(contentType)) {
            if (callback != null) {
                callback.onFailure(statusCode, new AVException(107, "Wrong response content type:" + contentType), content);
            }
            return true;
        }
        return false;
    }

    public static boolean checkDNSException(int statusCode, Throwable throwable) {
        return AVUtils.isConnected(AVOSCloud.applicationContext) && statusCode == 0 && throwable instanceof IOException && throwable.getMessage() != null && throwable.getMessage().toLowerCase().contains("unknownhostexception");
    }

    public static String getHostName(String url) throws URISyntaxException {
        URI uri = new URI(url);
        String domain = uri.getHost();
        return domain.startsWith("www.") ? domain.substring(4) : domain;
    }

    public static String getAVObjectClassName(Class<? extends AVObject> clazz) {
        return AVObject.getSubClassName(clazz);
    }

    public static String getAVObjectCreatedAt(AVObject object) {
        return object.createdAt;
    }

    public static String getAVObjectUpdatedAt(AVObject object) {
        return object.updatedAt;
    }

    public static String getEncodeUrl(String url, Map<String, String> params) {
        return AsyncHttpClient.getUrlWithQueryString((boolean)true, (String)url, (RequestParams)new RequestParams(params));
    }

    public static String getJSONValue(String msg, String key) {
        Map jsonMap = (Map)JSON.parseObject((String)msg, HashMap.class);
        if (jsonMap == null || jsonMap.isEmpty()) {
            return null;
        }
        Object action = jsonMap.get(key);
        return action != null ? action.toString() : null;
    }
}

