/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.alibaba.fastjson.annotation.JSONType;
import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVQuery;
import com.avos.avoscloud.AVUtils;
import java.util.Collection;
import java.util.HashMap;

@JSONType(ignores={"query", "parent"})
public class AVRelation<T extends AVObject> {
    private String key;
    private AVObject parent;
    private String targetClass;

    public AVRelation() {
    }

    AVRelation(AVObject parent, String key) {
        this.parent = parent;
        this.key = key;
    }

    AVRelation(String targetClass) {
        this(null, null);
        this.targetClass = targetClass;
    }

    public void add(T object) {
        if (object == null) {
            throw new IllegalArgumentException("null AVObject");
        }
        if (AVUtils.isBlankString(this.targetClass)) {
            this.targetClass = ((AVObject)object).getClassName();
        }
        if (!AVUtils.isBlankString(this.targetClass) && !this.targetClass.equals(((AVObject)object).getClassName())) {
            throw new IllegalArgumentException("Could not add class '" + ((AVObject)object).getClassName() + "' to this relation,expect class is '" + this.targetClass + "'");
        }
        this.parent.addRelation((AVObject)object, this.key, true);
    }

    public void addAll(Collection<T> objects) {
        if (objects != null) {
            for (AVObject obj : objects) {
                this.add(obj);
            }
        }
    }

    public void remove(AVObject object) {
        this.parent.removeRelation(object, this.key, true);
    }

    public AVQuery<T> getQuery() {
        return this.getQuery(null);
    }

    public AVQuery<T> getQuery(Class<T> clazz) {
        if (this.getParent() == null || AVUtils.isBlankString(this.getParent().getObjectId())) {
            throw new IllegalStateException("unable to encode an association with an unsaved AVObject");
        }
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("object", AVUtils.mapFromPointerObject(AVRelation.this.getParent()));
                this.put("key", AVRelation.this.getKey());
            }
        };
        HashMap<String, 1> result = new HashMap<String, 1>();
        result.put("$relatedTo", map);
        String targetClassName = this.getTargetClass();
        if (AVUtils.isBlankString(this.getTargetClass())) {
            targetClassName = this.getParent().getClassName();
        }
        AVQuery<T> query = new AVQuery<T>(targetClassName, clazz);
        query.addWhereItem("$relatedTo", null, map);
        if (AVUtils.isBlankString(this.getTargetClass())) {
            query.getParameters().put("redirectClassNameForKey", this.getKey());
        }
        return query;
    }

    public static <M extends AVObject> AVQuery<M> reverseQuery(String parentClassName, String relationKey, AVObject child) {
        AVQuery query = new AVQuery(parentClassName);
        query.whereEqualTo(relationKey, AVUtils.mapFromPointerObject(child));
        return query;
    }

    public static <M extends AVObject> AVQuery<M> reverseQuery(Class<M> theParentClazz, String relationKey, AVObject child) {
        AVQuery<M> query = new AVQuery<M>(AVObject.getSubClassName(theParentClazz), theParentClazz);
        query.whereEqualTo(relationKey, AVUtils.mapFromPointerObject(child));
        return query;
    }

    public String getKey() {
        return this.key;
    }

    void setKey(String newKey) {
        this.key = newKey;
    }

    void setParent(AVObject newParent) {
        this.parent = newParent;
    }

    public AVObject getParent() {
        return this.parent;
    }

    public void setTargetClass(String newTargetClass) {
        this.targetClass = newTargetClass;
    }

    public String getTargetClass() {
        return this.targetClass;
    }
}

