/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.ObjectValueFilter;
import java.io.IOException;
import java.lang.reflect.Type;

class AVObjectSerializer
implements ObjectSerializer {
    public static final AVObjectSerializer instance = new AVObjectSerializer();

    AVObjectSerializer() {
    }

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.getWriter();
        AVObject avObject = (AVObject)object;
        out.write('{');
        out.writeFieldValue(' ', "@type", avObject.getClass().getName());
        out.writeFieldValue(',', "objectId", avObject.getObjectId());
        out.writeFieldValue(',', "updatedAt", AVUtils.getAVObjectUpdatedAt(avObject));
        out.writeFieldValue(',', "createdAt", AVUtils.getAVObjectCreatedAt(avObject));
        String className = AVUtils.getAVObjectClassName(avObject.getClass());
        out.writeFieldValue(',', "className", className == null ? avObject.getClassName() : className);
        out.write(',');
        out.writeFieldName("serverData");
        out.write(JSON.toJSONString(avObject.serverData, (SerializeFilter)ObjectValueFilter.instance, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName, SerializerFeature.DisableCircularReferenceDetect}));
        if (!avObject.operationQueue.isEmpty()) {
            out.write(',');
            out.writeFieldName("operationQueue");
            out.write(JSON.toJSONString(avObject.operationQueue, (SerializeFilter)ObjectValueFilter.instance, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName, SerializerFeature.DisableCircularReferenceDetect}));
        }
        out.write('}');
    }
}

