/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.content.Context;
import android.os.Handler;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.avos.avoscloud.AVCacheManager;
import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVExceptionHolder;
import com.avos.avoscloud.AVMobilePhoneVerifyCallback;
import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVObjectDeserializer;
import com.avos.avoscloud.AVObjectSerializer;
import com.avos.avoscloud.AVPersistenceUtils;
import com.avos.avoscloud.AVUser;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.ArchiveRequestTaskController;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.GetCallback;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.RequestMobileCodeCallback;
import com.avos.avoscloud.callback.AVServerDateCallback;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AVOSCloud {
    public static Context applicationContext;
    public static String applicationId;
    public static String clientKey;
    protected static Handler handler;
    public static final int LOG_LEVEL_VERBOSE = 2;
    public static final int LOG_LEVEL_DEBUG = 4;
    public static final int LOG_LEVEL_INFO = 8;
    public static final int LOG_LEVEL_WARNING = 16;
    public static final int LOG_LEVEL_ERROR = 32;
    public static final int LOG_LEVEL_NONE = -1;
    static final String AV_CLOUD_CACHE_EXPIRE_AUTO_CLEAN_KEY = "AV_CLOUD_CACHE_EXPIRE_AUTO_CLEAN_KEY";
    static final String AV_CLOUD_CACHE_EXPIRE_DATE_KEY = "AV_CLOUD_CACHE_EXPIRE_DATE_KEY";
    static final Integer AV_CLOUD_CACHE_DEFAULT_EXPIRE_DATE;
    static final String AV_CLOUD_CACHE_EXPIRE_KEY_ZONE = "AV_CLOUD_CACHE_EXPIRE_KEY_ZONE";
    static final String AV_CLOUD_API_VERSION_KEY_ZONE = "AV_CLOUD_API_VERSION_KEY_ZONE";
    static final String AV_CLOUD_API_VERSION_KEY = "AV_CLOUD_API_VERSION";
    private static int logLevel;
    private static boolean internalDebugLog;
    private static boolean userInternalDebugLog;
    public static final int DEFAULT_NETWORK_TIMEOUT = 15000;
    static final int DEFAULT_THREAD_POOL_SIZE = 10;
    private static int networkTimeoutInMills;
    private static int threadPoolSize;
    private static StorageType storageType;

    public static void setNetworkTimeout(int timeoutInMills) {
        networkTimeoutInMills = timeoutInMills;
    }

    public static int getNetworkTimeout() {
        return networkTimeoutInMills;
    }

    public static int getThreadPoolSize() {
        return threadPoolSize;
    }

    public static void setThreadPoolSize(int size) {
        threadPoolSize = size;
    }

    private AVOSCloud() {
    }

    public static void initialize(Context context, String applicationId, String clientKey) {
        if (handler == null && !AVUtils.isMainThread()) {
            throw new IllegalStateException("Please call AVOSCloud.initialize in main thread.");
        }
        AVOSCloud.applicationId = applicationId;
        AVOSCloud.clientKey = clientKey;
        applicationContext = context;
        AVOSCloud.startAnalytics(context);
        if (handler == null) {
            handler = new Handler();
        }
        if (AVPersistenceUtils.sharedInstance().getPersistentSettingBoolean(AV_CLOUD_CACHE_EXPIRE_KEY_ZONE, AV_CLOUD_CACHE_EXPIRE_AUTO_CLEAN_KEY, true)) {
            AVCacheManager.clearCacheMoreThanDays(AVPersistenceUtils.sharedInstance().getPersistentSettingInteger(AV_CLOUD_CACHE_EXPIRE_KEY_ZONE, AV_CLOUD_CACHE_EXPIRE_DATE_KEY, AV_CLOUD_CACHE_DEFAULT_EXPIRE_DATE));
            AVCacheManager.clearFileCacheMoreThanDays(AVPersistenceUtils.sharedInstance().getPersistentSettingInteger(AV_CLOUD_CACHE_EXPIRE_KEY_ZONE, AV_CLOUD_CACHE_EXPIRE_DATE_KEY, AV_CLOUD_CACHE_DEFAULT_EXPIRE_DATE) * 2);
        }
        ArchiveRequestTaskController.schedule();
        AVOSCloud.onUpgrade(AVPersistenceUtils.sharedInstance().getPersistentSettingString(AV_CLOUD_API_VERSION_KEY_ZONE, AV_CLOUD_API_VERSION_KEY, "1"), PaasClient.storageInstance().getApiVersion());
        AVPersistenceUtils.sharedInstance().savePersistentSettingString(AV_CLOUD_API_VERSION_KEY_ZONE, AV_CLOUD_API_VERSION_KEY, PaasClient.storageInstance().getApiVersion());
    }

    public static void useAVCloudUS() {
        PaasClient.storageInstance().useAVCloudUS();
    }

    public static void useAVCloudCN() {
        PaasClient.storageInstance();
        PaasClient.useAVCloudCN();
    }

    public static int getLogLevel() {
        return logLevel;
    }

    public static void setLogLevel(int logLevel) {
        AVOSCloud.logLevel = logLevel;
    }

    static void showInternalDebugLog(boolean show) {
        internalDebugLog = show;
    }

    public static boolean showInternalDebugLog() {
        return internalDebugLog;
    }

    public static void setDebugLogEnabled(boolean enable) {
        userInternalDebugLog = enable;
    }

    public static boolean isDebugLogEnabled() {
        return userInternalDebugLog || internalDebugLog;
    }

    public static StorageType getStorageType() {
        return storageType;
    }

    public static void setStorageType(StorageType storageType) {
        AVOSCloud.storageType = storageType;
    }

    public static boolean isLastModifyEnabled() {
        return PaasClient.isLastModifyEnabled();
    }

    public static void setLastModifyEnabled(boolean e) {
        PaasClient.setLastModifyEnabled(e);
    }

    public static void clearLastModifyCache() {
        PaasClient.clearLastModifyCache();
    }

    public static void enableAutoCacheCleaner() {
        AVPersistenceUtils.sharedInstance().savePersistentSettingBoolean(AV_CLOUD_CACHE_EXPIRE_KEY_ZONE, AV_CLOUD_CACHE_EXPIRE_AUTO_CLEAN_KEY, true);
    }

    public static void disableAutoCacheCleaner() {
        AVPersistenceUtils.sharedInstance().savePersistentSettingBoolean(AV_CLOUD_CACHE_EXPIRE_KEY_ZONE, AV_CLOUD_CACHE_EXPIRE_AUTO_CLEAN_KEY, false);
    }

    public static void setCacheFileAutoExpireDate(int expireDays) {
        AVPersistenceUtils.sharedInstance().savePersistentSettingInteger(AV_CLOUD_CACHE_EXPIRE_KEY_ZONE, AV_CLOUD_CACHE_EXPIRE_DATE_KEY, expireDays);
    }

    public static void setBaseUrl(String baseUrl) {
        PaasClient.storageInstance().setBaseUrl(baseUrl);
    }

    public static void requestSMSCode(String phone, String name, String op, int ttl) throws AVException {
        AVOSCloud.requestSMSCodeInBackground(phone, null, AVOSCloud.getSMSCodeEnv(name, op, ttl), true, new RequestMobileCodeCallback(){

            @Override
            public void done(AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            public boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
    }

    private static Map<String, Object> getSMSCodeEnv(String name, String op, int ttl) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!AVUtils.isBlankString(op)) {
            map.put("op", op);
        }
        if (!AVUtils.isBlankString(name)) {
            map.put("name", name);
        }
        if (ttl > 0) {
            map.put("ttl", ttl);
        }
        return map;
    }

    private static Map<String, Object> getVoiceCodeEnv(String countryCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("smsType", "voice");
        if (!AVUtils.isBlankString(countryCode)) {
            map.put("IDD", countryCode);
        }
        return map;
    }

    @Deprecated
    public static void requestSMSCodeInBackgroud(String phone, String name, String op, int ttl, RequestMobileCodeCallback callback) {
        AVOSCloud.requestSMSCodeInBackground(phone, null, AVOSCloud.getSMSCodeEnv(name, op, ttl), false, callback);
    }

    public static void requestSMSCodeInBackground(String phone, String name, String op, int ttl, RequestMobileCodeCallback callback) {
        AVOSCloud.requestSMSCodeInBackground(phone, null, AVOSCloud.getSMSCodeEnv(name, op, ttl), false, callback);
    }

    public static void requestSMSCode(String phone, String templateName, Map<String, Object> env) throws AVException {
        AVOSCloud.requestSMSCodeInBackground(phone, templateName, env, true, new RequestMobileCodeCallback(){

            @Override
            public void done(AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            public boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
    }

    @Deprecated
    public static void requestSMSCodeInBackgroud(String phone, String templateName, Map<String, Object> env, RequestMobileCodeCallback callback) {
        AVOSCloud.requestSMSCodeInBackground(phone, templateName, env, false, callback);
    }

    public static void requestSMSCodeInBackground(String phone, String templateName, Map<String, Object> env, RequestMobileCodeCallback callback) {
        AVOSCloud.requestSMSCodeInBackground(phone, templateName, env, false, callback);
    }

    private static void requestSMSCodeInBackground(String phone, String templateName, Map<String, Object> env, boolean sync, RequestMobileCodeCallback callback) {
        final RequestMobileCodeCallback internalCallback = callback;
        if (AVUtils.isBlankString(phone) || !AVUtils.checkMobilePhoneNumber(phone)) {
            callback.internalDone(new AVException(127, "Invalid Phone Number"));
        }
        if (env == null) {
            env = new HashMap<String, Object>();
        }
        env.put("mobilePhoneNumber", phone);
        if (!AVUtils.isBlankString(templateName)) {
            env.put("template", templateName);
        }
        String object = AVUtils.jsonStringFromMapWithNull(env);
        PaasClient.storageInstance().postObject("requestSmsCode", object, sync, false, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                if (internalCallback != null) {
                    internalCallback.internalDone(null, null);
                }
            }

            @Override
            public void onFailure(Throwable error, String content) {
                if (internalCallback != null) {
                    internalCallback.internalDone(null, AVErrorUtils.createException(error, content));
                }
            }
        }, null, null);
    }

    public static void requestSMSCode(String phone) throws AVException {
        AVOSCloud.requestSMSCode(phone, null, null, 0);
    }

    @Deprecated
    public static void requestSMSCodeInBackgroud(String phone, RequestMobileCodeCallback callback) {
        AVOSCloud.requestSMSCodeInBackgroud(phone, null, null, 0, callback);
    }

    public static void requestSMSCodeInBackground(String phone, RequestMobileCodeCallback callback) {
        AVOSCloud.requestSMSCodeInBackgroud(phone, null, null, 0, callback);
    }

    public static void requestVoiceCode(String phoneNumber) throws AVException {
        AVOSCloud.requestVoiceCode(phoneNumber, null);
    }

    private static void requestVoiceCode(String phoneNumber, String idd) throws AVException {
        AVOSCloud.requestSMSCodeInBackground(phoneNumber, null, AVOSCloud.getVoiceCodeEnv(idd), true, new RequestMobileCodeCallback(){

            @Override
            public void done(AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            public boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
    }

    public static void requestVoiceCodeInBackground(String phoneNumber, RequestMobileCodeCallback callback) {
        AVOSCloud.requestSMSCodeInBackground(phoneNumber, null, AVOSCloud.getVoiceCodeEnv(null), callback);
    }

    private static void requestVoiceCodeInBackground(String phoneNumber, String idd, RequestMobileCodeCallback callback) {
        AVOSCloud.requestSMSCodeInBackground(phoneNumber, null, AVOSCloud.getVoiceCodeEnv(idd), callback);
    }

    public static void verifySMSCode(String code, String mobilePhoneNumber) throws AVException {
        AVOSCloud.verifySMSCodeInBackground(code, mobilePhoneNumber, true, new AVMobilePhoneVerifyCallback(){

            @Override
            public void done(AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            public boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
    }

    public static void verifyCode(String code, String mobilePhoneNumber) throws AVException {
        AVOSCloud.verifySMSCode(code, mobilePhoneNumber);
    }

    public static void verifySMSCodeInBackground(String code, String mobilePhoneNumber, AVMobilePhoneVerifyCallback callback) {
        AVOSCloud.verifySMSCodeInBackground(code, mobilePhoneNumber, false, callback);
    }

    public static void verifyCodeInBackground(String code, String mobilePhoneNumber, AVMobilePhoneVerifyCallback callback) {
        AVOSCloud.verifySMSCodeInBackground(code, mobilePhoneNumber, false, callback);
    }

    private static void verifySMSCodeInBackground(String code, String mobilePhoneNumber, boolean sync, AVMobilePhoneVerifyCallback callback) {
        final AVMobilePhoneVerifyCallback internalCallback = callback;
        if (AVUtils.isBlankString(code) || !AVUtils.checkMobileVerifyCode(code)) {
            callback.internalDone(new AVException(127, "Invalid Verify Code"));
        }
        String endpointer = String.format("verifySmsCode/%s", code);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mobilePhoneNumber", mobilePhoneNumber);
        PaasClient.storageInstance().postObject(endpointer, AVUtils.restfulServerData(params), sync, false, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                if (internalCallback != null) {
                    internalCallback.internalDone(null, null);
                }
            }

            @Override
            public void onFailure(Throwable error, String content) {
                if (internalCallback != null) {
                    internalCallback.internalDone(null, AVErrorUtils.createException(error, content));
                }
            }
        }, null, null);
    }

    protected static void onUpgrade(String oldVersion, String newVersion) {
        if (!oldVersion.equals(newVersion) && AVUtils.compareNumberString(newVersion, oldVersion) && "1.1".equals(newVersion)) {
            AVUser localUser;
            if (AVOSCloud.showInternalDebugLog()) {
                LogUtil.avlog.d("try to do some upgrade work");
            }
            if ((localUser = AVUser.getCurrentUser()) != null && !AVUtils.isBlankString(localUser.getObjectId())) {
                localUser.fetchInBackground(new GetCallback<AVObject>(){

                    @Override
                    public void done(AVObject object, AVException e) {
                        AVUser.changeCurrentUser((AVUser)object, true);
                    }
                });
            }
            try {
                Class<?> installationClass = Class.forName("com.avos.avoscloud.AVInstallation");
                Method updateMethod = installationClass.getDeclaredMethod("updateCurrentInstallation", new Class[0]);
                updateMethod.invoke(installationClass, new Object[0]);
            }
            catch (Exception e) {
                LogUtil.avlog.i("failed to update local Installation");
            }
            AVCacheManager.clearAllCache();
        }
    }

    private static void startAnalytics(Context context) {
        try {
            Class<?> statisticsClass = Class.forName("com.avos.avoscloud.AVAnalytics");
            Method startMethod = statisticsClass.getMethod("start", Context.class);
            startMethod.invoke(statisticsClass, context);
        }
        catch (Exception e) {
            LogUtil.avlog.i("statistics library not started since not included");
        }
    }

    public static void getServerDateInBackground(AVServerDateCallback callback) {
        AVOSCloud.getServerDateInBackground(false, callback);
    }

    public static Date getServerDate() throws AVException {
        final Date[] results = new Date[]{null};
        AVOSCloud.getServerDateInBackground(true, new AVServerDateCallback(){

            @Override
            public void done(Date serverDate, AVException e) {
                if (e == null) {
                    results[0] = serverDate;
                } else {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            public boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
        return results[0];
    }

    private static void getServerDateInBackground(boolean sync, final AVServerDateCallback callback) {
        PaasClient.storageInstance().getObject("date", null, sync, null, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                block3: {
                    try {
                        Date date = AVUtils.dateFromMap((Map)JSON.parseObject((String)content, Map.class));
                        if (callback != null) {
                            callback.internalDone(date, null);
                        }
                    }
                    catch (Exception ex) {
                        if (callback == null) break block3;
                        callback.internalDone(null, AVErrorUtils.createException(ex, null));
                    }
                }
            }

            @Override
            public void onFailure(Throwable error, String content) {
                if (callback != null) {
                    callback.internalDone(null, AVErrorUtils.createException(error, content));
                }
            }
        });
    }

    static {
        AV_CLOUD_CACHE_DEFAULT_EXPIRE_DATE = 30;
        logLevel = -1;
        internalDebugLog = false;
        userInternalDebugLog = false;
        networkTimeoutInMills = 15000;
        threadPoolSize = 10;
        JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
        ParserConfig.getGlobalInstance().putDeserializer(AVObject.class, (ObjectDeserializer)AVObjectDeserializer.instance);
        ParserConfig.getGlobalInstance().putDeserializer(AVUser.class, (ObjectDeserializer)AVObjectDeserializer.instance);
        SerializeConfig.getGlobalInstance().put(AVObject.class, (Object)AVObjectSerializer.instance);
        SerializeConfig.getGlobalInstance().put(AVUser.class, (Object)AVObjectSerializer.instance);
        try {
            Class<?> avInstallationClass = Class.forName("com.avos.avoscloud.AVInstallation");
            ParserConfig.getGlobalInstance().putDeserializer(avInstallationClass, (ObjectDeserializer)AVObjectDeserializer.instance);
            SerializeConfig.getGlobalInstance().put(avInstallationClass, (Object)AVObjectSerializer.instance);
        }
        catch (Exception exception) {
            // empty catch block
        }
        storageType = StorageType.StorageTypeQiniu;
    }

    public static enum StorageType {
        StorageTypeQiniu,
        StorageTypeAV,
        StorageTypeS3;

    }
}

