/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.annotation.SuppressLint;
import android.os.AsyncTask;
import android.webkit.MimeTypeMap;
import android.webkit.URLUtil;
import com.avos.avoscloud.AVACL;
import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVPersistenceUtils;
import com.avos.avoscloud.AVQuery;
import com.avos.avoscloud.AVUploader;
import com.avos.avoscloud.AVUser;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.DeleteCallback;
import com.avos.avoscloud.GetCallback;
import com.avos.avoscloud.GetDataCallback;
import com.avos.avoscloud.GetFileCallback;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.ProgressCallback;
import com.avos.avoscloud.QiniuUploader;
import com.avos.avoscloud.S3Uploader;
import com.avos.avoscloud.SaveCallback;
import com.avos.avoscloud.UrlDirectlyUploader;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.BinaryHttpResponseHandler;
import com.loopj.android.http.ResponseHandlerInterface;
import com.loopj.android.http.SyncHttpClient;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.Header;
import org.json.JSONObject;

public class AVFile {
    private boolean dirty;
    private String name;
    private String url;
    private transient byte[] data;
    private transient AVUploader uploader;
    private transient AVDownloader downloader;
    private final HashMap<String, Object> metaData = new HashMap();
    private static String defaultMimeType = "application/octet-stream";
    private static final String FILE_SUM_KEY = "_checksum";
    static final String FILE_NAME_KEY = "_name";
    private String objectId;
    private AVObject fileObject;
    private String bucket;
    private static final String ELDERMETADATAKEYFORIOSFIX = "metadata";
    private AVACL acl;
    private static final String THUMBNAIL_FMT = "?imageView/%d/w/%d/h/%d/q/%d/format/%s";
    private static final String ETAG_FILE_EXTENSION = ".tg";

    public AVFile() {
        if (PaasClient.storageInstance().getDefaultACL() != null) {
            this.acl = new AVACL(PaasClient.storageInstance().getDefaultACL());
        }
    }

    AVObject getFileObject() {
        if (this.fileObject == null && !AVUtils.isBlankString(this.objectId)) {
            this.fileObject = AVObject.createWithoutData("_File", this.objectId);
        }
        return this.fileObject;
    }

    @Deprecated
    public AVFile(byte[] data) {
        this(null, data);
    }

    public AVFile(String name, String url, Map<String, Object> metaData) {
        this();
        this.name = name;
        this.url = url;
        if (metaData != null) {
            this.metaData.putAll(metaData);
        }
        this.metaData.put("__source", "external");
    }

    public AVFile(String name, byte[] data) {
        this();
        AVUser currentUser;
        this.dirty = true;
        this.name = name;
        this.data = data;
        this.metaData.put("size", data != null ? data.length : 0);
        if (data != null) {
            this.metaData.put(FILE_SUM_KEY, AVUtils.computeMD5(data));
        }
        this.metaData.put("owner", (currentUser = AVUser.getCurrentUser()) != null ? currentUser.getObjectId() : "");
        this.metaData.put(FILE_NAME_KEY, name);
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    @Deprecated
    public static void parseFileWithObjectIdInBackground(String objectId, GetFileCallback<AVFile> cb) {
        AVFile.withObjectIdInBackground(objectId, cb);
    }

    public static void withObjectIdInBackground(final String objectId, final GetFileCallback<AVFile> cb) {
        AVQuery<AVObject> query = new AVQuery<AVObject>("_File");
        query.getInBackground(objectId, new GetCallback<AVObject>(){

            @Override
            public void done(AVObject object, AVException e) {
                if (e != null) {
                    cb.internalDone(null, e);
                    return;
                }
                if (object != null && !AVUtils.isBlankString(object.getObjectId())) {
                    AVFile file = AVFile.createFileFromAVObject(object);
                    if (cb != null) {
                        cb.internalDone(file, null);
                    }
                } else {
                    cb.internalDone(null, new AVException(101, "Could not find file object by id:" + objectId));
                }
            }
        });
    }

    @Deprecated
    public static AVFile parseFileWithObjectId(String objectId) throws AVException, FileNotFoundException {
        return AVFile.withObjectId(objectId);
    }

    public static AVFile withObjectId(String objectId) throws AVException, FileNotFoundException {
        AVQuery query = new AVQuery("_File");
        Object object = query.get(objectId);
        if (object != null && !AVUtils.isBlankString(((AVObject)object).getObjectId())) {
            AVFile file = AVFile.createFileFromAVObject(object);
            return file;
        }
        throw new FileNotFoundException("Could not find file object by id:" + objectId);
    }

    @Deprecated
    public static AVFile parseFileWithAVObject(AVObject obj) {
        return AVFile.withAVObject(obj);
    }

    public static AVFile withAVObject(AVObject obj) {
        if (obj != null && !AVUtils.isBlankString(obj.getObjectId())) {
            AVFile file = AVFile.createFileFromAVObject(obj);
            return file;
        }
        throw new IllegalArgumentException("Invalid AVObject.");
    }

    private static AVFile createFileFromAVObject(AVObject object) {
        AVFile file = new AVFile(object.getObjectId(), object.getString("url"));
        if (object.getMap(ELDERMETADATAKEYFORIOSFIX) != null && !object.getMap(ELDERMETADATAKEYFORIOSFIX).isEmpty()) {
            file.metaData.putAll(object.getMap(ELDERMETADATAKEYFORIOSFIX));
        }
        if (object.getMap("metaData") != null) {
            file.metaData.putAll(object.getMap("metaData"));
        }
        file.setObjectId(object.getObjectId());
        file.fileObject = object;
        file.setBucket((String)object.get("bucket"));
        if (!file.metaData.containsKey(FILE_NAME_KEY)) {
            file.metaData.put(FILE_NAME_KEY, object.getString("name"));
        }
        return file;
    }

    @Deprecated
    public static AVFile parseFileWithAbsoluteLocalPath(String name, String absoluteLocalFilePath) throws Exception {
        return AVFile.withAbsoluteLocalPath(name, absoluteLocalFilePath);
    }

    public static AVFile withAbsoluteLocalPath(String name, String absoluteLocalFilePath) throws FileNotFoundException, IOException {
        return AVFile.withFile(name, new File(absoluteLocalFilePath));
    }

    @Deprecated
    public static AVFile parseFileWithFile(String name, File file) throws FileNotFoundException, IOException {
        return AVFile.withFile(name, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AVFile withFile(String name, File file) throws FileNotFoundException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("null file object.");
        }
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException();
        }
        byte[] data = null;
        try {
            data = new byte[(int)file.length()];
            InputStream input = null;
            try {
                int totalBytesRead = 0;
                input = new BufferedInputStream(new FileInputStream(file), 8192);
                while (totalBytesRead < data.length) {
                    int bytesRemaining = data.length - totalBytesRead;
                    int bytesRead = input.read(data, totalBytesRead, bytesRemaining);
                    if (bytesRead <= 0) continue;
                    totalBytesRead += bytesRead;
                }
            }
            finally {
                input.close();
            }
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        AVFile object = new AVFile(name, data);
        return object;
    }

    public HashMap<String, Object> getMetaData() {
        return this.metaData;
    }

    public Object addMetaData(String key, Object val) {
        return this.metaData.put(key, val);
    }

    public Object getMetaData(String key) {
        return this.metaData.get(key);
    }

    public int getSize() {
        Number size = (Number)this.getMetaData("size");
        if (size != null) {
            return size.intValue();
        }
        return -1;
    }

    public String getOwnerObjectId() {
        return (String)this.getMetaData("owner");
    }

    public Object removeMetaData(String key) {
        return this.metaData.remove(key);
    }

    public void clearMetaData() {
        this.metaData.clear();
    }

    protected AVFile(String name, String url) {
        this.dirty = false;
        this.name = name;
        this.url = url;
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalName() {
        return (String)this.metaData.get(FILE_NAME_KEY);
    }

    void setName(String name) {
        this.name = name;
    }

    public static String getMimeType(String url) {
        String type = defaultMimeType;
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)url);
        if (extension != null) {
            MimeTypeMap mime = MimeTypeMap.getSingleton();
            type = mime.getMimeTypeFromExtension(extension);
        }
        if (type == null) {
            type = defaultMimeType;
        }
        return type;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDataAvailable() {
        return this.data != null;
    }

    public String getUrl() {
        return this.url;
    }

    public String getThumbnailUrl(boolean scaleToFit, int width, int height) {
        return this.getThumbnailUrl(scaleToFit, width, height, 100, "png");
    }

    public String getThumbnailUrl(boolean scaleToFit, int width, int height, int quality, String fmt) {
        if (AVOSCloud.getStorageType() != AVOSCloud.StorageType.StorageTypeQiniu) {
            throw new UnsupportedOperationException("We only support this method for qiniu storage.");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Invalid width or height.");
        }
        if (quality < 1 || quality > 100) {
            throw new IllegalArgumentException("Invalid quality,valid range is 0-100.");
        }
        if (fmt == null || AVUtils.isBlankString(fmt.trim())) {
            fmt = "png";
        }
        int mode = scaleToFit ? 2 : 1;
        String resultUrl = this.getUrl() + String.format(THUMBNAIL_FMT, mode, width, height, quality, fmt);
        return resultUrl;
    }

    void setUrl(String url) {
        this.url = url;
    }

    public void save() throws AVException {
        this.cancelUploadIfNeed();
        this.uploader = this.getUploader(null, null);
        AVException exception = this.uploader.doWork();
        if (exception != null) {
            throw exception;
        }
    }

    public synchronized void saveInBackground(SaveCallback saveCallback, ProgressCallback progressCallback) {
        this.cancelUploadIfNeed();
        try {
            this.uploader = this.getUploader(saveCallback, progressCallback);
        }
        catch (AVException e) {
            saveCallback.internalDone(e);
        }
        this.uploader.execute();
    }

    public void saveInBackground(SaveCallback callback) {
        this.saveInBackground(callback, null);
    }

    public void saveInBackground() {
        this.saveInBackground(null);
    }

    public byte[] getData() throws AVException {
        if (this.data != null) {
            return this.data;
        }
        if (this.url != null) {
            byte[] cachedData;
            if (!AVUtils.isConnected(AVOSCloud.applicationContext) && (cachedData = this.fetchCacheData()) != null && cachedData.length > 0) {
                return cachedData;
            }
            this.cancelDownloadIfNeed();
            this.downloader = new AVDownloader(this, null, null);
            AVException exception = this.downloader.doWork(this.getUrl());
            if (exception != null) {
                throw exception;
            }
            return this.data;
        }
        return null;
    }

    public void getDataInBackground(GetDataCallback dataCallback, ProgressCallback progressCallback) {
        if (this.data != null) {
            if (dataCallback != null) {
                dataCallback.internalDone(this.data, null);
            }
        } else if (this.url != null) {
            byte[] cachedData;
            this.cancelDownloadIfNeed();
            if (!AVUtils.isConnected(AVOSCloud.applicationContext) && (cachedData = this.fetchCacheData()) != null && cachedData.length > 0) {
                dataCallback.internalDone(null);
                return;
            }
            this.downloader = new AVDownloader(this, progressCallback, dataCallback);
            this.downloader.execute(new String[]{this.getUrl()});
        } else if (dataCallback != null) {
            dataCallback.internalDone(new AVException(126, ""));
        }
    }

    public void getDataInBackground(GetDataCallback dataCallback) {
        this.getDataInBackground(dataCallback, null);
    }

    public void cancel() {
        this.cancelDownloadIfNeed();
        this.cancelUploadIfNeed();
    }

    private void cancelDownloadIfNeed() {
        if (this.downloader != null) {
            this.downloader.cancel(true);
        }
    }

    private void cancelUploadIfNeed() {
        if (this.uploader != null) {
            this.uploader.cancel(true);
        }
    }

    void handleUploadedResponse(String objectId, String uniqueName, String url) {
        this.dirty = false;
        this.objectId = objectId;
        this.fileObject = AVObject.createWithoutData("_File", objectId);
        this.name = uniqueName;
        this.url = url;
    }

    public void delete() throws AVException {
        if (this.getFileObject() == null) {
            throw AVErrorUtils.createException(153, "File object is not exists.");
        }
        this.getFileObject().delete();
    }

    public void deleteEventually() {
        if (this.getFileObject() != null) {
            this.getFileObject().deleteEventually();
        }
    }

    public void deleteEventually(DeleteCallback callback) {
        if (this.getFileObject() != null) {
            this.getFileObject().deleteEventually(callback);
        }
    }

    public void deleteInBackground() {
        if (this.getFileObject() != null) {
            this.getFileObject().deleteInBackground();
        }
    }

    public void deleteInBackground(DeleteCallback callback) {
        if (this.getFileObject() != null) {
            this.getFileObject().deleteInBackground(callback);
        } else {
            callback.internalDone(null, AVErrorUtils.createException(153, "File object is not exists."));
        }
    }

    String mimeType() {
        if (!AVUtils.isBlankString(this.name)) {
            return AVFile.getMimeType(this.name);
        }
        if (!AVUtils.isBlankString(this.url)) {
            return AVFile.getMimeType(this.url);
        }
        return defaultMimeType;
    }

    static String className() {
        return "File";
    }

    private File localPath() {
        if (this.url == null) {
            return null;
        }
        return new File(AVOSCloud.applicationContext.getFilesDir(), AVUtils.md5(this.url));
    }

    public AVUploader getUploader(SaveCallback saveCallback, ProgressCallback progressCallback) throws AVException {
        if (this.objectId == null && !AVUtils.isBlankString(this.url)) {
            if (URLUtil.isValidUrl((String)this.url)) {
                return new UrlDirectlyUploader(this, saveCallback, progressCallback);
            }
            throw new AVException(126, "Invalid File URL");
        }
        switch (AVOSCloud.getStorageType()) {
            case StorageTypeQiniu: {
                return new QiniuUploader(this, saveCallback, progressCallback);
            }
            case StorageTypeS3: {
                return new S3Uploader(this, saveCallback, progressCallback);
            }
        }
        LogUtil.log.e();
        return null;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheFile(byte[] data, String etag) {
        if (!AVUtils.isBlankString(this.url) && !AVUtils.isBlankString(etag)) {
            String fileName = AVUtils.md5(this.url);
            File etagFile = new File(AVOSCloud.applicationContext.getFilesDir(), fileName + ETAG_FILE_EXTENSION);
            FileOutputStream etagOS = null;
            FileOutputStream output = null;
            try {
                etagOS = new FileOutputStream(etagFile);
                etagOS.write(etag.getBytes("UTF-8"));
                etagOS.flush();
                output = new FileOutputStream(this.localPath());
                ((OutputStream)output).write(data, 0, data.length);
                output.flush();
            }
            catch (Exception e) {
                block5: {
                    try {
                        if (!AVOSCloud.showInternalDebugLog()) break block5;
                        LogUtil.avlog.d("AVFile cache failure");
                    }
                    catch (Throwable throwable) {
                        AVPersistenceUtils.closeQuietly(etagOS);
                        AVPersistenceUtils.closeQuietly(output);
                        throw throwable;
                    }
                }
                AVPersistenceUtils.closeQuietly(etagOS);
                AVPersistenceUtils.closeQuietly(output);
            }
            AVPersistenceUtils.closeQuietly(etagOS);
            AVPersistenceUtils.closeQuietly(output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    private byte[] fetchCacheData() {
        byte[] byArray;
        FileInputStream in = null;
        ByteArrayOutputStream memOutput = null;
        try {
            int count;
            in = new FileInputStream(this.localPath());
            memOutput = new ByteArrayOutputStream();
            byte[] data = new byte[8192];
            long total = 0L;
            while ((count = in.read(data)) != -1) {
                total += (long)count;
                memOutput.write(data, 0, count);
            }
            memOutput.flush();
            byArray = memOutput.toByteArray();
        }
        catch (Exception exception) {
            AVPersistenceUtils.closeQuietly(memOutput);
            AVPersistenceUtils.closeQuietly(in);
            catch (Throwable throwable) {
                AVPersistenceUtils.closeQuietly(memOutput);
                AVPersistenceUtils.closeQuietly(in);
                throw throwable;
            }
        }
        AVPersistenceUtils.closeQuietly(memOutput);
        AVPersistenceUtils.closeQuietly(in);
        return byArray;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fetchCacheTag() {
        Scanner s = null;
        if (!AVUtils.isBlankString(this.url)) {
            try {
                String fileName = AVUtils.md5(this.url);
                File etagFile = new File(AVOSCloud.applicationContext.getFilesDir(), fileName + ETAG_FILE_EXTENSION);
                if (etagFile.exists()) {
                    String etag;
                    s = new Scanner(etagFile);
                    String string = etag = s.next();
                    return string;
                }
            }
            catch (Exception e) {
                if (AVOSCloud.showInternalDebugLog()) {
                    LogUtil.avlog.d("read etag exception");
                }
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        return null;
    }

    private boolean removeCacheTag() {
        if (!AVUtils.isBlankString(this.url)) {
            try {
                String fileName = AVUtils.md5(this.url);
                File etagFile = new File(AVOSCloud.applicationContext.getFilesDir(), fileName + ETAG_FILE_EXTENSION);
                if (etagFile.exists()) {
                    return etagFile.delete();
                }
            }
            catch (Exception e) {
                if (AVOSCloud.showInternalDebugLog()) {
                    LogUtil.avlog.d("remove etag exception");
                }
                return false;
            }
        }
        return true;
    }

    protected AVACL getACL() {
        return this.acl;
    }

    public void setACL(AVACL acl) {
        this.acl = acl;
    }

    private String getFileSum() {
        if (this.getMetaData() != null) {
            return (String)this.getMetaData().get(FILE_SUM_KEY);
        }
        return null;
    }

    protected JSONObject toJSONObject() {
        JSONObject object = new JSONObject();
        Map<String, Object> data = AVUtils.mapFromFile(this);
        data.put("url", this.url);
        return object;
    }

    static /* synthetic */ byte[] access$502(AVFile x0, byte[] x1) {
        x0.data = x1;
        return x1;
    }

    @SuppressLint(value={"NewApi"})
    private static class AVDownloader
    extends AsyncTask<String, Integer, AVException> {
        private static final AsyncHttpClient client = new SyncHttpClient();
        private final GetDataCallback dataCallback;
        private final ProgressCallback progressCallback;
        private final AVFile parseFile;
        private final AtomicInteger retries;

        AVDownloader(AVFile parseFile, ProgressCallback progressCallback, GetDataCallback dataCallback) {
            this.parseFile = parseFile;
            this.dataCallback = dataCallback;
            this.progressCallback = progressCallback;
            this.retries = new AtomicInteger(3);
        }

        protected AVException doWork(final String urlStr) {
            final AVException[] errors = new AVException[1];
            final String etag = this.parseFile.fetchCacheTag();
            if (!AVUtils.isBlankString(etag)) {
                client.addHeader("If-None-Match", etag);
            }
            client.get(urlStr, (ResponseHandlerInterface)new BinaryHttpResponseHandler(new String[]{".*"}){

                public void onSuccess(int statusCode, Header[] headers, byte[] data) {
                    boolean isFileSumNotMatch;
                    String fileMd5 = null;
                    String metaFileSum = AVDownloader.this.parseFile.getFileSum();
                    if (statusCode == 304) {
                        byte[] cacheData = AVDownloader.this.parseFile.fetchCacheData();
                        if (cacheData != null && cacheData.length > 0) {
                            AVFile.access$502(AVDownloader.this.parseFile, cacheData);
                            errors[0] = null;
                        } else if (AVDownloader.this.retries.decrementAndGet() > 0) {
                            AVDownloader.this.parseFile.removeCacheTag();
                            AVDownloader.this.doWork(urlStr);
                            return;
                        }
                    } else if (statusCode == 200) {
                        AVFile.access$502(AVDownloader.this.parseFile, data);
                    }
                    fileMd5 = AVUtils.computeMD5(AVDownloader.this.parseFile.data);
                    boolean bl = isFileSumNotMatch = metaFileSum != null && !metaFileSum.equals(fileMd5);
                    if (isFileSumNotMatch) {
                        AVFile.access$502(AVDownloader.this.parseFile, null);
                        errors[0] = AVErrorUtils.fileDownloadInConsistentFailureException();
                    }
                    if (!isFileSumNotMatch && !AVUtils.isBlankString(etag)) {
                        AVDownloader.this.parseFile.cacheFile(data, etag);
                    }
                }

                public void onFailure(int statusCode, Header[] headers, byte[] data, Throwable error) {
                    errors[0] = new AVException(error);
                }
            });
            this.publishProgress(new Integer[]{100});
            return errors[0] != null ? errors[0] : null;
        }

        protected AVException doInBackground(String ... sUrl) {
            return this.doWork(sUrl[0]);
        }

        protected void onProgressUpdate(Integer ... progress) {
            super.onProgressUpdate((Object[])progress);
            if (this.progressCallback != null) {
                this.progressCallback.internalDone(progress[0], null);
            }
        }

        protected void onPostExecute(AVException e) {
            super.onPostExecute((Object)e);
            if (this.dataCallback != null) {
                this.dataCallback.internalDone(this.parseFile.data, e);
            }
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected void onCancelled() {
            super.onCancelled();
            LogUtil.log.d("download cancel, file downloaded length:" + this.parseFile.localPath().length());
            this.parseFile.localPath().delete();
            AVFile.access$502(this.parseFile, null);
        }
    }
}

