/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVPersistenceUtils;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.LogUtil;
import java.io.File;

public class AVCacheManager {
    private static AVCacheManager instance = null;

    private static File keyValueCacheDir() {
        File dir = new File(AVPersistenceUtils.getCacheDir(), "PaasKeyValueCache");
        dir.mkdirs();
        return dir;
    }

    private static File getCacheFile(String fileName) {
        return new File(AVCacheManager.keyValueCacheDir(), fileName);
    }

    private AVCacheManager() {
    }

    public static synchronized AVCacheManager sharedInstance() {
        if (instance == null) {
            instance = new AVCacheManager();
        }
        return instance;
    }

    public String fileCacheKey(String key, String ts) {
        if (!AVUtils.isBlankString(ts)) {
            return AVUtils.md5(key + ts);
        }
        return AVUtils.md5(key);
    }

    public boolean hasCache(String key) {
        return this.hasCache(key, null);
    }

    public boolean hasCache(String key, String ts) {
        File file = this.getCacheFile(key, ts);
        return file.exists();
    }

    public boolean hasValidCache(String key, String ts, long maxAgeInMilliseconds) {
        File file = this.getCacheFile(key, ts);
        return file.exists() && System.currentTimeMillis() - file.lastModified() < maxAgeInMilliseconds;
    }

    private File getCacheFile(String key, String ts) {
        File file = AVCacheManager.getCacheFile(this.fileCacheKey(key, ts));
        return file;
    }

    public void get(String key, long maxAgeInMilliseconds, String ts, GenericObjectCallback getCallback) {
        File file = this.getCacheFile(key, ts);
        if (!file.exists() || maxAgeInMilliseconds > 0L && System.currentTimeMillis() - file.lastModified() > maxAgeInMilliseconds) {
            getCallback.onFailure(AVErrorUtils.createException(120, "Cache Missing"), null);
        } else {
            String content = AVPersistenceUtils.readContentFromFile(file);
            getCallback.onSuccess(content, null);
        }
    }

    public void delete(String key) {
        File file = AVCacheManager.getCacheFile(AVUtils.md5(key));
        String absolutePath = file.getAbsolutePath();
        if (file.exists()) {
            if (!file.delete()) {
                AVPersistenceUtils.saveContentToFile("{}", file);
            } else {
                AVPersistenceUtils.removeLock(absolutePath);
            }
        }
    }

    public boolean save(String key, String content, String lastModifyTs) {
        File cacheFile = this.getCacheFile(key, lastModifyTs);
        return AVPersistenceUtils.saveContentToFile(content, cacheFile);
    }

    public void remove(String key, String ts) {
        File cacheFile = this.getCacheFile(key, ts);
        String absolutePath = cacheFile.getAbsolutePath();
        if (cacheFile.exists()) {
            if (!cacheFile.delete()) {
                AVPersistenceUtils.saveContentToFile("{}", cacheFile);
            } else {
                AVPersistenceUtils.removeLock(absolutePath);
            }
        }
    }

    public boolean haveCache(String key) {
        return AVCacheManager.getCacheFile(AVUtils.md5(key)).exists();
    }

    public static boolean clearAllCache() {
        return AVCacheManager.clearCacheMoreThanDays(-1);
    }

    public static boolean clearCacheMoreThanOneDay() {
        return AVCacheManager.clearCacheMoreThanDays(1);
    }

    public static boolean clearCacheMoreThanDays(int numberOfDays) {
        File keyValueCacheDir = AVCacheManager.keyValueCacheDir();
        File[] cacheFiles = keyValueCacheDir.listFiles();
        if (cacheFiles != null) {
            for (File file : cacheFiles) {
                if (System.currentTimeMillis() - file.lastModified() <= (long)numberOfDays * 24L * 3600L * 1000L || !file.exists()) continue;
                String path = file.getAbsolutePath();
                if (!file.delete()) {
                    return false;
                }
                AVPersistenceUtils.removeLock(path);
            }
        } else {
            LogUtil.avlog.d("Cache Directory Failure");
        }
        return true;
    }

    public static boolean clearFileCacheMoreThanDays(int numberOfDays) {
        if (AVOSCloud.applicationContext == null) {
            LogUtil.log.e("applicationContext is null, Please call AVOSCloud.initialize first");
            return false;
        }
        File keyValueCacheDir = AVOSCloud.applicationContext.getFilesDir();
        File[] cacheFiles = keyValueCacheDir.listFiles();
        if (cacheFiles != null) {
            for (File file : cacheFiles) {
                if (System.currentTimeMillis() - file.lastModified() <= (long)numberOfDays * 24L * 3600L * 1000L || !file.exists() || !file.isFile()) continue;
                String path = file.getAbsolutePath();
                if (!file.delete()) {
                    return false;
                }
                AVPersistenceUtils.removeLock(path);
            }
        } else {
            LogUtil.avlog.d("File Cache Directory Failure");
        }
        return true;
    }
}

