/*
 * Decompiled with CFR 0.152.
 */
package cn.lollypop.be.auth;

import cn.lollypop.be.auth.SignAlgorithm;
import cn.lollypop.be.exception.LollypopException;
import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedListMultimap;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import shaded.org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Signer {
    public static byte[] sign(String httpMethod, URI uri, LinkedListMultimap<String, String> httpHeaders, String secret, SignAlgorithm algorithm) throws LollypopException {
        Preconditions.checkNotNull((Object)httpMethod);
        Preconditions.checkNotNull((Object)uri);
        Preconditions.checkNotNull((Object)secret);
        Preconditions.checkNotNull((Object)((Object)algorithm));
        String stringToSign = Signer.constructStringToSign(httpMethod, uri, httpHeaders);
        try {
            Mac mac = Mac.getInstance(algorithm.name());
            mac.init(new SecretKeySpec(secret.getBytes(), algorithm.name()));
            return mac.doFinal(stringToSign.getBytes());
        }
        catch (Exception e) {
            throw new LollypopException("Hmac encrypt failed", e);
        }
    }

    public static String signToBase64(String httpMethod, URI uri, LinkedListMultimap<String, String> httpHeaders, String secret, SignAlgorithm algorithm) throws LollypopException {
        byte[] signature = Signer.sign(httpMethod, uri, httpHeaders, secret, algorithm);
        return Base64.encodeBase64URLSafeString(signature);
    }

    static String constructStringToSign(String httpMethod, URI uri, LinkedListMultimap<String, String> httpHeaders) {
        StringBuilder builder = new StringBuilder();
        builder.append(httpMethod).append("\n");
        if (httpHeaders != null) {
            builder.append(Signer.checkAndGet(httpHeaders, "content-md5").get(0)).append("\n");
            builder.append(Signer.checkAndGet(httpHeaders, "content-type").get(0)).append("\n");
            builder.append(Signer.checkAndGet(httpHeaders, "date").get(0)).append("\n");
        } else {
            builder.append("\n\n\n");
        }
        builder.append(uri.getPath());
        return builder.toString();
    }

    static List<String> checkAndGet(LinkedListMultimap<String, String> headers, String header) {
        LinkedList<String> result = new LinkedList<String>();
        if (headers == null) {
            result.add("");
            return result;
        }
        List values = headers.get((Object)header);
        if (values == null || values.isEmpty()) {
            result.add("");
            return result;
        }
        return values;
    }
}

