/*
 * Decompiled with CFR 0.152.
 */
package cn.lollypop.be.auth;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtils {
    private static final ThreadLocal<SimpleDateFormat> RFC_822_DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("GMT+8"));
            return format;
        }
    };
    private static final ThreadLocal<SimpleDateFormat> RFC_850_DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss z", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            return format;
        }
    };
    private static final ThreadLocal<SimpleDateFormat> ANSI_DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            return format;
        }
    };

    public static Date parseDateTimeFromString(String datetime) {
        Date date = DateUtils.tryToParse(datetime, RFC_822_DATE_FORMAT.get());
        if (date == null) {
            date = DateUtils.tryToParse(datetime, RFC_850_DATE_FORMAT.get());
        }
        if (date == null) {
            date = DateUtils.tryToParse(datetime, ANSI_DATE_FORMAT.get());
        }
        return date;
    }

    public static long parseDateTimeToMilliseconds(String datetime) {
        Date date = DateUtils.parseDateTimeFromString(datetime);
        if (date != null) {
            return date.getTime();
        }
        return 0L;
    }

    public static String getGMTDatetime(Date datetime) {
        return RFC_822_DATE_FORMAT.get().format(datetime);
    }

    private static Date tryToParse(String datetime, SimpleDateFormat format) {
        try {
            return format.parse(datetime);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

