/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import com.avos.avoscloud.AVPersistenceUtils;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.AnalyticsSession;
import java.io.File;

class AnalyticsSessionCacheRepository {
    private static final int CACHE_REQUEST = 1;
    private static final String SESSION_KEY = "session.key";
    private static final String SESSION_CACHE_FILENAME = "avoscloud-analysis";
    Handler sessionCacheHandler;
    HandlerThread handlerThread = new HandlerThread("com.avos.avoscloud.AnalyticsCacheHandlerThread");
    static AnalyticsSessionCacheRepository instance = null;

    private AnalyticsSessionCacheRepository() {
        this.handlerThread.start();
        this.sessionCacheHandler = new Handler(this.handlerThread.getLooper()){

            public void handleMessage(Message message) {
                Bundle bundle = message.getData();
                String sessionId = bundle.getString(AnalyticsSessionCacheRepository.SESSION_KEY);
                try {
                    if (!AVUtils.isBlankString((String)sessionId) && message.what == 1) {
                        byte[] sessionData = message.obj == null ? null : AnalyticsSessionCacheRepository.marshall((Parcelable)message.obj);
                        File cacheFile = AnalyticsSessionCacheRepository.getSessionCacheFile();
                        if (sessionData != null && sessionData.length > 0) {
                            AVPersistenceUtils.saveContentToFile((byte[])sessionData, (File)cacheFile);
                        } else {
                            cacheFile.delete();
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        };
    }

    public static AnalyticsSessionCacheRepository getInstance() {
        if (instance == null) {
            instance = new AnalyticsSessionCacheRepository();
        }
        return instance;
    }

    void cacheSession(AnalyticsSession session) {
        this.sessionCacheHandler.sendMessage(AnalyticsSessionCacheRepository.getCacheRequestMessage(1, session.getSessionId(), session));
    }

    AnalyticsSession getCachedSession() {
        byte[] data = AVPersistenceUtils.readContentBytesFromFile((File)AnalyticsSessionCacheRepository.getSessionCacheFile());
        if (data != null && data.length > 0) {
            AnalyticsSession lastSession = new AnalyticsSession(AnalyticsSessionCacheRepository.unMarshall(data));
            lastSession.endSession();
            return lastSession;
        }
        return null;
    }

    static Message getCacheRequestMessage(int code, String sessionId, AnalyticsSession data) {
        Message message = new Message();
        message.what = code;
        Bundle bundle = new Bundle();
        bundle.putString(SESSION_KEY, sessionId);
        if (data != null) {
            message.obj = data;
        }
        message.setData(bundle);
        return message;
    }

    private static byte[] marshall(Parcelable parcelable) {
        Parcel outer = Parcel.obtain();
        parcelable.writeToParcel(outer, 0);
        byte[] data = outer.marshall();
        return data;
    }

    private static Parcel unMarshall(byte[] data) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(data, 0, data.length);
        parcel.setDataPosition(0);
        return parcel;
    }

    private static File getSessionCacheFile() {
        return new File(AVPersistenceUtils.getAnalysisCacheDir(), SESSION_CACHE_FILENAME);
    }
}

