/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVOnlineConfigureListener;
import com.avos.avoscloud.AVUncaughtExceptionHandler;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.AnalyticsEvent;
import com.avos.avoscloud.AnalyticsOnlineConfig;
import com.avos.avoscloud.AnalyticsRequestController;
import com.avos.avoscloud.AnalyticsRequestControllerFactory;
import com.avos.avoscloud.AnalyticsSession;
import com.avos.avoscloud.AnalyticsSessionCacheRepository;
import com.avos.avoscloud.AnalyticsUtils;
import com.avos.avoscloud.BatchRequestController;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.JSONHelper;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.RealTimeRequestController;
import com.avos.avoscloud.ReportPolicy;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

class AnalyticsImpl
implements AnalyticsRequestController.AnalyticsRequestDispatcher {
    static AnalyticsImpl instance;
    protected static boolean enableDebugLog;
    private String appChannel = "AVOS Cloud";
    private boolean autoLocation;
    private static final Map<String, AnalyticsSession> sessions;
    private String currentSessionId;
    private static long sessionThreshold;
    private static final String TAG;
    private AVUncaughtExceptionHandler handler = null;
    private AnalyticsOnlineConfig onlineConfig = new AnalyticsOnlineConfig(this);
    private AVOnlineConfigureListener listener = null;
    private Map<String, String> customInfo;
    private volatile Timer updateOnlineConfigTimer = null;
    private static final String firstBootTag = "firstBoot";
    private static final List<String> whiteList;
    static boolean analysisReportEnableFlag;
    AnalyticsRequestController requestController = new BatchRequestController(this.currentSessionId, this, AnalyticsUtils.getRequestInterval());
    RealTimeRequestController realTimeController = new RealTimeRequestController(this);

    private AnalyticsImpl() {
    }

    public static AnalyticsImpl getInstance() {
        if (instance == null) {
            instance = new AnalyticsImpl();
        }
        return instance;
    }

    public void setAutoLocation(boolean b) {
        this.autoLocation = b;
    }

    public boolean isAutoLocation() {
        return this.autoLocation;
    }

    public boolean isEnableStats() {
        return this.onlineConfig.isEnableStats();
    }

    public void setAppChannel(String channel) {
        this.appChannel = channel;
    }

    public String getAppChannel() {
        return this.appChannel;
    }

    public void setEnableDebugLog(boolean b) {
        enableDebugLog = b;
    }

    public boolean isEnableDebugLog() {
        return enableDebugLog;
    }

    public void enableCrashReport(Context context, boolean enable) {
        if (enable && this.handler == null) {
            this.handler = new AVUncaughtExceptionHandler(context);
        }
        if (this.handler != null) {
            this.handler.enableCrashHanlder(enable);
        }
    }

    public ReportPolicy getReportPolicy(Context context) {
        ReportPolicy value = this.onlineConfig.getReportPolicy();
        if (value == ReportPolicy.REALTIME && whiteList.contains(AVOSCloud.applicationId)) {
            return ReportPolicy.REALTIME;
        }
        if (value == ReportPolicy.REALTIME && !AnalyticsUtils.inDebug(context)) {
            return ReportPolicy.BATCH;
        }
        if (value == ReportPolicy.SENDWIFIONLY && !AnalyticsUtils.inDebug(context)) {
            return ReportPolicy.BATCH;
        }
        return value;
    }

    protected void setReportPolicy(ReportPolicy p) {
        if (this.onlineConfig.setReportPolicy(p)) {
            if (this.requestController != null) {
                this.requestController.quit();
            }
            this.requestController = AnalyticsRequestControllerFactory.getAnalyticsRequestController(this.currentSessionId, this.getReportPolicy(AVOSCloud.applicationContext), this);
            AnalyticsSession session = this.getCurrentSession(false);
            if (session != null && this.requestController instanceof BatchRequestController) {
                ((BatchRequestController)this.requestController).resetMessageCount(session.getMessageCount());
            }
        }
    }

    public void notifyOnlineConfigListener(JSONObject data) {
        if (this.listener != null) {
            try {
                this.listener.onDataReceived(data);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Notify online data received failed.", (Throwable)e);
            }
        }
    }

    private AnalyticsSession getCurrentSession(boolean create) {
        AnalyticsSession session = AnalyticsImpl.sessionByName(this.currentSessionId);
        if (session != null) {
            return session;
        }
        if (!create) {
            return null;
        }
        session = this.createSession();
        this.currentSessionId = session.getSessionId();
        return session;
    }

    public void setSessionContinueMillis(long ms) {
        sessionThreshold = ms;
    }

    public void setSessionDuration(long ms) {
        AnalyticsSession session = this.getCurrentSession(true);
        session.setSessionDuration(ms);
    }

    static AnalyticsSession sessionByName(String sid) {
        if (sid == null) {
            return null;
        }
        return sessions.get(sid);
    }

    private AnalyticsSession createSession() {
        AnalyticsSession session = new AnalyticsSession();
        session.beginSession();
        if (session.getSessionId() != null) {
            sessions.put(session.getSessionId(), session);
        }
        return session;
    }

    protected void flushLastSessions(Context context) {
        AnalyticsSession cachedSession = AnalyticsSessionCacheRepository.getInstance().getCachedSession();
        if (enableDebugLog && cachedSession != null) {
            LogUtil.avlog.i((String)("get cached sessions:" + cachedSession.getSessionId()));
        }
        if (cachedSession != null) {
            sessions.put(cachedSession.getSessionId(), cachedSession);
        }
        this.sendInstantRecordingRequest();
    }

    public void beginSession() {
        AnalyticsSession session = AnalyticsImpl.sessionByName(this.currentSessionId);
        if (session == null) {
            session = this.createSession();
        }
        this.currentSessionId = session.getSessionId();
    }

    public void endSession(Context context) {
        AnalyticsSession session = AnalyticsImpl.sessionByName(this.currentSessionId);
        if (session == null) {
            return;
        }
        session.endSession();
        this.postRecording();
        this.currentSessionId = null;
    }

    public void pauseSession() {
        AnalyticsSession session = AnalyticsImpl.sessionByName(this.currentSessionId);
        if (session == null) {
            return;
        }
        session.pauseSession();
    }

    public void addActivity(String name, long ms) {
        this.getCurrentSession(true).addActivity(name, ms);
    }

    public void beginActivity(String name) {
        this.getCurrentSession(true).beginActivity(name);
        this.postRecording();
    }

    public void beginFragment(String name) {
        this.getCurrentSession(true).beginFragment(name);
        this.postRecording();
    }

    public void beginEvent(Context context, String name) {
        this.beginEvent(context, name, "", "");
    }

    public AnalyticsEvent beginEvent(Context context, String name, String label, String key) {
        AnalyticsSession session = this.getCurrentSession(true);
        AnalyticsEvent event = session.beginEvent(context, name, label, key);
        this.postRecording();
        return event;
    }

    public void endEvent(Context context, String name, String label, String key) {
        this.getCurrentSession(true).endEvent(context, name, label, key);
        this.postRecording();
    }

    public void setCustomInfo(Map<String, String> extensionInfo) {
        this.customInfo = extensionInfo;
    }

    public Map<String, String> getCustomInfo() {
        return this.customInfo;
    }

    private long getSessionTimeoutThreshold() {
        return sessionThreshold;
    }

    public boolean shouldRegardAsNewSession() {
        long start;
        AnalyticsSession session = this.getCurrentSession(false);
        if (session == null) {
            return true;
        }
        long current = AnalyticsUtils.getCurrentTimestamp();
        long delta = current - (start = session.getDuration().getPausedTimeStamp());
        return delta > this.getSessionTimeoutThreshold() && start > 0L;
    }

    public void endActivity(String name) {
        this.getCurrentSession(true).endActivity(name);
        this.postRecording();
    }

    public void endFragment(String name) {
        this.getCurrentSession(true).endFragment(name);
        this.postRecording();
    }

    private void dumpJsonMap(Context context) {
        for (AnalyticsSession session : sessions.values()) {
            Map<String, Object> map = session.jsonMap(context, this.customInfo, false);
            try {
                if (map == null) continue;
                String jsonString = JSONHelper.toJsonString(map);
                LogUtil.log.d((String)jsonString);
            }
            catch (Exception exception) {
                LogUtil.log.e((String)TAG, (String)"", (Exception)exception);
            }
        }
    }

    public synchronized void report(Context context, boolean clear) {
        try {
            this.saveSessionsToServer(context);
            Iterator<Map.Entry<String, AnalyticsSession>> iter = sessions.entrySet().iterator();
            while (iter.hasNext()) {
                AnalyticsSession session = iter.next().getValue();
                if (!session.isSessionFinished()) continue;
                iter.remove();
            }
            AnalyticsSession currentSession = this.getCurrentSession(false);
            if (this.requestController != null) {
                this.requestController.appraisalSession(currentSession);
            }
            if (clear) {
                this.clearSessions();
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Send statstics report failed", (Throwable)e);
        }
    }

    public void debugDump(Context context) {
        if (!enableDebugLog) {
            return;
        }
        for (AnalyticsSession session : sessions.values()) {
            Map<String, Object> map = session.jsonMap(context, this.customInfo, false);
            Log.i((String)TAG, (String)("json data: " + map));
        }
    }

    public void postRecording() {
        if (AVOSCloud.showInternalDebugLog()) {
            Log.d((String)TAG, (String)("report policy:" + (Object)((Object)this.onlineConfig.getReportPolicy())));
        }
        if (!this.isEnableStats()) {
            return;
        }
        if (this.requestController != null) {
            this.requestController.requestToSend(this.currentSessionId);
        }
        AnalyticsSession currentSession = this.getCurrentSession(false);
        this.archiveCurrentSession();
    }

    protected void archiveCurrentSession() {
        AnalyticsSession currentSession = AnalyticsImpl.sessionByName(this.currentSessionId);
        if (currentSession != null) {
            AnalyticsSessionCacheRepository.getInstance().cacheSession(currentSession);
        }
    }

    public void saveSessionsToServer(Context context) {
        try {
            this.sendArchivedRequests(true);
            for (AnalyticsSession session : sessions.values()) {
                Map<String, Object> map = session.jsonMap(context, this.customInfo, true);
                if (map == null) continue;
                String jsonString = JSON.toJSONString(map);
                if (enableDebugLog) {
                    LogUtil.log.i((String)jsonString);
                }
                AnalyticsImpl.sendAnalysisRequest(jsonString, true, true, new GenericObjectCallback(){

                    public void onSuccess(String content, AVException e) {
                        if (enableDebugLog) {
                            Log.i((String)TAG, (String)("Save success: " + content));
                        }
                    }

                    public void onFailure(Throwable error, String content) {
                        if (enableDebugLog) {
                            Log.i((String)TAG, (String)("Save failed: " + content));
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"saveSessionsToServer failed.", (Throwable)e);
        }
    }

    public void clearSessions() {
        sessions.clear();
        this.currentSessionId = null;
    }

    public void setAVOnlineConfigureListener(AVOnlineConfigureListener listener) {
        this.listener = listener;
        if (listener != null && this.updateOnlineConfigTimer == null) {
            this.updateOnlineConfigTimer = new Timer(true);
            this.updateOnlineConfigTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        AnalyticsImpl.this.onlineConfig.update(null, false);
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)"update online config failed", (Throwable)e);
                    }
                }
            }, 5000L, 5000L);
        }
    }

    protected void updateOnlineConfig(Context context) {
        try {
            if (this.onlineConfig != null) {
                if (enableDebugLog) {
                    Log.d((String)TAG, (String)"try to update statistics config from online data");
                }
                this.onlineConfig.update(context);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Update online config failed.", (Throwable)e);
        }
    }

    public void reportFirstBoot(Context context) {
        SharedPreferences sharedPref = context.getSharedPreferences("AVOSCloud-SDK", 0);
        boolean firstBoot = sharedPref.getBoolean(firstBootTag, true);
        if (firstBoot) {
            this.sendInstantRecordingRequest();
            Map<String, Object> firstBootMap = this.getCurrentSession(false).firstBootMap(context, this.customInfo);
            if (firstBootMap != null) {
                if (enableDebugLog) {
                    LogUtil.avlog.d((String)"report data on first boot");
                }
                String jsonString = JSON.toJSONString(firstBootMap);
                AnalyticsImpl.sendAnalysisRequest(jsonString, false, true, null);
            }
            SharedPreferences.Editor editor = sharedPref.edit();
            editor.putBoolean(firstBootTag, false);
            editor.commit();
        } else if (enableDebugLog) {
            LogUtil.avlog.d((String)"no need to first boot report");
        }
    }

    protected void sendInstantRecordingRequest() {
        this.realTimeController.requestToSend(this.currentSessionId);
    }

    protected String getConfigParams(String key, String defaultValue) {
        String result = this.onlineConfig.getConfigParams(key);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    protected static void sendAnalysisRequest(String jsonString, boolean sync, boolean eventually, GenericObjectCallback callback) {
        if (analysisReportEnableFlag) {
            PaasClient.statistisInstance().postObject("stats/collect", jsonString, sync, eventually, callback, null, AVUtils.md5((String)jsonString));
        }
    }

    protected synchronized void setAnalyticsEnabled(boolean enable) {
        analysisReportEnableFlag = enable;
    }

    protected synchronized void sendArchivedRequests(boolean sync) {
        if (analysisReportEnableFlag) {
            PaasClient.statistisInstance().handleAllArchivedRequest(sync);
        }
    }

    @Override
    public void sendRequest() {
        this.report(AVOSCloud.applicationContext, false);
    }

    static {
        enableDebugLog = AVOSCloud.showInternalDebugLog();
        sessions = new ConcurrentHashMap<String, AnalyticsSession>();
        sessionThreshold = 30000L;
        TAG = AnalyticsImpl.class.getSimpleName();
        whiteList = new LinkedList<String>();
        analysisReportEnableFlag = true;
    }
}

