/*
 * Decompiled with CFR 0.152.
 */
package com.basic.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ContextMenu;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Transformation;
import android.widget.Scroller;
import com.base.libs.R;
import com.basic.widgets.TosAbsSpinner;
import com.basic.widgets.TosAdapterView;

public class TosGallery
extends TosAbsSpinner
implements GestureDetector.OnGestureListener,
GestureDetector.OnDoubleTapListener {
    private static final String TAG = "Gallery";
    private static final boolean localLOGV = false;
    private static final int SCROLL_TO_FLING_UNCERTAINTY_TIMEOUT = 250;
    private int mSpacing = 0;
    private int mAnimationDuration = 400;
    private float mUnselectedAlpha;
    private int mLeftMost;
    private int mRightMost;
    private int mGravity;
    private GestureDetector mGestureDetector;
    private int mDownTouchPosition;
    private View mDownTouchView;
    private FlingRunnable mFlingRunnable = new FlingRunnable();
    private Runnable mDisableSuppressSelectionChangedRunnable = new Runnable(){

        @Override
        public void run() {
            TosGallery.this.mSuppressSelectionChanged = false;
            TosGallery.this.selectionChanged();
        }
    };
    private boolean mShouldStopFling;
    private View mSelectedChild;
    private boolean mShouldCallbackDuringFling = true;
    private boolean mShouldCallbackOnUnselectedItemClick = true;
    private boolean mSuppressSelectionChanged;
    private boolean mReceivedInvokeKeyDown;
    private TosAdapterView.AdapterContextMenuInfo mContextMenuInfo;
    private boolean mIsFirstScroll;
    private boolean mIsDisableScroll = false;
    private boolean mScrolling = false;
    private int mFirstChildOffset = 0;
    private int mScrollBarBottomMargin = 0;
    private int mScrollBarSize = 5;
    private float mVelocityRatio = 1.0f;
    private boolean mIsScrollCycle = false;
    private boolean mIsScrollCycleTemp = true;
    private boolean mIsSlotCenter = false;
    private int mOrientation = 1;
    private OnEndFlingListener mOnEndFlingListener = null;
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;

    public TosGallery(Context context) {
        this(context, null);
    }

    public TosGallery(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TosGallery(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        int animationDuration;
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
        this.mGestureDetector.setIsLongpressEnabled(true);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Gallery, defStyle, 0);
        int index = a.getInt(R.styleable.Gallery_gravity, -1);
        if (index >= 0) {
            this.setGravity(index);
        }
        if ((animationDuration = a.getInt(R.styleable.Gallery_animationDuration, -1)) > 0) {
            this.setAnimationDuration(animationDuration);
        }
        int spacing = a.getDimensionPixelOffset(R.styleable.Gallery_spacing, 0);
        this.setSpacing(spacing);
        float unselectedAlpha = a.getFloat(R.styleable.Gallery_unselectedAlpha, 0.5f);
        this.setUnselectedAlpha(unselectedAlpha);
        a.recycle();
        this.setChildrenDrawingOrderEnabled(true);
        this.setStaticTransformationsEnabled(true);
        this.mScrollBarSize = ViewConfiguration.get((Context)context).getScaledScrollBarSize();
        this.mGravity = this.isOrientationVertical() ? 1 : 16;
    }

    public void setCallbackDuringFling(boolean shouldCallback) {
        this.mShouldCallbackDuringFling = shouldCallback;
    }

    public void setCallbackOnUnselectedItemClick(boolean shouldCallback) {
        this.mShouldCallbackOnUnselectedItemClick = shouldCallback;
    }

    public void setAnimationDuration(int animationDurationMillis) {
        this.mAnimationDuration = animationDurationMillis;
    }

    public void setSpacing(int spacing) {
        this.mSpacing = spacing;
    }

    public void setUnselectedAlpha(float unselectedAlpha) {
        this.mUnselectedAlpha = unselectedAlpha;
    }

    protected boolean getChildStaticTransformation(View child, Transformation t) {
        t.clear();
        t.setAlpha(child == this.mSelectedChild ? 1.0f : this.mUnselectedAlpha);
        this.Log(" getChildStaticTransformation   mSelectedPosition =  " + this.mSelectedPosition + "   mFirstPosition = " + this.mFirstPosition + "     mSelectedChild = " + this.mSelectedChild);
        return true;
    }

    protected void onDrawHorizontalScrollBar(Canvas canvas, Drawable scrollBar, int l, int t, int r, int b) {
        t -= this.mScrollBarBottomMargin;
        t = (b -= this.mScrollBarBottomMargin) - this.mScrollBarSize;
        scrollBar.setBounds(l, t, r, b);
        scrollBar.draw(canvas);
    }

    public void invalidate(int l, int t, int r, int b) {
        super.invalidate(l, t -= this.mScrollBarSize + this.mScrollBarBottomMargin, r, b);
    }

    protected int computeHorizontalScrollExtent() {
        int count = this.getChildCount();
        if (count > 0) {
            int extent = count * 100;
            View view = this.getChildAt(0);
            int left = view.getLeft();
            int width = view.getWidth();
            if (width > 0) {
                boolean isFirst;
                boolean bl = isFirst = 0 == this.mFirstPosition;
                if (!isFirst || left <= 0) {
                    extent += left * 100 / width;
                }
            }
            view = this.getChildAt(count - 1);
            int right = view.getRight();
            width = view.getWidth();
            if (width > 0) {
                boolean isLast;
                boolean bl = isLast = this.mFirstPosition + count == this.mItemCount;
                if (!isLast || right >= this.getWidth()) {
                    extent -= (right - this.getWidth()) * 100 / width;
                }
            }
            return extent;
        }
        return 0;
    }

    protected int computeHorizontalScrollOffset() {
        if (this.mFirstPosition >= 0 && this.getChildCount() > 0) {
            View view = this.getChildAt(0);
            int left = view.getLeft();
            int width = view.getWidth();
            if (width > 0) {
                int whichCol = this.mFirstPosition / 1;
                return Math.max(whichCol * 100 - left * 100 / width, 0);
            }
        }
        return this.mSelectedPosition;
    }

    protected int computeHorizontalScrollRange() {
        boolean numRows = true;
        int colCount = (this.mItemCount + 1 - 1) / 1;
        return Math.max(colCount * 100, 0);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.mInLayout = true;
        this.layout(0, false);
        this.mInLayout = false;
    }

    @Override
    int getChildHeight(View child) {
        return child.getMeasuredHeight();
    }

    void trackMotionScroll(int deltaX) {
        boolean toLeft;
        if (this.getChildCount() == 0) {
            return;
        }
        boolean bl = toLeft = deltaX < 0;
        if (this.isSlotInCenter()) {
            int limitedDeltaX;
            if (!(this.isScrollCycle() && this.getChildCount() < this.mItemCount || (limitedDeltaX = this.getLimitedMotionScrollAmount(toLeft, deltaX)) == deltaX)) {
                this.mFlingRunnable.endFling(false);
                this.onFinishedMovement();
            }
            this.offsetChildrenLeftAndRight(deltaX);
            this.detachOffScreenChildren(toLeft);
            if (toLeft) {
                this.fillToGalleryRight();
            } else {
                this.fillToGalleryLeft();
            }
            this.mRecycler.clear();
            this.setSelectionToCenterChild();
            this.invalidate();
            return;
        }
        if (toLeft) {
            View child = this.getChildAt(this.getChildCount() - 1);
            if (null != child && (float)child.getRight() < this.getStopFlingPosition()) {
                deltaX = 0;
                if (null != this.mFlingRunnable) {
                    this.mFlingRunnable.stop(false);
                }
            }
        } else {
            View child = this.getChildAt(0);
            if (null != child && (float)child.getLeft() > (float)this.getWidth() - this.getStopFlingPosition()) {
                deltaX = 0;
                if (null != this.mFlingRunnable) {
                    this.mFlingRunnable.stop(false);
                }
            }
        }
        this.offsetChildrenLeftAndRight(deltaX);
        this.detachOffScreenChildren(toLeft);
        if (toLeft) {
            this.fillToGalleryRight();
        } else {
            this.fillToGalleryLeft();
        }
        this.mRecycler.clear();
        this.setSelectionToCenterChild();
        this.awakenScrollBars();
        this.invalidate();
    }

    void trackMotionScrollVertical(int deltaY) {
        boolean toTop;
        if (this.getChildCount() == 0) {
            return;
        }
        boolean bl = toTop = deltaY < 0;
        if (this.isSlotInCenter()) {
            int limitedDeltaX;
            if (!(this.isScrollCycle() && this.getChildCount() < this.mItemCount || (limitedDeltaX = this.getLimitedMotionScrollAmount(toTop, deltaY)) == deltaY)) {
                this.mFlingRunnable.endFling(false);
                this.onFinishedMovement();
            }
            this.offsetChildrenTopAndBottom(deltaY);
            this.detachOffScreenChildrenVertical(toTop);
            if (toTop) {
                this.fillToGalleryBottom();
            } else {
                this.fillToGalleryTop();
            }
            this.mRecycler.clear();
            this.setSelectionToCenterChildVertical();
            this.invalidate();
            return;
        }
        if (toTop) {
            View child = this.getChildAt(this.getChildCount() - 1);
            if (null != child && (float)child.getRight() < this.getStopFlingPosition()) {
                deltaY = 0;
                if (null != this.mFlingRunnable) {
                    this.mFlingRunnable.stop(false);
                }
            }
        } else {
            View child = this.getChildAt(0);
            if (null != child && (float)child.getLeft() > (float)this.getWidth() - this.getStopFlingPosition()) {
                deltaY = 0;
                if (null != this.mFlingRunnable) {
                    this.mFlingRunnable.stop(false);
                }
            }
        }
        this.offsetChildrenTopAndBottom(deltaY);
        this.detachOffScreenChildrenVertical(toTop);
        if (toTop) {
            this.fillToGalleryBottom();
        } else {
            this.fillToGalleryTop();
        }
        this.mRecycler.clear();
        this.setSelectionToCenterChild();
        this.awakenScrollBars();
        this.invalidate();
    }

    int getLimitedMotionScrollAmount(boolean motionToLeft, int deltaX) {
        int extremeItemPosition = motionToLeft ? this.mItemCount - 1 : 0;
        View extremeChild = this.getChildAt(extremeItemPosition - this.mFirstPosition);
        if (extremeChild == null) {
            return deltaX;
        }
        int extremeChildCenter = this.getCenterOfView(extremeChild);
        int galleryCenter = this.getCenterOfGallery();
        if (motionToLeft ? extremeChildCenter <= galleryCenter : extremeChildCenter >= galleryCenter) {
            return 0;
        }
        int centerDifference = galleryCenter - extremeChildCenter;
        return motionToLeft ? Math.max(centerDifference, deltaX) : Math.min(centerDifference, deltaX);
    }

    private void offsetChildrenLeftAndRight(int offset) {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            this.getChildAt(i).offsetLeftAndRight(offset);
        }
    }

    private void offsetChildrenTopAndBottom(int offset) {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            this.getChildAt(i).offsetTopAndBottom(offset);
        }
    }

    protected int getCenterOfGallery() {
        if (this.isOrientationVertical()) {
            return (this.getHeight() - this.getPaddingTop() - this.getPaddingBottom()) / 2 + this.getPaddingTop();
        }
        return (this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) / 2 + this.getPaddingLeft();
    }

    private float getStopFlingPosition() {
        if (this.isOrientationVertical()) {
            return (float)(this.getHeight() - this.getPaddingTop() - this.getPaddingBottom()) * this.onStopFlingPosRatio() + (float)this.getPaddingTop();
        }
        return (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) * this.onStopFlingPosRatio() + (float)this.getPaddingLeft();
    }

    protected float onStopFlingPosRatio() {
        return 0.0f;
    }

    private int getCenterOfView(View view) {
        if (this.isOrientationVertical()) {
            return view.getTop() + view.getHeight() / 2;
        }
        return view.getLeft() + view.getWidth() / 2;
    }

    private void detachOffScreenChildren(boolean toLeft) {
        int numChildren = this.getChildCount();
        int firstPosition = this.mFirstPosition;
        int start = 0;
        int count = 0;
        if (toLeft) {
            View child;
            int galleryLeft = this.getPaddingLeft();
            for (int i = 0; i < numChildren && (child = this.getChildAt(i)).getRight() < galleryLeft; ++i) {
                ++count;
                this.mRecycler.put(firstPosition + i, child);
            }
            if (count == numChildren) {
                --count;
            }
        } else {
            View child;
            int galleryRight = this.getWidth() - this.getPaddingRight();
            for (int i = numChildren - 1; i >= 0 && (child = this.getChildAt(i)).getLeft() > galleryRight; --i) {
                start = i;
                ++count;
                this.mRecycler.put(firstPosition + i, child);
            }
            if (0 == start) {
                ++start;
            }
        }
        this.detachViewsFromParent(start, count);
        if (toLeft) {
            this.mFirstPosition += count;
            if (this.isScrollCycle()) {
                this.mFirstPosition %= this.mItemCount;
            }
        }
    }

    private void detachOffScreenChildrenVertical(boolean toTop) {
        int numChildren = this.getChildCount();
        int firstPosition = this.mFirstPosition;
        int start = 0;
        int count = 0;
        if (toTop) {
            View child;
            int galleryTop = this.getPaddingTop();
            for (int i = 0; i < numChildren && (child = this.getChildAt(i)).getBottom() < galleryTop; ++i) {
                ++count;
                this.mRecycler.put(firstPosition + i, child);
            }
            if (count == numChildren) {
                --count;
            }
        } else {
            View child;
            int galleryBottom = this.getHeight() - this.getPaddingBottom();
            for (int i = numChildren - 1; i >= 0 && (child = this.getChildAt(i)).getTop() > galleryBottom; --i) {
                start = i;
                ++count;
                this.mRecycler.put(firstPosition + i, child);
            }
            if (0 == start) {
                ++start;
            }
        }
        this.detachViewsFromParent(start, count);
        if (toTop) {
            this.mFirstPosition += count;
            if (this.isScrollCycle()) {
                this.mFirstPosition %= this.mItemCount;
            }
        }
    }

    public void scrollIntoSlots() {
        View child;
        if (this.isOrientationVertical()) {
            this.scrollIntoSlotsVertical();
            return;
        }
        if (this.isSlotInCenter()) {
            if (this.getChildCount() == 0 || this.mSelectedChild == null) {
                return;
            }
            int selectedCenter = this.getCenterOfView(this.mSelectedChild);
            int targetCenter = this.getCenterOfGallery();
            int scrollAmount = targetCenter - selectedCenter;
            if (scrollAmount != 0) {
                this.mFlingRunnable.startUsingDistance(scrollAmount);
            } else {
                this.onFinishedMovement();
            }
            return;
        }
        if (this.getChildCount() == 0) {
            return;
        }
        int scrollAmount = 0;
        if (0 == this.mFirstPosition) {
            View child2 = this.getChildAt(0);
            if (child2.getLeft() >= 0) {
                scrollAmount = this.getPaddingLeft() - child2.getLeft();
            } else {
                View lastChild = this.getChildAt(this.getChildCount() - 1);
                if (lastChild.getRight() - child2.getLeft() < this.getRight() - this.getPaddingRight()) {
                    scrollAmount = this.getPaddingLeft() - this.mFirstChildOffset;
                } else if (lastChild.getRight() < this.getRight() - this.getPaddingRight()) {
                    scrollAmount = this.getWidth() - this.getPaddingRight() - lastChild.getRight();
                }
            }
        } else if (this.mFirstPosition + this.getChildCount() == this.mItemCount && (child = this.getChildAt(this.getChildCount() - 1)).getRight() < this.getRight() - this.getPaddingRight()) {
            scrollAmount = this.getWidth() - this.getPaddingRight() - child.getRight();
        }
        if (0 != scrollAmount) {
            this.mFlingRunnable.startUsingDistance(scrollAmount);
        } else {
            this.onFinishedMovement();
        }
    }

    private void scrollIntoSlotsVertical() {
        View child;
        if (this.isSlotInCenter()) {
            if (this.getChildCount() == 0 || this.mSelectedChild == null) {
                return;
            }
            int selectedCenter = this.getCenterOfView(this.mSelectedChild);
            int targetCenter = this.getCenterOfGallery();
            int scrollAmount = targetCenter - selectedCenter;
            if (scrollAmount != 0) {
                this.mFlingRunnable.startUsingDistance(scrollAmount);
            } else {
                this.onFinishedMovement();
            }
            return;
        }
        if (this.getChildCount() == 0) {
            return;
        }
        int scrollAmount = 0;
        if (0 == this.mFirstPosition) {
            View child2 = this.getChildAt(0);
            if (child2.getTop() >= 0) {
                scrollAmount = this.getPaddingTop() - child2.getTop();
            } else {
                View lastChild = this.getChildAt(this.getChildCount() - 1);
                if (lastChild.getBottom() - child2.getTop() < this.getBottom() - this.getPaddingBottom()) {
                    scrollAmount = this.getPaddingLeft() - this.mFirstChildOffset;
                } else if (lastChild.getBottom() < this.getBottom() - this.getPaddingBottom()) {
                    scrollAmount = this.getHeight() - this.getPaddingBottom() - lastChild.getBottom();
                }
            }
        } else if (this.mFirstPosition + this.getChildCount() == this.mItemCount && (child = this.getChildAt(this.getChildCount() - 1)).getBottom() < this.getBottom() - this.getPaddingBottom()) {
            scrollAmount = this.getHeight() - this.getPaddingBottom() - child.getBottom();
        }
        if (0 != scrollAmount) {
            this.mFlingRunnable.startUsingDistance(scrollAmount);
        } else {
            this.onFinishedMovement();
        }
    }

    private void onFinishedMovement() {
        if (this.mSuppressSelectionChanged) {
            this.mSuppressSelectionChanged = false;
            super.selectionChanged();
        }
        this.invalidate();
    }

    @Override
    protected void selectionChanged() {
        if (!this.mSuppressSelectionChanged) {
            super.selectionChanged();
        }
    }

    private void setSelectionToCenterChild() {
        View selView = this.mSelectedChild;
        if (this.mSelectedChild == null) {
            return;
        }
        int galleryCenter = this.getCenterOfGallery();
        if (selView.getLeft() <= galleryCenter && selView.getRight() >= galleryCenter) {
            return;
        }
        int closestEdgeDistance = Integer.MAX_VALUE;
        int newSelectedChildIndex = 0;
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            if (child.getLeft() <= galleryCenter && child.getRight() >= galleryCenter) {
                newSelectedChildIndex = i;
                break;
            }
            int childClosestEdgeDistance = Math.min(Math.abs(child.getLeft() - galleryCenter), Math.abs(child.getRight() - galleryCenter));
            if (childClosestEdgeDistance >= closestEdgeDistance) continue;
            closestEdgeDistance = childClosestEdgeDistance;
            newSelectedChildIndex = i;
        }
        int newPos = this.mFirstPosition + newSelectedChildIndex;
        if (this.isScrollCycle()) {
            newPos %= this.mItemCount;
        }
        if (newPos != this.mSelectedPosition) {
            this.setSelectedPositionInt(newPos);
            this.setNextSelectedPositionInt(newPos);
            this.checkSelectionChanged();
        }
    }

    private void setSelectionToCenterChildVertical() {
        View selView = this.mSelectedChild;
        if (this.mSelectedChild == null) {
            return;
        }
        int galleryCenter = this.getCenterOfGallery();
        if (null != selView && selView.getTop() <= galleryCenter && selView.getBottom() >= galleryCenter) {
            return;
        }
        int closestEdgeDistance = Integer.MAX_VALUE;
        int newSelectedChildIndex = 0;
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            if (child.getTop() <= galleryCenter && child.getBottom() >= galleryCenter) {
                newSelectedChildIndex = i;
                break;
            }
            int childClosestEdgeDistance = Math.min(Math.abs(child.getTop() - galleryCenter), Math.abs(child.getBottom() - galleryCenter));
            if (childClosestEdgeDistance >= closestEdgeDistance) continue;
            closestEdgeDistance = childClosestEdgeDistance;
            newSelectedChildIndex = i;
        }
        int newPos = this.mFirstPosition + newSelectedChildIndex;
        if (this.isScrollCycle()) {
            newPos %= this.mItemCount;
        }
        if (newPos != this.mSelectedPosition) {
            this.setSelectedPositionInt(newPos);
            this.setNextSelectedPositionInt(newPos);
            this.checkSelectionChanged();
        }
    }

    @Override
    void layout(int delta, boolean animate) {
        if (this.isOrientationVertical()) {
            this.layoutVertical(delta, animate);
            return;
        }
        int childrenLeft = this.mSpinnerPadding.left + this.mFirstChildOffset;
        if (this.mDataChanged) {
            this.handleDataChanged();
        }
        if (this.mItemCount == 0) {
            this.resetList();
            return;
        }
        if (this.mNextSelectedPosition >= 0) {
            this.setSelectedPositionInt(this.mNextSelectedPosition);
        }
        this.recycleAllViews();
        this.detachAllViewsFromParent();
        this.mRightMost = 0;
        this.mLeftMost = 0;
        this.mFirstPosition = this.mSelectedPosition;
        View sel = this.makeAndAddView(this.mFirstPosition, 0, 0, true);
        int selectedOffset = childrenLeft + this.mSpacing;
        if (this.isSlotInCenter()) {
            int childrenWidth = this.getRight() - this.getLeft() - this.mSpinnerPadding.left - this.mSpinnerPadding.right;
            selectedOffset = childrenLeft + childrenWidth / 2 - sel.getWidth() / 2;
        }
        sel.offsetLeftAndRight(selectedOffset);
        this.fillToGalleryRight();
        this.fillToGalleryLeft();
        this.mRecycler.clear();
        this.invalidate();
        this.mDataChanged = false;
        this.mNeedSync = false;
        this.setNextSelectedPositionInt(this.mSelectedPosition);
        this.updateSelectedItemMetadata();
        this.mIsScrollCycleTemp = this.getChildCount() < this.mItemCount;
    }

    void layoutVertical(int delta, boolean animate) {
        int childrenTop = this.mSpinnerPadding.top + this.mFirstChildOffset;
        if (this.mDataChanged) {
            this.handleDataChanged();
        }
        if (this.mItemCount == 0) {
            this.resetList();
            return;
        }
        if (this.mNextSelectedPosition >= 0) {
            this.setSelectedPositionInt(this.mNextSelectedPosition);
        }
        this.recycleAllViews();
        this.detachAllViewsFromParent();
        this.mRightMost = 0;
        this.mLeftMost = 0;
        this.mFirstPosition = this.mSelectedPosition;
        View sel = this.makeAndAddViewVertical(this.mFirstPosition, 0, 0, true);
        int selectedOffset = childrenTop + this.mSpacing;
        if (this.isSlotInCenter()) {
            int childrenHeight = this.getBottom() - this.getTop() - this.mSpinnerPadding.top - this.mSpinnerPadding.bottom;
            selectedOffset = childrenTop + childrenHeight / 2 - sel.getHeight() / 2;
        }
        sel.offsetTopAndBottom(selectedOffset);
        this.fillToGalleryBottom();
        this.fillToGalleryTop();
        this.mRecycler.clear();
        this.invalidate();
        this.mDataChanged = false;
        this.mNeedSync = false;
        this.setNextSelectedPositionInt(this.mSelectedPosition);
        this.updateSelectedItemMetadata();
        this.mIsScrollCycleTemp = this.getChildCount() < this.mItemCount;
    }

    private void fillToGalleryLeft() {
        int curRightEdge;
        int curPosition;
        if (this.isScrollCycle()) {
            this.fillToGalleryLeftCycle();
            return;
        }
        int itemSpacing = this.mSpacing;
        int galleryLeft = this.getPaddingLeft();
        View prevIterationView = this.getChildAt(0);
        if (prevIterationView != null) {
            curPosition = this.mFirstPosition - 1;
            curRightEdge = prevIterationView.getLeft() - itemSpacing;
        } else {
            curPosition = 0;
            curRightEdge = this.getRight() - this.getLeft() - this.getPaddingRight();
            this.mShouldStopFling = true;
        }
        while (curRightEdge > galleryLeft && curPosition >= 0) {
            prevIterationView = this.makeAndAddView(curPosition, curPosition - this.mSelectedPosition, curRightEdge, false);
            this.mFirstPosition = curPosition--;
            curRightEdge = prevIterationView.getLeft() - itemSpacing;
        }
    }

    private void fillToGalleryTop() {
        int curRightEdge;
        int curPosition;
        if (this.isScrollCycle()) {
            this.fillToGalleryTopCycle();
            return;
        }
        int itemSpacing = this.mSpacing;
        int galleryTop = this.getPaddingTop();
        View prevIterationView = this.getChildAt(0);
        if (prevIterationView != null) {
            curPosition = this.mFirstPosition - 1;
            curRightEdge = prevIterationView.getTop() - itemSpacing;
        } else {
            curPosition = 0;
            curRightEdge = this.getBottom() - this.getTop() - this.getPaddingBottom();
            this.mShouldStopFling = true;
        }
        while (curRightEdge > galleryTop && curPosition >= 0) {
            prevIterationView = this.makeAndAddViewVertical(curPosition, curPosition - this.mSelectedPosition, curRightEdge, false);
            this.mFirstPosition = curPosition--;
            curRightEdge = prevIterationView.getTop() - itemSpacing;
        }
    }

    private void fillToGalleryRight() {
        int curLeftEdge;
        int curPosition;
        if (this.isScrollCycle()) {
            this.fillToGalleryRightCycle();
            return;
        }
        int itemSpacing = this.mSpacing;
        int galleryRight = this.getRight() - this.getLeft() - this.getPaddingRight();
        int numChildren = this.getChildCount();
        int numItems = this.mItemCount;
        View prevIterationView = this.getChildAt(numChildren - 1);
        if (prevIterationView != null) {
            curPosition = this.mFirstPosition + numChildren;
            curLeftEdge = prevIterationView.getRight() + itemSpacing;
        } else {
            this.mFirstPosition = curPosition = this.mItemCount - 1;
            curLeftEdge = this.getPaddingLeft();
            this.mShouldStopFling = true;
        }
        while (curLeftEdge < galleryRight && curPosition < numItems) {
            prevIterationView = this.makeAndAddView(curPosition, curPosition - this.mSelectedPosition, curLeftEdge, true);
            curLeftEdge = prevIterationView.getRight() + itemSpacing;
            ++curPosition;
        }
    }

    private void fillToGalleryBottom() {
        int curLeftEdge;
        int curPosition;
        if (this.isScrollCycle()) {
            this.fillToGalleryBottomCycle();
            return;
        }
        int itemSpacing = this.mSpacing;
        int galleryRight = this.getBottom() - this.getTop() - this.getPaddingRight();
        int numChildren = this.getChildCount();
        int numItems = this.mItemCount;
        View prevIterationView = this.getChildAt(numChildren - 1);
        if (prevIterationView != null) {
            curPosition = this.mFirstPosition + numChildren;
            curLeftEdge = prevIterationView.getBottom() + itemSpacing;
        } else {
            this.mFirstPosition = curPosition = this.mItemCount - 1;
            curLeftEdge = this.getPaddingTop();
            this.mShouldStopFling = true;
        }
        while (curLeftEdge < galleryRight && curPosition < numItems) {
            prevIterationView = this.makeAndAddViewVertical(curPosition, curPosition - this.mSelectedPosition, curLeftEdge, true);
            curLeftEdge = prevIterationView.getBottom() + itemSpacing;
            ++curPosition;
        }
    }

    private View makeAndAddView(int position, int offset, int x, boolean fromLeft) {
        View child;
        if (!this.mDataChanged && (child = this.mRecycler.get(position)) != null) {
            int childLeft = child.getLeft();
            this.mRightMost = Math.max(this.mRightMost, childLeft + child.getMeasuredWidth());
            this.mLeftMost = Math.min(this.mLeftMost, childLeft);
            this.setUpChild(child, offset, x, fromLeft);
            return child;
        }
        child = this.mAdapter.getView(position, null, (ViewGroup)this);
        this.setUpChild(child, offset, x, fromLeft);
        return child;
    }

    private View makeAndAddViewVertical(int position, int offset, int y, boolean fromTop) {
        View child;
        if (!this.mDataChanged && (child = this.mRecycler.get(position)) != null) {
            int childTop = child.getTop();
            this.mRightMost = Math.max(this.mRightMost, childTop + child.getMeasuredHeight());
            this.mLeftMost = Math.min(this.mLeftMost, childTop);
            this.setUpChildVertical(child, offset, y, fromTop);
            return child;
        }
        child = this.mAdapter.getView(position, null, (ViewGroup)this);
        this.setUpChildVertical(child, offset, y, fromTop);
        return child;
    }

    private void setUpChild(View child, int offset, int x, boolean fromLeft) {
        int childRight;
        int childLeft;
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (lp == null) {
            lp = (LayoutParams)this.generateDefaultLayoutParams();
        }
        this.addViewInLayout(child, fromLeft ? -1 : 0, lp);
        child.setSelected(offset == 0);
        int childHeightSpec = TosGallery.getChildMeasureSpec((int)this.mHeightMeasureSpec, (int)(this.mSpinnerPadding.top + this.mSpinnerPadding.bottom), (int)lp.height);
        int childWidthSpec = TosGallery.getChildMeasureSpec((int)this.mWidthMeasureSpec, (int)(this.mSpinnerPadding.left + this.mSpinnerPadding.right), (int)lp.width);
        child.measure(childWidthSpec, childHeightSpec);
        int childTop = this.calculateTop(child, true);
        int childBottom = childTop + child.getMeasuredHeight();
        int width = child.getMeasuredWidth();
        if (fromLeft) {
            childLeft = x;
            childRight = childLeft + width;
        } else {
            childLeft = x - width;
            childRight = x;
        }
        child.layout(childLeft, childTop, childRight, childBottom);
    }

    private void setUpChildVertical(View child, int offset, int y, boolean fromTop) {
        int childBottom;
        int childTop;
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (lp == null) {
            lp = (LayoutParams)this.generateDefaultLayoutParams();
        }
        this.addViewInLayout(child, fromTop ? -1 : 0, lp);
        child.setSelected(offset == 0);
        int childHeightSpec = TosGallery.getChildMeasureSpec((int)this.mHeightMeasureSpec, (int)(this.mSpinnerPadding.top + this.mSpinnerPadding.bottom), (int)lp.height);
        int childWidthSpec = TosGallery.getChildMeasureSpec((int)this.mWidthMeasureSpec, (int)(this.mSpinnerPadding.left + this.mSpinnerPadding.right), (int)lp.width);
        child.measure(childWidthSpec, childHeightSpec);
        int childLeft = this.calculateLeft(child, true);
        int childRight = childLeft + child.getMeasuredWidth();
        int height = child.getMeasuredHeight();
        if (fromTop) {
            childTop = y;
            childBottom = childTop + height;
        } else {
            childTop = y - height;
            childBottom = y;
        }
        child.layout(childLeft, childTop, childRight, childBottom);
    }

    private int calculateTop(View child, boolean duringLayout) {
        int myHeight = duringLayout ? this.getMeasuredHeight() : this.getHeight();
        int childHeight = duringLayout ? child.getMeasuredHeight() : child.getHeight();
        int childTop = 0;
        switch (this.mGravity) {
            case 48: {
                childTop = this.mSpinnerPadding.top;
                break;
            }
            case 16: {
                int availableSpace = myHeight - this.mSpinnerPadding.bottom - this.mSpinnerPadding.top - childHeight;
                childTop = this.mSpinnerPadding.top + availableSpace / 2;
                break;
            }
            case 80: {
                childTop = myHeight - this.mSpinnerPadding.bottom - childHeight;
            }
        }
        return childTop;
    }

    private int calculateLeft(View child, boolean duringLayout) {
        int myWidth = duringLayout ? this.getMeasuredWidth() : this.getWidth();
        int childWidth = duringLayout ? child.getMeasuredWidth() : child.getWidth();
        int childLeft = 0;
        switch (this.mGravity) {
            case 3: {
                childLeft = this.mSpinnerPadding.left;
                break;
            }
            case 1: {
                int availableSpace = myWidth - this.mSpinnerPadding.right - this.mSpinnerPadding.left - childWidth;
                childLeft = this.mSpinnerPadding.left + availableSpace / 2;
                break;
            }
            case 5: {
                childLeft = myWidth - this.mSpinnerPadding.right - childWidth;
            }
        }
        return childLeft;
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean retValue = this.mGestureDetector.onTouchEvent(event);
        int action = event.getAction();
        if (action == 1) {
            this.onUp();
        } else if (action == 3) {
            this.onCancel();
        }
        return retValue;
    }

    public boolean onSingleTapUp(MotionEvent e) {
        if (this.mDownTouchPosition >= 0) {
            if (this.isScrollCycle()) {
                this.mDownTouchPosition %= this.getCount();
            }
            if (this.isSlotInCenter()) {
                this.scrollToChild(this.mDownTouchPosition - this.mFirstPosition);
            }
            this.performItemSelect(this.mDownTouchPosition);
            if (this.mShouldCallbackOnUnselectedItemClick || this.mDownTouchPosition == this.mSelectedPosition) {
                this.performItemClick(this.mDownTouchView, this.mDownTouchPosition, this.mAdapter.getItemId(this.mDownTouchPosition));
            }
            return true;
        }
        return false;
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        boolean disableScroll = this.shouldDisableScroll();
        if (disableScroll) {
            return true;
        }
        if (!this.mShouldCallbackDuringFling) {
            this.removeCallbacks(this.mDisableSuppressSelectionChangedRunnable);
            if (!this.mSuppressSelectionChanged) {
                this.mSuppressSelectionChanged = true;
            }
        }
        if (this.isOrientationVertical()) {
            this.mFlingRunnable.startUsingVelocity((int)(-(velocityY *= this.getVelocityRatio())));
        } else {
            this.mFlingRunnable.startUsingVelocity((int)(-(velocityX *= this.getVelocityRatio())));
        }
        return true;
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        boolean disableScroll = this.shouldDisableScroll();
        if (disableScroll) {
            return true;
        }
        this.mScrolling = true;
        this.getParent().requestDisallowInterceptTouchEvent(true);
        if (!this.mShouldCallbackDuringFling) {
            if (this.mIsFirstScroll) {
                if (!this.mSuppressSelectionChanged) {
                    this.mSuppressSelectionChanged = true;
                }
                this.postDelayed(this.mDisableSuppressSelectionChangedRunnable, 250L);
            }
        } else if (this.mSuppressSelectionChanged) {
            this.mSuppressSelectionChanged = false;
        }
        if (this.isOrientationVertical()) {
            this.trackMotionScrollVertical(-1 * (int)distanceY);
        } else {
            this.trackMotionScroll(-1 * (int)distanceX);
        }
        this.mIsFirstScroll = false;
        return true;
    }

    public boolean onDown(MotionEvent e) {
        this.mFlingRunnable.stop(false);
        this.mDownTouchPosition = this.pointToPosition((int)e.getX(), (int)e.getY());
        if (this.mDownTouchPosition >= 0) {
            this.mDownTouchView = this.getChildAt(this.mDownTouchPosition - this.mFirstPosition);
            this.mDownTouchView.setPressed(true);
        }
        this.mIsFirstScroll = true;
        return true;
    }

    protected void onUp() {
        if (this.mFlingRunnable.mScroller.isFinished()) {
            this.scrollIntoSlots();
        }
        this.dispatchUnpress();
    }

    void onCancel() {
        this.onUp();
    }

    public void onLongPress(MotionEvent e) {
        if (this.mDownTouchPosition < 0) {
            return;
        }
        this.performHapticFeedback(0);
        long id2 = this.getItemIdAtPosition(this.mDownTouchPosition);
        this.dispatchLongPress(this.mDownTouchView, this.mDownTouchPosition, id2);
    }

    public void onShowPress(MotionEvent e) {
    }

    private void dispatchPress(View child) {
        if (child != null) {
            child.setPressed(true);
        }
        this.setPressed(true);
    }

    protected void dispatchUnpress() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            this.getChildAt(i).setPressed(false);
        }
        this.setPressed(false);
    }

    public void dispatchSetSelected(boolean selected) {
    }

    protected void dispatchSetPressed(boolean pressed) {
        if (this.mSelectedChild != null) {
            this.mSelectedChild.setPressed(pressed);
        }
    }

    protected ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return this.mContextMenuInfo;
    }

    public boolean showContextMenuForChild(View originalView) {
        int longPressPosition = this.getPositionForView(originalView);
        if (longPressPosition < 0) {
            return false;
        }
        long longPressId = this.mAdapter.getItemId(longPressPosition);
        return this.dispatchLongPress(originalView, longPressPosition, longPressId);
    }

    public boolean showContextMenu() {
        if (this.isPressed() && this.mSelectedPosition >= 0) {
            int index = this.mSelectedPosition - this.mFirstPosition;
            View v = this.getChildAt(index);
            return this.dispatchLongPress(v, this.mSelectedPosition, this.mSelectedRowId);
        }
        return false;
    }

    private boolean dispatchLongPress(View view, int position, long id2) {
        boolean handled = false;
        if (this.mOnItemLongClickListener != null) {
            handled = this.mOnItemLongClickListener.onItemLongClick(this, this.mDownTouchView, this.mDownTouchPosition, id2);
        }
        if (!handled) {
            this.mContextMenuInfo = new TosAdapterView.AdapterContextMenuInfo(view, position, id2);
            handled = super.showContextMenuForChild((View)this);
        }
        if (handled) {
            this.performHapticFeedback(0);
        }
        return handled;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        return event.dispatch((KeyEvent.Callback)this);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 21: {
                if (this.movePrevious()) {
                    this.playSoundEffect(1);
                }
                return true;
            }
            case 22: {
                if (this.moveNext()) {
                    this.playSoundEffect(3);
                }
                return true;
            }
            case 23: 
            case 66: {
                this.mReceivedInvokeKeyDown = true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 23: 
            case 66: {
                if (this.mReceivedInvokeKeyDown && this.mItemCount > 0) {
                    this.dispatchPress(this.mSelectedChild);
                    this.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            TosGallery.this.dispatchUnpress();
                        }
                    }, ViewConfiguration.getPressedStateDuration());
                    int selectedIndex = this.mSelectedPosition - this.mFirstPosition;
                    this.performItemClick(this.getChildAt(selectedIndex), this.mSelectedPosition, this.mAdapter.getItemId(this.mSelectedPosition));
                }
                this.mReceivedInvokeKeyDown = false;
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    boolean movePrevious() {
        return this.mItemCount > 0 && this.mSelectedPosition > 0;
    }

    boolean moveNext() {
        return this.mItemCount > 0 && this.mSelectedPosition < this.mItemCount - 1;
    }

    private boolean scrollToChild(int childPosition) {
        View child = this.getChildAt(childPosition);
        if (child != null) {
            int distance = this.getCenterOfGallery() - this.getCenterOfView(child);
            this.mFlingRunnable.startUsingDistance(distance);
            return true;
        }
        return false;
    }

    @Override
    protected void setSelectedPositionInt(int position) {
        super.setSelectedPositionInt(position);
        this.updateSelectedItemMetadata();
    }

    private void updateSelectedItemMetadata() {
        View child;
        View oldSelectedChild = this.mSelectedChild;
        this.Log(" updateSelectedItemMetadata   mSelectedPosition =  " + this.mSelectedPosition + "   mFirstPosition = " + this.mFirstPosition);
        int index = this.mSelectedPosition - this.mFirstPosition;
        if (this.isScrollCycle() && this.mFirstPosition > this.mSelectedPosition) {
            index = this.mItemCount - this.mFirstPosition + this.mSelectedPosition;
        }
        if ((child = (this.mSelectedChild = this.getChildAt(index))) == null) {
            return;
        }
        child.setSelected(true);
        child.setFocusable(true);
        if (this.hasFocus()) {
            child.requestFocus();
        }
        if (oldSelectedChild != null) {
            oldSelectedChild.setSelected(false);
            oldSelectedChild.setFocusable(false);
        }
    }

    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    protected int getChildDrawingOrder(int childCount, int i) {
        int selectedIndex = this.mSelectedPosition - this.mFirstPosition;
        if (selectedIndex < 0) {
            return i;
        }
        if (i == childCount - 1) {
            return selectedIndex;
        }
        if (i >= selectedIndex) {
            return i + 1;
        }
        return i;
    }

    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        if (gainFocus && this.mSelectedChild != null) {
            this.mSelectedChild.requestFocus(direction);
        }
    }

    private boolean performItemSelect(int childPosition) {
        if (childPosition != this.mSelectedPosition) {
            this.setSelectedPositionInt(childPosition);
            this.setNextSelectedPositionInt(childPosition);
            this.checkSelectionChanged();
            return true;
        }
        return false;
    }

    public void setFirstChildOffset(int firstChildOffset) {
        this.mFirstChildOffset = firstChildOffset;
    }

    public void setFirstPosition(int firstPosition) {
        this.mFirstPosition = firstPosition;
    }

    public void setSlotInCenter(boolean isSlotCenter) {
        this.mIsSlotCenter = isSlotCenter;
    }

    public boolean isSlotInCenter() {
        return this.mIsSlotCenter;
    }

    private boolean isOrientationVertical() {
        return this.mOrientation == 2;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void setOrientation(int orientation) {
        this.mOrientation = orientation;
    }

    public void setOnEndFlingListener(OnEndFlingListener listener) {
        this.mOnEndFlingListener = listener;
    }

    public void setDisableScroll(boolean disableScroll) {
        this.mIsDisableScroll = disableScroll;
    }

    public void setScrollBarBottomMargin(int scrollBarBottomMargin) {
        this.mScrollBarBottomMargin = scrollBarBottomMargin;
    }

    public void setScrollBarSize(int scrollBarSize) {
        this.mScrollBarSize = scrollBarSize;
    }

    public int getFirstPosition() {
        return this.mFirstPosition;
    }

    public int getSpacing() {
        return this.mSpacing;
    }

    public boolean isScrolling() {
        return this.mScrolling;
    }

    public int scrollGalleryItems(boolean toLeft) {
        if (0 == this.getChildCount()) {
            return 0;
        }
        int offset = 0;
        if (toLeft) {
            View child = this.getChildAt(this.getChildCount() - 1);
            offset = child.getRight() - this.getRight() + this.getPaddingRight();
            if (0 == (offset = Math.max(offset, 0)) && this.mFirstPosition + this.getChildCount() != this.mItemCount) {
                offset += null != child ? child.getWidth() : 0;
            }
        } else {
            View child = this.getChildAt(0);
            offset = child.getLeft() - this.getPaddingLeft();
            if (0 == (offset = Math.min(offset, 0)) && 0 != this.mFirstPosition) {
                offset -= null != child ? child.getWidth() : 0;
            }
        }
        if (0 != offset && null != this.mFlingRunnable) {
            this.mFlingRunnable.startUsingDistance(-1 * offset);
        }
        return -1 * offset;
    }

    public int scrollGalleryItems(int offset) {
        if (null != this.mFlingRunnable) {
            this.mFlingRunnable.startUsingDistance(-1 * offset);
        }
        return -1 * offset;
    }

    public int getItemIndexFromPoint(Point pt) {
        int nChildCount = this.getChildCount();
        int nIndex = -1;
        Rect rc = new Rect();
        this.getDrawingRect(rc);
        if (rc.contains(pt.x, pt.y)) {
            for (int i = 0; i < nChildCount; ++i) {
                this.getChildAt(i).getHitRect(rc);
                if (!rc.contains(pt.x, pt.y)) continue;
                nIndex = i;
                break;
            }
        }
        return nIndex >= 0 ? nIndex + this.mFirstPosition : -1;
    }

    protected void onEndFling() {
        if (null != this.mOnEndFlingListener) {
            this.mOnEndFlingListener.onEndFling(this);
        }
    }

    public float getVelocityRatio() {
        return this.mVelocityRatio;
    }

    public void setVelocityRatio(float velocityRatio) {
        this.mVelocityRatio = velocityRatio;
        if (this.mVelocityRatio < 0.5f) {
            this.mVelocityRatio = 0.5f;
        } else if (this.mVelocityRatio > 1.5f) {
            this.mVelocityRatio = 1.5f;
        }
    }

    protected boolean shouldDisableScroll() {
        if (this.mIsDisableScroll) {
            if (this.getChildCount() < this.mItemCount) {
                return false;
            }
            View child = this.getChildAt(0);
            if (null != child && child.getLeft() < this.getLeft()) {
                return false;
            }
            child = this.getChildAt(this.getChildCount() - 1);
            return null == child || child.getRight() <= this.getRight();
        }
        return false;
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        return false;
    }

    public boolean onDoubleTapEvent(MotionEvent e) {
        if (1 == e.getAction() && this.mDownTouchPosition >= 0) {
            if (this.mShouldCallbackOnUnselectedItemClick || this.mDownTouchPosition == this.mSelectedPosition) {
                this.performItemDoubleClick(this.mDownTouchView, this.mDownTouchPosition, this.mAdapter.getItemId(this.mDownTouchPosition));
            }
            return true;
        }
        return false;
    }

    public boolean onDoubleTap(MotionEvent e) {
        return false;
    }

    public boolean isPointInChild(float x, float y) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (!(x >= (float)child.getLeft()) || !(x <= (float)child.getRight()) || !(y >= (float)child.getTop()) || !(y <= (float)child.getBottom())) continue;
            return true;
        }
        return false;
    }

    public void setScrollCycle(boolean scrollCycle) {
        this.mIsScrollCycle = scrollCycle;
    }

    public boolean isScrollCycle() {
        return this.mIsScrollCycle && this.mIsScrollCycleTemp;
    }

    protected void Log(String msg) {
    }

    private void fillToGalleryLeftCycle() {
        int curRightEdge;
        int curPosition;
        int itemSpacing = this.mSpacing;
        int galleryLeft = this.getPaddingLeft();
        View prevIterationView = this.getChildAt(0);
        if (prevIterationView != null) {
            curPosition = this.mFirstPosition - 1;
            curRightEdge = prevIterationView.getLeft() - itemSpacing;
        } else {
            curPosition = 0;
            curRightEdge = this.getRight() - this.getLeft() - this.getPaddingRight();
            this.mShouldStopFling = true;
        }
        while (curRightEdge > galleryLeft && curPosition >= 0) {
            prevIterationView = this.makeAndAddView(curPosition, curPosition - this.mSelectedPosition, curRightEdge, false);
            this.mFirstPosition = curPosition--;
            curRightEdge = prevIterationView.getLeft() - itemSpacing;
        }
        curPosition = this.mItemCount - 1;
        while (curRightEdge > galleryLeft && this.getChildCount() < this.mItemCount) {
            prevIterationView = this.makeAndAddView(curPosition, curPosition - this.mSelectedPosition, curRightEdge, false);
            this.mFirstPosition = curPosition--;
            curRightEdge = prevIterationView.getLeft() - itemSpacing;
        }
    }

    private void fillToGalleryTopCycle() {
        int curRightEdge;
        int curPosition;
        int itemSpacing = this.mSpacing;
        int galleryTop = this.getPaddingTop();
        View prevIterationView = this.getChildAt(0);
        if (prevIterationView != null) {
            curPosition = this.mFirstPosition - 1;
            curRightEdge = prevIterationView.getTop() - itemSpacing;
        } else {
            curPosition = 0;
            curRightEdge = this.getBottom() - this.getTop() - this.getPaddingBottom();
            this.mShouldStopFling = true;
        }
        while (curRightEdge > galleryTop && curPosition >= 0) {
            prevIterationView = this.makeAndAddViewVertical(curPosition, curPosition - this.mSelectedPosition, curRightEdge, false);
            this.mFirstPosition = curPosition--;
            curRightEdge = prevIterationView.getTop() - itemSpacing;
        }
        curPosition = this.mItemCount - 1;
        while (curRightEdge > galleryTop && this.getChildCount() < this.mItemCount) {
            prevIterationView = this.makeAndAddViewVertical(curPosition, curPosition - this.mSelectedPosition, curRightEdge, false);
            this.mFirstPosition = curPosition--;
            curRightEdge = prevIterationView.getTop() - itemSpacing;
        }
    }

    private void fillToGalleryRightCycle() {
        int curLeftEdge;
        int curPosition;
        int itemSpacing = this.mSpacing;
        int galleryRight = this.getRight() - this.getLeft() - this.getPaddingRight();
        int numChildren = this.getChildCount();
        int numItems = this.mItemCount;
        View prevIterationView = this.getChildAt(numChildren - 1);
        this.Log("  fillToGalleryRightCycle mFirstPosition = " + this.mFirstPosition);
        if (prevIterationView != null) {
            curPosition = this.mFirstPosition + numChildren;
            curLeftEdge = prevIterationView.getRight() + itemSpacing;
        } else {
            this.mFirstPosition = curPosition = this.mItemCount - 1;
            curLeftEdge = this.getPaddingLeft();
            this.mShouldStopFling = true;
        }
        while (curLeftEdge < galleryRight && curPosition < numItems) {
            prevIterationView = this.makeAndAddView(curPosition, curPosition - this.mSelectedPosition, curLeftEdge, true);
            curLeftEdge = prevIterationView.getRight() + itemSpacing;
            ++curPosition;
        }
        curPosition %= numItems;
        while (curLeftEdge <= galleryRight && this.getChildCount() < this.mItemCount) {
            prevIterationView = this.makeAndAddView(curPosition, curPosition - this.mSelectedPosition, curLeftEdge, true);
            curLeftEdge = prevIterationView.getRight() + itemSpacing;
            ++curPosition;
        }
    }

    private void fillToGalleryBottomCycle() {
        int curLeftEdge;
        int curPosition;
        int itemSpacing = this.mSpacing;
        int galleryBottom = this.getBottom() - this.getTop() - this.getPaddingBottom();
        int numChildren = this.getChildCount();
        int numItems = this.mItemCount;
        View prevIterationView = this.getChildAt(numChildren - 1);
        this.Log("  fillToGalleryRightCycle mFirstPosition = " + this.mFirstPosition);
        if (prevIterationView != null) {
            curPosition = this.mFirstPosition + numChildren;
            curLeftEdge = prevIterationView.getBottom() + itemSpacing;
        } else {
            this.mFirstPosition = curPosition = this.mItemCount - 1;
            curLeftEdge = this.getPaddingTop();
            this.mShouldStopFling = true;
        }
        while (curLeftEdge < galleryBottom && curPosition < numItems) {
            prevIterationView = this.makeAndAddViewVertical(curPosition, curPosition - this.mSelectedPosition, curLeftEdge, true);
            curLeftEdge = prevIterationView.getBottom() + itemSpacing;
            ++curPosition;
        }
        curPosition %= numItems;
        while (curLeftEdge <= galleryBottom && this.getChildCount() < this.mItemCount) {
            prevIterationView = this.makeAndAddViewVertical(curPosition, curPosition - this.mSelectedPosition, curLeftEdge, true);
            curLeftEdge = prevIterationView.getBottom() + itemSpacing;
            ++curPosition;
        }
    }

    public static interface OnEndFlingListener {
        public void onEndFling(TosGallery var1);
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int w, int h) {
            super(w, h);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }

    private class FlingRunnable
    implements Runnable {
        private Scroller mScroller;
        private int mLastFlingX;
        private int mLastFlingY;

        public FlingRunnable() {
            this.mScroller = new Scroller(TosGallery.this.getContext());
        }

        private void startCommon() {
            TosGallery.this.removeCallbacks(this);
        }

        public void startUsingVelocity(int initialVelocity) {
            int initialX;
            if (initialVelocity == 0) {
                return;
            }
            this.startCommon();
            if (TosGallery.this.isOrientationVertical()) {
                int initialY;
                this.mLastFlingY = initialY = initialVelocity < 0 ? Integer.MAX_VALUE : 0;
                this.mScroller.fling(0, initialY, 0, initialVelocity, 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
                TosGallery.this.post(this);
                return;
            }
            this.mLastFlingX = initialX = initialVelocity < 0 ? Integer.MAX_VALUE : 0;
            this.mScroller.fling(initialX, 0, initialVelocity, 0, 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
            TosGallery.this.post(this);
        }

        public void startUsingDistance(int distance) {
            if (distance == 0) {
                return;
            }
            if (TosGallery.this.isOrientationVertical()) {
                this.startCommon();
                TosGallery.this.mScrolling = true;
                this.mLastFlingY = 0;
                this.mScroller.startScroll(0, 0, 0, -distance, TosGallery.this.mAnimationDuration);
                TosGallery.this.post(this);
                return;
            }
            this.startCommon();
            TosGallery.this.mScrolling = true;
            this.mLastFlingX = 0;
            this.mScroller.startScroll(0, 0, -distance, 0, TosGallery.this.mAnimationDuration);
            TosGallery.this.post(this);
        }

        public void stop(boolean scrollIntoSlots) {
            TosGallery.this.removeCallbacks(this);
            this.endFling(scrollIntoSlots);
        }

        private void endFling(boolean scrollIntoSlots) {
            TosGallery.this.mScrolling = false;
            this.mScroller.forceFinished(true);
            if (scrollIntoSlots) {
                TosGallery.this.scrollIntoSlots();
            }
            TosGallery.this.onEndFling();
        }

        @Override
        public void run() {
            if (TosGallery.this.isOrientationVertical()) {
                this.runVertical();
                return;
            }
            if (TosGallery.this.mItemCount == 0) {
                this.endFling(true);
                return;
            }
            TosGallery.this.mShouldStopFling = false;
            Scroller scroller = this.mScroller;
            boolean more = scroller.computeScrollOffset();
            int x = scroller.getCurrX();
            int delta = this.mLastFlingX - x;
            if (delta > 0) {
                TosGallery.this.mDownTouchPosition = TosGallery.this.mFirstPosition;
                delta = Math.min(TosGallery.this.getWidth() - TosGallery.this.getPaddingLeft() - TosGallery.this.getPaddingRight() - 1, delta);
            } else {
                int offsetToLast = TosGallery.this.getChildCount() - 1;
                TosGallery.this.mDownTouchPosition = TosGallery.this.mFirstPosition + offsetToLast;
                delta = Math.max(-(TosGallery.this.getWidth() - TosGallery.this.getPaddingRight() - TosGallery.this.getPaddingLeft() - 1), delta);
            }
            TosGallery.this.trackMotionScroll(delta);
            if (more && !TosGallery.this.mShouldStopFling) {
                this.mLastFlingX = x;
                TosGallery.this.post(this);
            } else {
                this.endFling(true);
            }
        }

        public void runVertical() {
            if (TosGallery.this.mItemCount == 0) {
                this.endFling(true);
                return;
            }
            TosGallery.this.mShouldStopFling = false;
            Scroller scroller = this.mScroller;
            boolean more = scroller.computeScrollOffset();
            int y = scroller.getCurrY();
            int delta = this.mLastFlingY - y;
            if (delta > 0) {
                TosGallery.this.mDownTouchPosition = TosGallery.this.mFirstPosition;
                delta = Math.min(TosGallery.this.getHeight() - TosGallery.this.getPaddingTop() - TosGallery.this.getPaddingBottom() - 1, delta);
            } else {
                int offsetToLast = TosGallery.this.getChildCount() - 1;
                TosGallery.this.mDownTouchPosition = TosGallery.this.mFirstPosition + offsetToLast;
                delta = Math.max(-(TosGallery.this.getHeight() - TosGallery.this.getPaddingBottom() - TosGallery.this.getPaddingTop() - 1), delta);
            }
            TosGallery.this.trackMotionScrollVertical(delta);
            if (more && !TosGallery.this.mShouldStopFling) {
                this.mLastFlingY = y;
                TosGallery.this.post(this);
            } else {
                this.endFling(true);
            }
        }
    }
}

