/*
 * Decompiled with CFR 0.152.
 */
package com.basic.widgets;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.AbsoluteLayout;
import android.widget.ProgressBar;
import com.base.libs.R;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProgressWebView
extends WebView {
    private static String TAG = "ProgressWebView";
    private ProgressBar progressbar;
    private PageLoadEvent pageLoadEvent;

    public ProgressWebView(final Context context, AttributeSet attrs) {
        super(context, attrs);
        this.progressbar = new ProgressBar(context, null, 16842872);
        this.progressbar.setLayoutParams((ViewGroup.LayoutParams)new AbsoluteLayout.LayoutParams(-1, 5, 0, 0));
        this.progressbar.setProgressDrawable(this.getResources().getDrawable(R.drawable.progress_drawable));
        this.addView((View)this.progressbar);
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setSupportZoom(true);
        this.setWebChromeClient(new WebChromeClient());
        this.setWebViewClient(new WebViewClient(){

            public void onLoadResource(WebView view, String url) {
                if (ProgressWebView.this.pageLoadEvent != null) {
                    ProgressWebView.this.pageLoadEvent.onLoadResource();
                }
                super.onLoadResource(view, url);
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (url.startsWith("tel:")) {
                    Intent intent = new Intent("android.intent.action.DIAL", Uri.parse((String)url));
                    context.startActivity(intent);
                } else if (url.startsWith("http:") || url.startsWith("https:")) {
                    view.loadUrl(url);
                } else if (url.startsWith("mailto:")) {
                    this.mailto(view, url);
                }
                return true;
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                Log.d((String)TAG, (String)("onPageStarted\uff1a" + url));
                if (ProgressWebView.this.pageLoadEvent != null) {
                    ProgressWebView.this.pageLoadEvent.onPageStarted(url);
                }
                super.onPageStarted(view, url, favicon);
            }

            public void onPageFinished(WebView view, String url) {
                Log.d((String)TAG, (String)("onPageFinished\uff1a" + url));
                if (ProgressWebView.this.pageLoadEvent != null) {
                    ProgressWebView.this.pageLoadEvent.onPageFinished(url);
                }
                super.onPageFinished(view, url);
            }

            private void mailto(WebView view, String url) {
                url = url.replace("mailto:", "");
                String check = "^\\s*\\w+(?:\\.{0,1}[\\w-]+)*@[a-zA-Z0-9]+(?:[-.][a-zA-Z0-9]+)*\\.[a-zA-Z]+\\s*$";
                Pattern regex = Pattern.compile(check);
                Matcher matcher = regex.matcher(url);
                boolean isMatched = matcher.matches();
                if (isMatched) {
                    Intent emailIntent = new Intent("android.intent.action.SEND");
                    emailIntent.setType("plain/text");
                    String[] emailReciver = new String[]{url};
                    emailIntent.putExtra("android.intent.extra.EMAIL", emailReciver);
                    emailIntent.putExtra("android.intent.extra.SUBJECT", "");
                    emailIntent.putExtra("android.intent.extra.TEXT", "");
                    context.startActivity(Intent.createChooser((Intent)emailIntent, (CharSequence)"\u8bf7\u9009\u62e9\u90ae\u4ef6\u53d1\u9001\u8f6f\u4ef6"));
                }
            }
        });
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (event.getAction() == 0) {
            switch (keyCode) {
                case 4: {
                    if (!this.canGoBack()) break;
                    Log.d((String)TAG, (String)("goback\uff0c" + this.getUrl() + "\uff0c" + this.getOriginalUrl()));
                    this.goBack();
                    return true;
                }
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        AbsoluteLayout.LayoutParams lp = (AbsoluteLayout.LayoutParams)this.progressbar.getLayoutParams();
        lp.x = l;
        lp.y = t;
        this.progressbar.setLayoutParams((ViewGroup.LayoutParams)lp);
        super.onScrollChanged(l, t, oldl, oldt);
    }

    public void onSetPageLoadEvent(PageLoadEvent pageLoadEvent) {
        this.pageLoadEvent = pageLoadEvent;
    }

    public static interface PageLoadEvent {
        public void onPageStarted(String var1);

        public void onPageFinished(String var1);

        public void onLoadResource();
    }

    public class WebChromeClient
    extends android.webkit.WebChromeClient {
        public void onProgressChanged(WebView view, int newProgress) {
            Log.i((String)TAG, (String)("webview \u8fdb\u5ea6\uff1a" + newProgress));
            if (newProgress == 100) {
                ProgressWebView.this.progressbar.setVisibility(8);
            } else {
                if (ProgressWebView.this.progressbar.getVisibility() == 8) {
                    ProgressWebView.this.progressbar.setVisibility(0);
                }
                ProgressWebView.this.progressbar.setProgress(newProgress);
            }
            super.onProgressChanged(view, newProgress);
        }
    }
}

