/*
 * Decompiled with CFR 0.152.
 */
package com.basic.widgets;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;

public class ImageViewButton
extends ImageView
implements View.OnTouchListener {
    public static final float ENABLE_ALPHA = 1.0f;
    public static final float PRESSED_ALPHA = 0.5f;

    public ImageViewButton(Context context) {
        super(context);
        this.initView();
    }

    public ImageViewButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public ImageViewButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        this.setOnTouchListener(this);
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.performDown();
                break;
            }
            case 1: {
                this.performUp();
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                this.performUp();
                break;
            }
        }
        return false;
    }

    public void performDown() {
        this.setAlpha(0.5f);
    }

    public void performUp() {
        this.setAlpha(1.0f);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.setAlpha(1.0f);
        } else {
            this.setAlpha(0.5f);
        }
    }
}

