/*
 * Decompiled with CFR 0.152.
 */
package com.basic.widgets;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import com.base.libs.R;
import com.basic.application.BaseApplication;
import com.basic.widgets.BaseAlertCallback;

public class BaseAlertViewPopup
extends LinearLayout {
    protected PopupWindow dialog;
    protected BaseAlertCallback callback;

    public BaseAlertViewPopup(Context context) {
        super(context);
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.dialog = new PopupWindow((View)this, -1, -1);
        this.dialog.setClippingEnabled(true);
        this.dialog.setFocusable(true);
        this.dialog.setTouchable(true);
        this.dialog.setBackgroundDrawable(context.getResources().getDrawable(R.drawable.alert_view_bg));
    }

    public void setBackgroundDrawable(int drawableId) {
        this.dialog.setBackgroundDrawable(this.getContext().getResources().getDrawable(drawableId));
    }

    public void show(BaseAlertCallback cb) {
        this.showByAnimation(cb, R.anim.popup_from_bottom, null);
    }

    public void showOnDialog(View view, BaseAlertCallback cb) {
        this.showByAnimation(cb, R.anim.popup_from_bottom, view);
    }

    public void showByAnimation(BaseAlertCallback cb, int animationId, View dialogView) {
        this.callback = cb;
        if (this.dialog == null || this.dialog.isShowing()) {
            return;
        }
        Activity activity = (Activity)this.getContext();
        BaseApplication baseApplication = (BaseApplication)activity.getApplication();
        if (!baseApplication.getActivityShowMap().get(activity.getLocalClassName()).booleanValue()) {
            return;
        }
        View view = activity.getWindow().getDecorView();
        if (view == null || view.getWindowToken() == null) {
            return;
        }
        if (dialogView != null) {
            view = dialogView;
            this.dialog.setWindowLayoutMode(-2, -2);
        }
        this.dialog.showAtLocation(view, 17, 0, 0);
        if (animationId > 0) {
            this.dialog.getContentView().startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)animationId));
        }
        this.dialog.getContentView().setEnabled(true);
    }

    public void dismissByAnimation() {
        this.dismissByAnimation(R.anim.dismiss_to_bottom);
    }

    public void dismissByAnimation(int id2) {
        if (this.dialog == null || !this.dialog.isShowing()) {
            return;
        }
        if (id2 == 0) {
            this.dialog.getContentView().post(new Runnable(){

                @Override
                public void run() {
                    BaseAlertViewPopup.this.dismiss();
                }
            });
            this.dialog.getContentView().setEnabled(false);
            return;
        }
        Animation animation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)id2);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                BaseAlertViewPopup.this.dialog.getContentView().post(new Runnable(){

                    @Override
                    public void run() {
                        BaseAlertViewPopup.this.dismiss();
                    }
                });
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.dialog.getContentView().startAnimation(animation);
        this.dialog.getContentView().setEnabled(false);
    }

    public void dismiss() {
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.dismiss();
            this.dialog.getContentView().clearAnimation();
        }
    }

    public void destroy() {
        this.dismiss();
        this.dialog = null;
    }

    public View getContentView() {
        return this.dialog.getContentView();
    }
}

