/*
 * Decompiled with CFR 0.152.
 */
package com.basic.util;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class RecycleBitmap {
    private static final String TAG = "RecycleBitmap";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recycleMapCache(LinkedHashMap<String, Bitmap> imgCache, int maxSize, int freeSize) {
        if (imgCache.values().size() > maxSize) {
            LinkedHashMap<String, Bitmap> linkedHashMap = imgCache;
            synchronized (linkedHashMap) {
                Iterator<String> it = imgCache.keySet().iterator();
                while (it.hasNext() && imgCache.keySet().size() > freeSize) {
                    Bitmap bmp = imgCache.get(it.next());
                    if (bmp != null && !bmp.isRecycled()) {
                        bmp.recycle();
                        bmp = null;
                    }
                    it.remove();
                }
            }
            System.gc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recycle(Map<View, int[]> mapViews) {
        Map<View, int[]> map = mapViews;
        synchronized (map) {
            for (View view : mapViews.keySet()) {
                if (view == null) {
                    return;
                }
                int[] recycleIds = mapViews.get(view);
                if (view instanceof AbsListView) {
                    RecycleBitmap.recycleAbsList((AbsListView)view, recycleIds);
                    continue;
                }
                if (view instanceof ImageView) {
                    RecycleBitmap.recycleImageView(view);
                    continue;
                }
                if (!(view instanceof ViewGroup)) continue;
                RecycleBitmap.recycleViewGroup((ViewGroup)view, recycleIds);
            }
        }
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recycleAbsList(AbsListView absView, int[] recycleIds) {
        if (absView == null) {
            return;
        }
        AbsListView absListView = absView;
        synchronized (absListView) {
            for (int index = absView.getFirstVisiblePosition(); index <= absView.getLastVisiblePosition(); ++index) {
                ViewGroup views = (ViewGroup)((ListAdapter)absView.getAdapter()).getView(index, null, (ViewGroup)absView);
                for (int count = 0; count < recycleIds.length; ++count) {
                    RecycleBitmap.recycleImageView(views.findViewById(recycleIds[count]));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void recycleViewGroup(ViewGroup layout, int[] recycleIds) {
        if (layout == null) {
            return;
        }
        ViewGroup viewGroup = layout;
        synchronized (viewGroup) {
            int i = 0;
            while (i < layout.getChildCount()) {
                View subView = layout.getChildAt(i);
                if (subView instanceof ViewGroup) {
                    for (int count = 0; count < recycleIds.length; ++count) {
                        RecycleBitmap.recycleImageView(subView.findViewById(recycleIds[count]));
                    }
                } else if (subView instanceof ImageView) {
                    RecycleBitmap.recycleImageView(new View[]{(ImageView)subView});
                }
                ++i;
            }
            return;
        }
    }

    public static void recycleImageView(View ... views) {
        if (views == null) {
            return;
        }
        for (View view : views) {
            Bitmap bmp;
            Drawable drawable;
            if (!(view instanceof ImageView) || !((drawable = ((ImageView)view).getDrawable()) instanceof BitmapDrawable) || (bmp = ((BitmapDrawable)drawable).getBitmap()) == null || bmp.isRecycled()) continue;
            ((ImageView)view).setImageBitmap(null);
            Log.d((String)TAG, (String)("Recycle ImageView : " + view.getId()));
            bmp.recycle();
            bmp = null;
        }
    }
}

