/*
 * Decompiled with CFR 0.152.
 */
package com.basic.util;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.view.View;
import android.view.ViewTreeObserver;

public class BlurBuilder {
    private static final float BITMAP_SCALE = 0.4f;
    private static final float BLUR_RADIUS = 7.5f;

    public static Bitmap blur(View v, float bitmapScale, float blurRadius) {
        Bitmap retBmp = BlurBuilder.getScreenshot(v);
        if (retBmp == null) {
            return null;
        }
        return BlurBuilder.blur(v.getContext(), retBmp, bitmapScale, blurRadius);
    }

    public static Bitmap blur(View v) {
        return BlurBuilder.blur(v, 0.4f, 7.5f);
    }

    public static Bitmap blur(Context ctx, Bitmap image, float bitmapScale, float blurRadius) {
        int width = Math.round((float)image.getWidth() * bitmapScale);
        int height = Math.round((float)image.getHeight() * bitmapScale);
        Bitmap inputBitmap = Bitmap.createScaledBitmap((Bitmap)image, (int)width, (int)height, (boolean)false);
        Bitmap outputBitmap = Bitmap.createBitmap((Bitmap)inputBitmap);
        RenderScript rs = RenderScript.create((Context)ctx);
        ScriptIntrinsicBlur theIntrinsic = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
        Allocation tmpIn = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)inputBitmap);
        Allocation tmpOut = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)outputBitmap);
        theIntrinsic.setRadius(blurRadius);
        theIntrinsic.setInput(tmpIn);
        theIntrinsic.forEach(tmpOut);
        tmpOut.copyTo(outputBitmap);
        return outputBitmap;
    }

    public static Bitmap getScreenshot(View v) {
        try {
            Bitmap b = Bitmap.createBitmap((int)v.getWidth(), (int)v.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(b);
            v.draw(c);
            return b;
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setWindowBackground(final Activity activity) {
        final View content = activity.findViewById(0x1020002).getRootView();
        if (content.getWidth() > 0) {
            Bitmap image = BlurBuilder.blur(content);
            if (image != null) {
                activity.getWindow().setBackgroundDrawable((Drawable)new BitmapDrawable(activity.getResources(), image));
            }
        } else {
            content.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    Bitmap image = BlurBuilder.blur(content);
                    if (image != null) {
                        activity.getWindow().setBackgroundDrawable((Drawable)new BitmapDrawable(activity.getResources(), image));
                    }
                }
            });
        }
    }
}

