/*
 * Decompiled with CFR 0.152.
 */
package com.basic.util;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.ExifInterface;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BitmapUtil {
    public static Bitmap comp(Bitmap image, float hh, float ww, boolean autoCompress) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (autoCompress) {
            long s = image.getRowBytes() * image.getHeight();
            float news = hh * ww;
            if (image.getConfig().equals((Object)Bitmap.Config.ALPHA_8)) {
                news *= 1.0f;
            } else if (image.getConfig().equals((Object)Bitmap.Config.ARGB_4444)) {
                news *= 2.0f;
            } else if (image.getConfig().equals((Object)Bitmap.Config.ARGB_8888)) {
                news *= 4.0f;
            } else if (image.getConfig().equals((Object)Bitmap.Config.RGB_565)) {
                news *= 2.0f;
            }
            if ((float)s > news) {
                int rate = (int)(100.0f * news / (float)s);
                if (rate < 20) {
                    rate = 20;
                }
                Log.i((String)"\u538b\u7f29\u56fe\u7247", (String)("\u538b\u7f29\u6bd4\uff1a" + rate));
                image.compress(Bitmap.CompressFormat.JPEG, rate, (OutputStream)baos);
            } else {
                Log.i((String)"\u538b\u7f29\u56fe\u7247", (String)"\u4e0d\u538b\u7f29");
                image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
            }
        } else {
            image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
        }
        BitmapFactory.Options newOpts = new BitmapFactory.Options();
        newOpts.inJustDecodeBounds = true;
        ByteArrayInputStream isBm = new ByteArrayInputStream(baos.toByteArray());
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)isBm, null, (BitmapFactory.Options)newOpts);
        int w = newOpts.outWidth;
        int h = newOpts.outHeight;
        int be = 1;
        if ((float)w > ww) {
            be = (int)((float)newOpts.outWidth / ww);
        } else if ((float)h > hh) {
            be = (int)((float)newOpts.outHeight / hh);
        }
        Log.i((String)"\u538b\u7f29\u56fe\u7247", (String)("\u7f29\u653e\u6bd4\u4f8b\uff1a" + be));
        if (be <= 0) {
            be = 1;
        }
        newOpts.inSampleSize = be;
        newOpts.inJustDecodeBounds = false;
        isBm = new ByteArrayInputStream(baos.toByteArray());
        bitmap = BitmapFactory.decodeStream((InputStream)isBm, null, (BitmapFactory.Options)newOpts);
        return bitmap;
    }

    public static Bitmap compressImage(Bitmap image, int size) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
        int options = 100;
        while (baos.toByteArray().length / 1024 > size && options > 10) {
            baos.reset();
            image.compress(Bitmap.CompressFormat.JPEG, options -= 10, (OutputStream)baos);
        }
        ByteArrayInputStream isBm = new ByteArrayInputStream(baos.toByteArray());
        try {
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)isBm, null, null);
            return bitmap;
        }
        catch (OutOfMemoryError e) {
            baos.reset();
            image.compress(Bitmap.CompressFormat.JPEG, 10, (OutputStream)baos);
            isBm = new ByteArrayInputStream(baos.toByteArray());
            try {
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)isBm, null, null);
                return bitmap;
            }
            catch (OutOfMemoryError e2) {
                return image;
            }
        }
    }

    public static Bitmap fitSizeImg(String path, int width, int height) {
        if (path == null || path.length() < 1) {
            return null;
        }
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        Bitmap resizeBmp = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)opts);
        int picWidth = opts.outWidth;
        int picHeight = opts.outHeight;
        opts.inSampleSize = 1;
        if (width < picWidth) {
            opts.inSampleSize = picWidth / width;
        } else if (height < picHeight) {
            opts.inSampleSize = picHeight / height;
        }
        opts.inJustDecodeBounds = false;
        resizeBmp = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)opts);
        int angle = BitmapUtil.readPictureDegree(path);
        resizeBmp = BitmapUtil.rotationBitmap(angle, resizeBmp);
        return resizeBmp;
    }

    public static int readPictureDegree(String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }

    public static Bitmap rotationBitmap(int angle, Bitmap bitmap) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)angle);
        try {
            Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            return resizedBitmap;
        }
        catch (OutOfMemoryError e) {
            return bitmap;
        }
    }

    public static Bitmap takeScreenShot(Activity activity) {
        View view = activity.getWindow().getDecorView();
        view.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
        Bitmap bitmap = view.getDrawingCache();
        Rect rect = new Rect();
        activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
        int statusBarHeight = rect.top;
        int width = activity.getWindowManager().getDefaultDisplay().getWidth();
        int height = activity.getWindowManager().getDefaultDisplay().getHeight();
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)statusBarHeight, (int)width, (int)(height - statusBarHeight));
        view.destroyDrawingCache();
        return bitmap2;
    }

    public static void savePic(Bitmap bitmap, String filename, Bitmap.CompressFormat format, int quality) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(filename);
            if (fileOutputStream != null) {
                bitmap.compress(format, quality, (OutputStream)fileOutputStream);
                fileOutputStream.flush();
                fileOutputStream.close();
            }
        }
        catch (FileNotFoundException e) {
            Log.d((String)"BitmapUtil", (String)"Exception:FileNotFoundException");
            e.printStackTrace();
        }
        catch (IOException e) {
            Log.d((String)"BitmapUtil", (String)"IOException:IOException");
            e.printStackTrace();
        }
    }

    public static void savePic(Bitmap bitmap, String filename) {
        BitmapUtil.savePic(bitmap, filename, Bitmap.CompressFormat.PNG, 90);
    }

    public static Bitmap drawableToBitmap(Drawable drawable) {
        Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)(drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    public static Bitmap getLocalBitmap(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return Bitmap.createBitmap((int)100, (int)100, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        try {
            Bitmap bitmap;
            BitmapFactory.Options optSize = new BitmapFactory.Options();
            optSize.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)url, (BitmapFactory.Options)optSize);
            int imgSize = optSize.outWidth * optSize.outHeight;
            if (imgSize > 1500000) {
                BitmapFactory.Options thOption = new BitmapFactory.Options();
                thOption.inSampleSize = 4;
                bitmap = BitmapFactory.decodeFile((String)url, (BitmapFactory.Options)thOption);
            } else {
                bitmap = BitmapFactory.decodeFile((String)url);
            }
            return bitmap;
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            return Bitmap.createBitmap((int)100, (int)100, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
    }

    public static Drawable zoomDrawable(Drawable drawable, int w, int h) {
        int width = drawable.getIntrinsicWidth();
        int height = drawable.getIntrinsicHeight();
        Bitmap oldbmp = BitmapUtil.drawableToBitmap(drawable);
        Matrix matrix = new Matrix();
        float scaleWidth = (float)w / (float)width;
        float scaleHeight = (float)h / (float)height;
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap newbmp = Bitmap.createBitmap((Bitmap)oldbmp, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return new BitmapDrawable(newbmp);
    }

    public static Bitmap zoomBitmap(Bitmap bmp, float w, float h) {
        int width = bmp.getWidth();
        int height = bmp.getHeight();
        Matrix matrix = new Matrix();
        float scaleWidth = w / (float)width;
        float scaleHeight = h / (float)height;
        matrix.postScale(scaleWidth, scaleHeight);
        return Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
    }

    public static Bitmap getViewBitmap(View v) {
        v.clearFocus();
        v.setPressed(false);
        boolean willNotCache = v.willNotCacheDrawing();
        v.setWillNotCacheDrawing(false);
        int color = v.getDrawingCacheBackgroundColor();
        v.setDrawingCacheBackgroundColor(0);
        if (color != 0) {
            v.destroyDrawingCache();
        }
        v.buildDrawingCache();
        Bitmap cacheBitmap = v.getDrawingCache();
        if (cacheBitmap == null) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)cacheBitmap);
        v.destroyDrawingCache();
        v.setWillNotCacheDrawing(willNotCache);
        v.setDrawingCacheBackgroundColor(color);
        return bitmap;
    }

    public static Bitmap getBitmapFromView(View view) {
        Bitmap returnedBitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(returnedBitmap);
        Drawable bgDrawable = view.getBackground();
        if (bgDrawable != null) {
            bgDrawable.draw(canvas);
        } else {
            canvas.drawColor(-1);
        }
        view.draw(canvas);
        return returnedBitmap;
    }

    public static Bitmap createScaledBitmap(Bitmap image, float hh, float ww, int size, Bitmap.CompressFormat format) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int reduce = 100; reduce > 0; reduce -= 5) {
            try {
                image.compress(format, reduce, (OutputStream)baos);
                break;
            }
            catch (Exception e) {
                baos.reset();
                continue;
            }
        }
        BitmapFactory.Options newOpts = new BitmapFactory.Options();
        newOpts.inJustDecodeBounds = true;
        ByteArrayInputStream isBm = new ByteArrayInputStream(baos.toByteArray());
        BitmapFactory.decodeStream((InputStream)isBm, null, (BitmapFactory.Options)newOpts);
        int w = newOpts.outWidth;
        int h = newOpts.outHeight;
        int be = 1;
        if ((float)w > ww) {
            be = (int)((float)newOpts.outWidth / ww);
        } else if ((float)h > hh) {
            be = (int)((float)newOpts.outHeight / hh);
        }
        if (be <= 0) {
            be = 1;
        }
        Log.i((String)"\u7f29\u653e\u56fe\u7247", (String)("\u7f29\u653e\u6bd4\u4f8b\uff1a" + be));
        Log.i((String)"\u538b\u7f29\u56fe\u7247", (String)("\u5f53\u524dkb\uff1a" + baos.toByteArray().length / 1024));
        int options = 100;
        while (baos.toByteArray().length / 1024 > size && options > 10) {
            baos.reset();
            image.compress(format, options -= 5, (OutputStream)baos);
        }
        Log.i((String)"\u538b\u7f29\u56fe\u7247", (String)("\u538b\u7f29\u540ekb\uff1a" + baos.toByteArray().length / 1024));
        newOpts.inSampleSize = be;
        newOpts.inJustDecodeBounds = false;
        isBm = new ByteArrayInputStream(baos.toByteArray());
        return BitmapFactory.decodeStream((InputStream)isBm, null, (BitmapFactory.Options)newOpts);
    }

    public static Bitmap toRoundBitmap(Bitmap bitmap) {
        float dst_bottom;
        float dst_right;
        float dst_top;
        float dst_left;
        float right;
        float left;
        float bottom;
        float top;
        float roundPx;
        int height;
        if (bitmap == null) {
            return null;
        }
        int width = bitmap.getWidth();
        if (width <= (height = bitmap.getHeight())) {
            roundPx = width / 2;
            top = 0.0f;
            bottom = width;
            left = 0.0f;
            right = width;
            height = width;
            dst_left = 0.0f;
            dst_top = 0.0f;
            dst_right = width;
            dst_bottom = width;
        } else {
            float clip;
            roundPx = height / 2;
            left = clip = (float)((width - height) / 2);
            right = (float)width - clip;
            top = 0.0f;
            bottom = height;
            width = height;
            dst_left = 0.0f;
            dst_top = 0.0f;
            dst_right = height;
            dst_bottom = height;
        }
        Bitmap output = null;
        try {
            output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (OutOfMemoryError e) {
            System.gc();
            System.runFinalization();
            output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas canvas = new Canvas(output);
        int color = -12434878;
        Paint paint = new Paint();
        Rect src = new Rect((int)left, (int)top, (int)right, (int)bottom);
        Rect dst = new Rect((int)dst_left, (int)dst_top, (int)dst_right, (int)dst_bottom);
        RectF rectF = new RectF(dst);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawRoundRect(rectF, roundPx, roundPx, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, src, dst, paint);
        return output;
    }

    public static Bitmap grey(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        Bitmap faceIconGreyBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(faceIconGreyBitmap);
        Paint paint = new Paint();
        ColorMatrix colorMatrix = new ColorMatrix();
        colorMatrix.setSaturation(0.0f);
        ColorMatrixColorFilter colorMatrixFilter = new ColorMatrixColorFilter(colorMatrix);
        paint.setColorFilter((ColorFilter)colorMatrixFilter);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        return faceIconGreyBitmap;
    }
}

