/*
 * Decompiled with CFR 0.152.
 */
package com.basic.controller;

import android.content.Context;
import android.content.SharedPreferences;
import com.basic.controller.TimeSegment;
import com.basic.util.GsonUtil;
import com.basic.util.TimeUtil;
import com.google.gson.reflect.TypeToken;
import com.orhanobut.logger.Logger;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class SyncedDataManager {
    private static SyncedDataManager instance = new SyncedDataManager();
    private static final String SYNCED_MONTHS = "SYNCED_MONTHS";
    private static final String TEMPERATURE_STRING = "TEMPERATURE";
    private static final String BODY_STATUS_STRING = "BODY_STATUS";

    public static synchronized SyncedDataManager getInstance() {
        return instance;
    }

    public TimeSegment getRequestTime(Context context, int familyMemberId, SaveType saveType, Date startDate, Date endDate) {
        Calendar endCal;
        Calendar startCal = this.getCalendarDate(startDate);
        if (startCal.after(endCal = this.getCalendarDate(endDate))) {
            return null;
        }
        List<Calendar> hasSyncedMonths = this.getSyncedTime(context, familyMemberId, saveType);
        if (hasSyncedMonths == null || hasSyncedMonths.size() == 0) {
            return this.getTimeSegment(startCal, endCal);
        }
        Calendar lastMonth = hasSyncedMonths.get(hasSyncedMonths.size() - 1);
        Calendar firstMonth = hasSyncedMonths.get(0);
        if (!startCal.before(firstMonth) && !endCal.after(lastMonth)) {
            return null;
        }
        if (startCal.before(firstMonth) && endCal.after(lastMonth)) {
            return this.getTimeSegment(startCal, endCal);
        }
        if (startCal.before(firstMonth)) {
            return this.getTimeSegment(startCal, firstMonth);
        }
        return this.getTimeSegment(lastMonth, endCal);
    }

    public TimeSegment getTimeSegment(Calendar startCal, Calendar endCal) {
        TimeSegment timeSegment = new TimeSegment();
        timeSegment.setStartTime(TimeUtil.getTimestamp(startCal.getTime().getTime()));
        endCal.add(2, 1);
        int orgTime = TimeUtil.getTimestamp(endCal.getTime().getTime());
        timeSegment.setEndTime(orgTime - 1);
        return timeSegment;
    }

    public void setSyncedTime(Context context, Date startDate, Date endDate, int familyMemberId, SaveType saveType) {
        Calendar endCal;
        Calendar startCal = this.getCalendarDate(startDate);
        if (startCal.after(endCal = this.getCalendarDate(endDate))) {
            return;
        }
        List<Calendar> hasSyncedMonths = this.getSyncedTime(context, familyMemberId, saveType);
        if (hasSyncedMonths == null) {
            hasSyncedMonths = new LinkedList<Calendar>();
            Logger.d((Object)("no synced data yet," + (Object)((Object)saveType)));
        }
        while (!startCal.after(endCal)) {
            if (!hasSyncedMonths.contains(startCal)) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(startCal.getTime());
                hasSyncedMonths.add(calendar);
            }
            startCal.add(2, 1);
        }
        String syncedMonths = GsonUtil.getGson().toJson(hasSyncedMonths);
        Logger.d((Object)("set synced months: " + syncedMonths));
        this.setSyncedMonths(context, syncedMonths, familyMemberId, saveType);
    }

    public List<Calendar> getSyncedTime(Context context, int familyMemberId, SaveType saveType) {
        String jsonString = this.getSyncedMonths(context, familyMemberId, saveType);
        Logger.d((Object)("get synced months: " + jsonString));
        List syncedMonths = (List)GsonUtil.getGson().fromJson(jsonString, new TypeToken<List<Calendar>>(){}.getType());
        if (syncedMonths != null) {
            Collections.sort(syncedMonths);
        }
        return syncedMonths;
    }

    public Calendar getCalendarDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(TimeUtil.getDateBeginTimeInMillis(date.getTime()));
        c.set(5, 1);
        return c;
    }

    public void setSyncedMonths(Context context, String content, int familyMemberId, SaveType saveType) {
        String dataType = this.getDataType(saveType);
        SharedPreferences mySharedPreferences = context.getSharedPreferences(SYNCED_MONTHS + dataType + familyMemberId, 0);
        SharedPreferences.Editor editor = mySharedPreferences.edit();
        editor.putString(SYNCED_MONTHS, content);
        editor.apply();
    }

    public String getSyncedMonths(Context context, int familyMemberId, SaveType saveType) {
        String dataType = this.getDataType(saveType);
        SharedPreferences settings = context.getSharedPreferences(SYNCED_MONTHS + dataType + familyMemberId, 0);
        return settings.getString(SYNCED_MONTHS, "");
    }

    private String getDataType(SaveType saveType) {
        switch (saveType) {
            case BODY_STATUS: {
                return BODY_STATUS_STRING;
            }
            case TEMPERATURE: {
                return TEMPERATURE_STRING;
            }
        }
        return "";
    }

    public static enum SaveType {
        TEMPERATURE(1),
        BODY_STATUS(2);

        private final int value;

        private SaveType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

