/*
 * Decompiled with CFR 0.152.
 */
package com.basic.application;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Bundle;
import android.support.multidex.MultiDex;
import android.support.multidex.MultiDexApplication;
import android.view.ViewGroup;
import com.basic.util.TypeFaceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class BaseApplication
extends MultiDexApplication {
    protected final Map<String, Boolean> activityShowMap = new HashMap<String, Boolean>();
    private int resumedCount;
    private final TypeFaceUtil typeFaceUtil = new TypeFaceUtil();
    private final Properties config = new Properties();
    private Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityStarted(Activity activity) {
            if (BaseApplication.this.resumedCount == 0) {
                BaseApplication.this.showApplication();
            }
            BaseApplication.this.resumedCount++;
        }

        public void onActivityResumed(Activity activity) {
            BaseApplication.this.activityShowMap.put(activity.getLocalClassName(), true);
        }

        public void onActivityPaused(Activity activity) {
            BaseApplication.this.activityShowMap.put(activity.getLocalClassName(), false);
        }

        public void onActivityStopped(Activity activity) {
            BaseApplication.this.resumedCount--;
            if (BaseApplication.this.resumedCount == 0) {
                BaseApplication.this.gotoBackground();
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    };

    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        MultiDex.install((Context)this);
    }

    public void onCreate() {
        super.onCreate();
        this.initConfig();
        this.registerActivityLifecycleCallbacks(this.activityLifecycleCallbacks);
    }

    private void initConfig() {
        try {
            InputStream in = this.getAssets().open("config.properties");
            this.config.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getConfigProperty(String name) {
        return this.config.getProperty(name);
    }

    public int getConfigColor(String name) {
        return Color.parseColor((String)this.config.getProperty(name));
    }

    protected void showApplication() {
    }

    protected void gotoBackground() {
    }

    public Map<String, Boolean> getActivityShowMap() {
        return this.activityShowMap;
    }

    public Typeface getRegularTypeface() {
        return this.typeFaceUtil.getRegularTypeface((Context)this);
    }

    public Typeface getLightTypeface() {
        return this.typeFaceUtil.getLightTypeface((Context)this);
    }

    public Typeface getBoldTypeface() {
        return this.typeFaceUtil.getBoldTypeface((Context)this);
    }

    public Typeface getBongmiTypeface() {
        return this.typeFaceUtil.getBongmiTypeface((Context)this);
    }

    public void setTypeFace(Typeface typeFace, ViewGroup parent) {
        this.typeFaceUtil.setTypeFace(typeFace, parent);
    }
}

