/*
 * Decompiled with CFR 0.152.
 */
package com.basic.activity;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import java.lang.reflect.Method;

public class SystemBarTint {
    public static final int DEFAULT_TINT_COLOR = 0;
    private static String navBarOverride;
    private final SystemBarConfig config;
    private boolean statusBarAvailable;
    private boolean navBarAvailable;
    private boolean statusBarTintEnabled;
    private boolean navBarTintEnabled;
    private View statusBarTintView;
    private View navBarTintView;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    public SystemBarTint(Activity activity) {
        Window win = activity.getWindow();
        ViewGroup decorViewGroup = (ViewGroup)win.getDecorView();
        if (Build.VERSION.SDK_INT >= 19) {
            int[] attrs = new int[]{16843759, 16843760};
            TypedArray a = activity.obtainStyledAttributes(attrs);
            try {
                this.statusBarAvailable = a.getBoolean(0, false);
            }
            finally {
                a.recycle();
            }
            WindowManager.LayoutParams winParams = win.getAttributes();
            int bits = 0x4000000;
            if ((winParams.flags & bits) != 0) {
                this.statusBarAvailable = true;
            }
            if ((winParams.flags & (bits = 0x8000000)) != 0) {
                this.navBarAvailable = true;
            }
        }
        this.config = new SystemBarConfig(activity, this.statusBarAvailable, this.navBarAvailable);
        if (!this.config.hasNavigtionBar()) {
            this.navBarAvailable = false;
        }
        if (this.statusBarAvailable) {
            this.setupStatusBarView((Context)activity, decorViewGroup);
        }
        if (this.navBarAvailable) {
            this.setupNavBarView((Context)activity, decorViewGroup);
        }
    }

    public void setStatusBarTintEnabled(boolean enabled) {
        this.statusBarTintEnabled = enabled;
        if (this.statusBarAvailable) {
            this.statusBarTintView.setVisibility(enabled ? 0 : 8);
        }
    }

    public void setNavigationBarTintEnabled(boolean enabled) {
        this.navBarTintEnabled = enabled;
        if (this.navBarAvailable) {
            this.navBarTintView.setVisibility(enabled ? 0 : 8);
        }
    }

    public void setTintColor(int color) {
        this.setStatusBarTintColor(color);
        this.setNavigationBarTintColor(color);
    }

    public void setTintResource(int res) {
        this.setStatusBarTintResource(res);
        this.setNavigationBarTintResource(res);
    }

    public void setTintDrawable(Drawable drawable) {
        this.setStatusBarTintDrawable(drawable);
        this.setNavigationBarTintDrawable(drawable);
    }

    public void setTintAlpha(float alpha) {
        this.setStatusBarAlpha(alpha);
        this.setNavigationBarAlpha(alpha);
    }

    public void setStatusBarTintColor(int color) {
        if (this.statusBarAvailable) {
            this.statusBarTintView.setBackgroundColor(color);
        }
    }

    public void setStatusBarTintResource(int res) {
        if (this.statusBarAvailable) {
            this.statusBarTintView.setBackgroundResource(res);
        }
    }

    public void setStatusBarTintDrawable(Drawable drawable) {
        if (this.statusBarAvailable) {
            this.statusBarTintView.setBackgroundDrawable(drawable);
        }
    }

    @TargetApi(value=11)
    public void setStatusBarAlpha(float alpha) {
        if (this.statusBarAvailable && Build.VERSION.SDK_INT >= 11) {
            this.statusBarTintView.setAlpha(alpha);
        }
    }

    public void setNavigationBarTintColor(int color) {
        if (this.navBarAvailable) {
            this.navBarTintView.setBackgroundColor(color);
        }
    }

    public void setNavigationBarTintResource(int res) {
        if (this.navBarAvailable) {
            this.navBarTintView.setBackgroundResource(res);
        }
    }

    public void setNavigationBarTintDrawable(Drawable drawable) {
        if (this.navBarAvailable) {
            this.navBarTintView.setBackgroundDrawable(drawable);
        }
    }

    @TargetApi(value=11)
    public void setNavigationBarAlpha(float alpha) {
        if (this.navBarAvailable && Build.VERSION.SDK_INT >= 11) {
            this.navBarTintView.setAlpha(alpha);
        }
    }

    public SystemBarConfig getConfig() {
        return this.config;
    }

    public boolean isStatusBarTintEnabled() {
        return this.statusBarTintEnabled;
    }

    public boolean isNavBarTintEnabled() {
        return this.navBarTintEnabled;
    }

    private void setupStatusBarView(Context context, ViewGroup decorViewGroup) {
        this.statusBarTintView = new View(context);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, this.config.getStatusBarHeight());
        params.gravity = 48;
        if (this.navBarAvailable && !this.config.isNavigationAtBottom()) {
            params.rightMargin = this.config.getNavigationBarWidth();
        }
        this.statusBarTintView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.statusBarTintView.setBackgroundColor(0);
        this.statusBarTintView.setVisibility(8);
        decorViewGroup.addView(this.statusBarTintView);
    }

    private void setupNavBarView(Context context, ViewGroup decorViewGroup) {
        FrameLayout.LayoutParams params;
        this.navBarTintView = new View(context);
        if (this.config.isNavigationAtBottom()) {
            params = new FrameLayout.LayoutParams(-1, this.config.getNavigationBarHeight());
            params.gravity = 80;
        } else {
            params = new FrameLayout.LayoutParams(this.config.getNavigationBarWidth(), -1);
            params.gravity = 5;
        }
        this.navBarTintView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.navBarTintView.setBackgroundColor(0);
        this.navBarTintView.setVisibility(8);
        decorViewGroup.addView(this.navBarTintView);
    }

    static {
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                Class<?> c = Class.forName("android.os.SystemProperties");
                Method m = c.getDeclaredMethod("get", String.class);
                m.setAccessible(true);
                navBarOverride = (String)m.invoke(null, "qemu.hw.mainkeys");
            }
            catch (Throwable e) {
                navBarOverride = null;
            }
        }
    }

    public static class SystemBarConfig {
        private static final String STATUS_BAR_HEIGHT_RES_NAME = "status_bar_height";
        private static final String NAV_BAR_HEIGHT_RES_NAME = "navigation_bar_height";
        private static final String NAV_BAR_HEIGHT_LANDSCAPE_RES_NAME = "navigation_bar_height_landscape";
        private static final String NAV_BAR_WIDTH_RES_NAME = "navigation_bar_width";
        private static final String SHOW_NAV_BAR_RES_NAME = "config_showNavigationBar";
        private final boolean translucentStatusBar;
        private final boolean translucentNavBar;
        private final int statusBarHeight;
        private final int actionBarHeight;
        private final boolean hasNavigationBar;
        private final int navigationBarHeight;
        private final int navigationBarWidth;
        private final boolean inPortrait;
        private final float smallestWidthDp;

        private SystemBarConfig(Activity activity, boolean translucentStatusBar, boolean traslucentNavBar) {
            Resources res = activity.getResources();
            this.inPortrait = res.getConfiguration().orientation == 1;
            this.smallestWidthDp = this.getSmallestWidthDp(activity);
            this.statusBarHeight = this.getInternalDimensionSize(res, STATUS_BAR_HEIGHT_RES_NAME);
            this.actionBarHeight = this.getActionBarHeight((Context)activity);
            this.navigationBarHeight = this.getNavigationBarHeight((Context)activity);
            this.navigationBarWidth = this.getNavigationBarWidth((Context)activity);
            this.hasNavigationBar = this.navigationBarHeight > 0;
            this.translucentStatusBar = translucentStatusBar;
            this.translucentNavBar = traslucentNavBar;
        }

        @TargetApi(value=14)
        private boolean hasNavBar(Context context) {
            Resources res = context.getResources();
            int resourceId = res.getIdentifier(SHOW_NAV_BAR_RES_NAME, "bool", "android");
            if (resourceId != 0) {
                boolean hasNav = res.getBoolean(resourceId);
                if ("1".equals(navBarOverride)) {
                    hasNav = false;
                } else if ("0".equals(navBarOverride)) {
                    hasNav = true;
                }
                return hasNav;
            }
            return !ViewConfiguration.get((Context)context).hasPermanentMenuKey();
        }

        private int getInternalDimensionSize(Resources res, String key) {
            int result = 0;
            int resourceId = res.getIdentifier(key, "dimen", "android");
            if (resourceId > 0) {
                result = res.getDimensionPixelSize(resourceId);
            }
            return result;
        }

        @SuppressLint(value={"NewApi"})
        private float getSmallestWidthDp(Activity activity) {
            DisplayMetrics metrics = new DisplayMetrics();
            if (Build.VERSION.SDK_INT >= 16) {
                activity.getWindowManager().getDefaultDisplay().getRealMetrics(metrics);
            } else {
                activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
            }
            float widthDp = (float)metrics.widthPixels / metrics.density;
            float heightDp = (float)metrics.heightPixels / metrics.density;
            return Math.min(widthDp, heightDp);
        }

        public boolean isNavigationAtBottom() {
            return this.smallestWidthDp >= 600.0f || this.inPortrait;
        }

        public int getStatusBarHeight() {
            return this.statusBarHeight;
        }

        public int getActionBarHeight() {
            return this.actionBarHeight;
        }

        @TargetApi(value=14)
        private int getActionBarHeight(Context context) {
            int result = 0;
            if (Build.VERSION.SDK_INT >= 14) {
                TypedValue tv = new TypedValue();
                context.getTheme().resolveAttribute(16843499, tv, true);
                result = TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)context.getResources().getDisplayMetrics());
            }
            return result;
        }

        public boolean hasNavigtionBar() {
            return this.hasNavigationBar;
        }

        public int getNavigationBarHeight() {
            return this.navigationBarHeight;
        }

        @TargetApi(value=14)
        private int getNavigationBarHeight(Context context) {
            Resources res = context.getResources();
            int result = 0;
            if (Build.VERSION.SDK_INT >= 14 && this.hasNavBar(context)) {
                String key = this.inPortrait ? NAV_BAR_HEIGHT_RES_NAME : NAV_BAR_HEIGHT_LANDSCAPE_RES_NAME;
                return this.getInternalDimensionSize(res, key);
            }
            return result;
        }

        public int getNavigationBarWidth() {
            return this.navigationBarWidth;
        }

        @TargetApi(value=14)
        private int getNavigationBarWidth(Context context) {
            Resources res = context.getResources();
            int result = 0;
            if (Build.VERSION.SDK_INT >= 14 && this.hasNavBar(context)) {
                return this.getInternalDimensionSize(res, NAV_BAR_WIDTH_RES_NAME);
            }
            return result;
        }

        public int getPixelInsetTop(boolean withActionBar) {
            return (this.translucentStatusBar ? this.statusBarHeight : 0) + (withActionBar ? this.actionBarHeight : 0);
        }

        public int getPixelInsetBottom() {
            if (this.translucentNavBar && this.isNavigationAtBottom()) {
                return this.navigationBarHeight;
            }
            return 0;
        }

        public int getPixelInsetRight() {
            if (this.translucentNavBar && !this.isNavigationAtBottom()) {
                return this.navigationBarWidth;
            }
            return 0;
        }
    }
}

