/*
 * Decompiled with CFR 0.152.
 */
package com.basic.activity;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Toast;
import com.basic.activity.SystemBarTint;
import com.basic.application.BaseApplication;
import com.basic.util.BitmapUtil;
import com.basic.util.Constants;
import com.basic.widgets.ActionBar;
import com.orhanobut.logger.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BaseActivity
extends AppCompatActivity {
    protected ActionBar actionBar;
    protected boolean isSetFont;
    protected String photoName = null;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    protected void onResume() {
        super.onResume();
        this.setFont(0x1020002);
    }

    protected void setFont(int root) {
        if (this.isSetFont) {
            return;
        }
        this.isSetFont = true;
        BaseApplication application = (BaseApplication)this.getApplicationContext();
        ViewGroup viewGroup = (ViewGroup)this.findViewById(root);
        application.setTypeFace(application.getRegularTypeface(), viewGroup);
    }

    protected void addDefaultActionBar(int resourceId, int barDefaultTitleId, int barDefaultBackId, int barDefaultRightIconId) {
        this.actionBar = new ActionBar(this, resourceId, barDefaultTitleId, barDefaultBackId, barDefaultRightIconId);
        BaseApplication application = (BaseApplication)this.getApplicationContext();
        this.actionBar.setTypeface(application.getRegularTypeface());
    }

    protected void setDefaultActionBarTitle(String title) {
        if (this.actionBar != null) {
            this.actionBar.setTitle(title);
        }
    }

    protected void showDefaultActionBarRight(View.OnClickListener click) {
        if (this.actionBar != null) {
            this.actionBar.showRightIcon(click);
        }
    }

    protected void initSystemBar(int color) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.setTranslucentStatus(true);
        }
        SystemBarTint tintManager = new SystemBarTint((Activity)this);
        tintManager.setStatusBarTintEnabled(true);
        tintManager.setStatusBarTintColor(color);
    }

    protected void hideActionBar() {
        android.support.v7.app.ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.hide();
        }
    }

    @TargetApi(value=19)
    protected void setTranslucentStatus(boolean on) {
        Window win = this.getWindow();
        WindowManager.LayoutParams winParams = win.getAttributes();
        int bits = 0x4000000;
        winParams.flags = on ? (winParams.flags |= 0x4000000) : (winParams.flags &= 0xFBFFFFFF);
        win.setAttributes(winParams);
    }

    public void showMetrics() {
        DisplayMetrics metrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        String msg = "\u5c4f\u5e55DPI : " + metrics.densityDpi + "(" + metrics.density + ")" + " , \u5c4f\u5e55\u5bbd : " + metrics.widthPixels + " , \u5c4f\u5e55\u957f : " + metrics.heightPixels;
        Toast.makeText((Context)this, (CharSequence)msg, (int)0).show();
    }

    public DisplayMetrics getMetrics() {
        DisplayMetrics metrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        String msg = "\u5c4f\u5e55DPI : " + metrics.densityDpi + "(" + metrics.density + ")" + " , \u5c4f\u5e55\u5bbd : " + metrics.widthPixels + " , \u5c4f\u5e55\u957f : " + metrics.heightPixels;
        Logger.i((String)msg, (Object[])new Object[0]);
        return metrics;
    }

    public int getActionBarHeight() {
        int actionBarHeight = 0;
        TypedValue tv = new TypedValue();
        if (this.getTheme().resolveAttribute(16843499, tv, true)) {
            actionBarHeight = TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)this.getResources().getDisplayMetrics());
        }
        return actionBarHeight;
    }

    public int getStatusBarHeight() {
        int result = 0;
        int resourceId = this.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = this.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public boolean checkPermission(String permissionString) {
        int permission2 = ContextCompat.checkSelfPermission((Context)this, (String)permissionString);
        Logger.d((Object)("\u8bf7\u6c42\u6743\u9650 \uff1a " + permissionString + ", " + permission2));
        return permission2 == 0;
    }

    protected void requestCamera(int requestCode) {
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") != 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"}, (int)requestCode);
        }
    }

    protected void requestGallery(int requestCode) {
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)requestCode);
        }
    }

    protected Intent getVideoIntent() {
        Intent intent = new Intent("android.intent.action.PICK", null);
        intent.setDataAndType(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, "video/*");
        return intent;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    protected Intent getCaptureIntent() {
        boolean mkFlag;
        File vDirPath;
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat dateFormat = new SimpleDateFormat("'IMG'_yyyyMMddHHmmss");
        this.photoName = dateFormat.format(date) + ".jpg";
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        File vFile = new File(Constants.getImagePath((Context)this), this.photoName);
        if (!(vFile.exists() || (vDirPath = vFile.getParentFile()).exists() || (mkFlag = vDirPath.mkdirs()))) {
            return null;
        }
        Uri uri = Uri.fromFile((File)vFile);
        intent.putExtra("output", (Parcelable)uri);
        intent.putExtra("android.intent.extra.videoQuality", 1);
        return intent;
    }

    protected String getCapturePath() {
        File temp = new File(Constants.getImagePath((Context)this) + this.photoName);
        if (!temp.exists()) {
            return null;
        }
        return Constants.getImagePath((Context)this) + this.photoName;
    }

    protected Bitmap getCaptureBitmap() {
        File temp = new File(Constants.getImagePath((Context)this) + this.photoName);
        if (temp.exists()) {
            try {
                return MediaStore.Images.Media.getBitmap((ContentResolver)this.getContentResolver(), (Uri)Uri.fromFile((File)temp));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (OutOfMemoryError e) {
                e.printStackTrace();
                WindowManager windowManager = (WindowManager)this.getSystemService("window");
                Display display = windowManager.getDefaultDisplay();
                int screenWidth = display.getWidth();
                int screenHeight = display.getHeight();
                return BitmapUtil.fitSizeImg(temp.getPath(), screenWidth, screenHeight);
            }
        }
        return null;
    }

    protected File getPhotoFileByBmp(Bitmap mBitmap) throws IOException {
        File file = new File(Constants.getImagePath((Context)this) + this.photoName);
        file.createNewFile();
        FileOutputStream fOut = null;
        try {
            fOut = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        mBitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fOut);
        try {
            assert (fOut != null);
            fOut.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }
}

