package com.basic.widgets;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.base.libs.R;

/**
 * 带进度条的WebView
 *
 * @author 农民伯伯
 *         http://www.cnblogs.com/over140/archive/2013/03/07/2947721.html
 */
@SuppressWarnings("deprecation")
public class ProgressWebView extends WebView {

  private static String TAG = "ProgressWebView";

  private ProgressBar progressbar;
  private PageLoadEvent pageLoadEvent;

  public ProgressWebView(final Context context, AttributeSet attrs) {
    super(context, attrs);
    progressbar = new ProgressBar(context, null, android.R.attr.progressBarStyleHorizontal);
    progressbar.setLayoutParams(new LayoutParams(LayoutParams.FILL_PARENT, 5, 0, 0));
    progressbar.setProgressDrawable(getResources().getDrawable(R.drawable.progress_drawable));
    addView(progressbar);
    //        setWebViewClient(new WebViewClient(){});
    getSettings().setJavaScriptEnabled(true);
    getSettings().setSupportZoom(true);
    setWebChromeClient(new WebChromeClient());
    setWebViewClient(new WebViewClient() {

      @Override
      public void onLoadResource(WebView view, String url) {
        if (pageLoadEvent != null) {
          pageLoadEvent.onLoadResource();
        }
        super.onLoadResource(view, url);
      }

      public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        // Handle the error
      }

      public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (url.startsWith("tel:")) {
          Intent intent = new Intent(Intent.ACTION_DIAL, Uri.parse(url));
          context.startActivity(intent);
        } else if (url.startsWith("http:") || url.startsWith("https:")) {
          view.loadUrl(url);
        } else if (url.startsWith("mailto:")) {
          mailto(view, url);
        }
        return true;
      }

      @Override
      public void onPageStarted(WebView view, String url, Bitmap favicon) {
        Log.d(TAG, "onPageStarted：" + url);
        if (pageLoadEvent != null) {
          pageLoadEvent.onPageStarted(url);
        }
        super.onPageStarted(view, url, favicon);
      }

      @Override
      public void onPageFinished(WebView view, String url) {
        Log.d(TAG, "onPageFinished：" + url);
        if (pageLoadEvent != null) {
          pageLoadEvent.onPageFinished(url);
        }
        super.onPageFinished(view, url);
      }

      private void mailto(WebView view, String url) {
        url = url.replace("mailto:", "");
        // 邮箱正则表达式
        String check = "^\\s*\\w+(?:\\.{0,1}[\\w-]+)*@[a-zA-Z0-9]+(?:[-.][a-zA-Z0-9]+)*\\.[a-zA-Z]+\\s*$";
        Pattern regex = Pattern.compile(check);
        Matcher matcher = regex.matcher(url);
        boolean isMatched = matcher.matches();
        if (isMatched) {
          Intent emailIntent = new Intent(Intent.ACTION_SEND);
          emailIntent.setType("plain/text"); // emailIntent.setType("message/rfc822");
          // //真机上使用
          String[] emailReciver = new String[]{url};
          // 设置邮件默认地址
          emailIntent.putExtra(android.content.Intent.EXTRA_EMAIL, emailReciver);
          // 设置邮件默认标题
          emailIntent.putExtra(android.content.Intent.EXTRA_SUBJECT, "");
          // 设置要默认发送的内容
          emailIntent.putExtra(android.content.Intent.EXTRA_TEXT, "");
          // 调用系统的邮件系统
          context.startActivity(Intent.createChooser(emailIntent, "请选择邮件发送软件"));
        }
      }
    });
  }

  @Override
  public boolean onKeyDown(int keyCode, KeyEvent event) {
    if (event.getAction() == KeyEvent.ACTION_DOWN) {
      switch (keyCode) {
        case KeyEvent.KEYCODE_BACK:
          if (this.canGoBack()) {
            Log.d(TAG, "goback，" + this.getUrl() + "，" + this.getOriginalUrl());
            this.goBack();
            return true;
          }
      }
    }
    return super.onKeyDown(keyCode, event);
  }

  public class WebChromeClient extends android.webkit.WebChromeClient {
    @Override
    public void onProgressChanged(WebView view, int newProgress) {
      Log.i(TAG, "webview 进度：" + newProgress);
      if (newProgress == 100) {
        progressbar.setVisibility(GONE);
      } else {
        if (progressbar.getVisibility() == GONE)
          progressbar.setVisibility(VISIBLE);
        progressbar.setProgress(newProgress);
      }
      super.onProgressChanged(view, newProgress);
    }
  }

  @Override
  protected void onScrollChanged(int l, int t, int oldl, int oldt) {
    LayoutParams lp = (LayoutParams) progressbar.getLayoutParams();
    lp.x = l;
    lp.y = t;
    progressbar.setLayoutParams(lp);
    super.onScrollChanged(l, t, oldl, oldt);
  }

  public void onSetPageLoadEvent(PageLoadEvent pageLoadEvent) {
    this.pageLoadEvent = pageLoadEvent;
  }

  public interface PageLoadEvent {
    void onPageStarted(String url);

    void onPageFinished(String url);

    void onLoadResource();
  }
}