package com.basic.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/**
 * 时间日期相关的工具类
 * Created by Administrator on 2015/7/20.
 */
public class TimeUtil {
  /**
   * 创建某个日期
   *
   * @param year  年
   * @param month 月
   * @param day   日
   * @return 精确到毫秒的时间戳
   */
  public static long createDate(int year, int month, int day) {
    Calendar c = Calendar.getInstance();
    c.set(year, month - 1, day);
    return c.getTimeInMillis();
  }

  /**
   * 计算两个日期之间相差的天数
   *
   * @param date1 较小的时间戳
   * @param date2 较大的时间戳
   * @return 天数
   */
  public static int daysBetween(long date1, long date2) {
    Calendar cal = Calendar.getInstance();
    cal.setTimeInMillis(date1);
    long time1 = getDateBeginTimeInMillis(cal.getTimeInMillis());
    cal.setTimeInMillis(date2);
    long time2 = getDateBeginTimeInMillis(cal.getTimeInMillis());
    long between_days = Math.round(((time2 - time1) * 1.0 / (1000 * 3600 * 24)));

    return Integer.parseInt(String.valueOf(between_days));
  }

  /**
   * 获取当前日期的00:00:00 000的时间戳
   *
   * @return 精确到毫秒的时间戳
   */
  public static long getDateBeginTimeInMillis(long timeInMillis) {
    Calendar c = Calendar.getInstance();
    c.setTimeInMillis(timeInMillis);
    Calendar ret = Calendar.getInstance();
    ret.set(c.get(Calendar.YEAR), c.get(Calendar.MONTH),
        c.get(Calendar.DAY_OF_MONTH), 0, 0, 0);
    return (ret.getTimeInMillis() / 1000) * 1000;
  }

  public static boolean isDateBeginTimeInMillis(Calendar c) {
    return c.get(Calendar.HOUR_OF_DAY) == 0
        && c.get(Calendar.MINUTE) == 0
        && c.get(Calendar.SECOND) == 0
        && c.get(Calendar.MILLISECOND) == 0;
  }

  /**
   * 去除毫秒后的值
   *
   * @param timeInMillis 时间戳，精确到毫秒
   * @return 时间戳，精确到秒
   */
  public static int getTimestamp(long timeInMillis) {
    return Long.valueOf(timeInMillis / 1000).intValue();
  }

  /**
   * 添加毫秒
   *
   * @param timestamp 时间戳，精确到秒
   * @return 时间戳，精确到毫秒
   */
  public static long getTimeInMillis(int timestamp) {
    return (long) timestamp * 1000;
  }

  public static String getTimestampShow(long timeInMillis,
                                        boolean yearFlag,
                                        boolean secondFlag) {
    Calendar calendar = Calendar.getInstance();
    calendar.setTimeInMillis(timeInMillis);
    int year = calendar.get(Calendar.YEAR);
    int month = calendar.get(Calendar.MONTH) + 1;
    int day = calendar.get(Calendar.DAY_OF_MONTH);
    String monthDay;
    if (CommonUtil.isChinese()) {
      monthDay = getZero(month) + "/" + getZero(day);
    } else {
      monthDay = showMonthDayFormatShort(calendar.getTime(), Locale.ENGLISH);
    }
    String ret = monthDay + " "
        + getZero(calendar.get(Calendar.HOUR_OF_DAY)) + ":"
        + getZero(calendar.get(Calendar.MINUTE));
    if (yearFlag) {
      ret = year + " " + ret;
    }
    if (secondFlag) {
      ret += ":" + getZero(calendar.get(Calendar.SECOND));
    }
    return ret;
  }

  public static String getZero(int i) {
    String str = i + "";
    if (i < 10) {
      str = "0" + i;
    }
    return str;
  }

  public static String getTimeInMillisShow(long timeInMillis) {
    Calendar calendar = Calendar.getInstance();
    calendar.setTimeInMillis(timeInMillis);
    return calendar.get(Calendar.YEAR) + "年"
        + (calendar.get(Calendar.MONTH) + 1) + "月"
        + calendar.get(Calendar.DAY_OF_MONTH) + "日"
        + calendar.get(Calendar.HOUR_OF_DAY) + ":"
        + calendar.get(Calendar.MINUTE) + ":"
        + calendar.get(Calendar.SECOND) + " "
        + calendar.get(Calendar.MILLISECOND);
  }

  public static String getDateShow(long timeInMillis) {
    Calendar calendar = Calendar.getInstance();
    calendar.setTimeInMillis(timeInMillis);
    return calendar.get(Calendar.YEAR) + "年"
        + (calendar.get(Calendar.MONTH) + 1) + "月"
        + calendar.get(Calendar.DAY_OF_MONTH) + "日";
  }

  public static String getDateShowEn(long timeInMillis) {
    Calendar calendar = Calendar.getInstance();
    calendar.setTimeInMillis(timeInMillis);
    return calendar.get(Calendar.YEAR) + "-"
        + (calendar.get(Calendar.MONTH) + 1) + "-"
        + calendar.get(Calendar.DAY_OF_MONTH);
  }

  public static String getDateShowYearMonthDay(Calendar c) {
    if (CommonUtil.isChinese()) {
      return getDateShow(c.getTime().getTime());
    } else {
      String date = c.get(Calendar.DAY_OF_MONTH) + "th "
          + getMonthTextAbbriviation(c) + " "
          + c.get(Calendar.YEAR);
      return date;
    }
  }

  public static String getTimeShowHourMinSec(int timestamp) {
    Calendar calendar = Calendar.getInstance();
    calendar.setTimeInMillis(getTimeInMillis(timestamp));
    String hourText = "";
    String minText = "";
    String secText = "";
    int hour = calendar.get(Calendar.HOUR_OF_DAY);
    int min = calendar.get(Calendar.MINUTE);
    int sec = calendar.get(Calendar.SECOND);
    hourText = hour + "";
    minText = min + "";
    secText = sec + "";
    if (hour < 10) {
      hourText = "0" + hourText;
    }
    if (min < 10) {
      minText = "0" + minText;
    }
    if (sec < 10) {
      secText = "0" + secText;
    }
    return hourText + ":" + minText + ":" + secText;
  }

  public static String getTimeShowHourMin(int timestamp) {
    if (timestamp == 0) {
      return "00:00";
    }

    Calendar calendar = Calendar.getInstance();
    calendar.setTimeInMillis(getTimeInMillis(timestamp));
    String hourText = "";
    String minText = "";
    int hour = calendar.get(Calendar.HOUR_OF_DAY);
    int min = calendar.get(Calendar.MINUTE);
    hourText = hour + "";
    minText = min + "";
    if (hour < 10) {
      hourText = "0" + hourText;
    }
    if (min < 10) {
      minText = "0" + minText;
    }
    return hourText + ":" + minText;
  }

  public static String getDateShowYearMonth(int timestamp) {
    Calendar calendar = Calendar.getInstance();
    calendar.setTimeInMillis(getTimeInMillis(timestamp));
    if (CommonUtil.isChinese()) {
      return calendar.get(Calendar.YEAR) + "年"
          + (calendar.get(Calendar.MONTH) + 1) + "月";
    } else {
      return (getMonthTextAbbriviation(calendar)) + " "
          + calendar.get(Calendar.YEAR);
    }
  }

  public static String getDateShowYearMonthDay(int timestamp) {
    Calendar calendar = Calendar.getInstance();
    calendar.setTimeInMillis(getTimeInMillis(timestamp));
    if (CommonUtil.isChinese()) {
      return calendar.get(Calendar.YEAR) + "年"
          + (calendar.get(Calendar.MONTH) + 1) + "月"
          + (calendar.get(Calendar.DAY_OF_MONTH)) + "日";
    } else {
      return calendar.get(Calendar.DAY_OF_MONTH) + "th " +
          (getMonthTextAbbriviation(calendar)) + " "
          + calendar.get(Calendar.YEAR);
    }
  }

  public static String getDateShowMonthDay(int timestamp) {
    Calendar calendar = Calendar.getInstance();
    calendar.setTimeInMillis(getTimeInMillis(timestamp));
    if (CommonUtil.isChinese()) {
      return (calendar.get(Calendar.MONTH) + 1) + "月"
          + calendar.get(Calendar.DAY_OF_MONTH) + "日";
    } else {
      String monthText = getMonthTextAbbriviation(calendar);
      return calendar.get(Calendar.DAY_OF_MONTH) + "th" + " " + monthText;
    }
  }

  public static String getMonthTextAbbriviation(Calendar c) {
    String monthText = "";
    switch (c.get(Calendar.MONTH)) {
      case 0:
        monthText = "Jan";
        break;
      case 1:
        monthText = "Feb";
        break;
      case 2:
        monthText = "Mar";
        break;
      case 3:
        monthText = "Apr";
        break;
      case 4:
        monthText = "May";
        break;
      case 5:
        monthText = "Jun";
        break;
      case 6:
        monthText = "Jul";
        break;
      case 7:
        monthText = "Aug";
        break;
      case 8:
        monthText = "Sept";
        break;
      case 9:
        monthText = "Oct";
        break;
      case 10:
        monthText = "Nov";
        break;
      case 11:
        monthText = "Dec";
        break;
    }
    return monthText;
  }

  public static String getDateShowMonthDayNoTemperature(int timestamp) {
    Calendar calendar = Calendar.getInstance();
    calendar.setTimeInMillis(getTimeInMillis(timestamp));
    if (CommonUtil.isChinese()) {
      return (calendar.get(Calendar.MONTH) + 1) + "月"
          + calendar.get(Calendar.DAY_OF_MONTH) + "日";
    } else {
      String monthText = "";
      switch (calendar.get(Calendar.MONTH)) {
        case 0:
          monthText = "Jan";
          break;
        case 1:
          monthText = "Feb";
          break;
        case 2:
          monthText = "Mar";
          break;
        case 3:
          monthText = "Apr";
          break;
        case 4:
          monthText = "May";
          break;
        case 5:
          monthText = "Jun";
          break;
        case 6:
          monthText = "Jul";
          break;
        case 7:
          monthText = "Aug";
          break;
        case 8:
          monthText = "Sept";
          break;
        case 9:
          monthText = "Oct";
          break;
        case 10:
          monthText = "Nov";
          break;
        case 11:
          monthText = "Dec";
          break;
      }

      return calendar.get(Calendar.DAY_OF_MONTH) + "th " + monthText;
    }
  }

  public static Date getFirstDayOfMonth(Date date) {
    Calendar c = Calendar.getInstance();
    c.setTime(date);
    c.set(Calendar.DAY_OF_MONTH, 1);//设置为1号,当前日期既为本月第一天
    long t = getDateBeginTimeInMillis(c.getTimeInMillis());
    c.setTimeInMillis(t);
    return c.getTime();
  }

  public static Date getLastDayOfMonth(Date date) {
    Calendar c = Calendar.getInstance();
    c.setTime(date);
    c.set(Calendar.DAY_OF_MONTH, c.getActualMaximum(Calendar.DAY_OF_MONTH));
    long t = getDateBeginTimeInMillis(c.getTimeInMillis());
    c.setTimeInMillis(t);
    return c.getTime();
  }

  public static String showMonthYearFormat(Date date, Locale locale) {
    SimpleDateFormat df = new SimpleDateFormat("MMMM yyyy", locale);
    return df.format(date);
  }

  public static String showMonthYearFormatShort(Date date, Locale locale) {
    SimpleDateFormat df = new SimpleDateFormat("MMM yyyy", locale);
    return df.format(date);
  }

  public static String showDayMonthYearFormat(Date date, Locale locale) {
    SimpleDateFormat df = new SimpleDateFormat("dd MMMM yyyy", locale);
    return df.format(date);
  }

  public static String showMonthDayFormatShort(Date date, Locale locale) {
    SimpleDateFormat df = new SimpleDateFormat("MMM dd", locale);
    return df.format(date);
  }

  public static String showHourMinuteFormatShort(Date date, Locale locale) {
    SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss", locale);
    return df.format(date);
  }

  public static String getTimeZoneIdFromGMT(TimeZone timeZone) {
    return timeZone.getID();
  }

  public static String showMinuteFormatShort(int timestamp, Locale locale) {
    Date date = new Date(getTimeInMillis(timestamp));
    SimpleDateFormat df = new SimpleDateFormat("HH:mm", locale);
    return df.format(date);
  }
}
