package com.basic.util;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;

/**
 * Copyright (c) 2015, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public class SpecificClassExclusionStrategy implements ExclusionStrategy {

  private final Class<?> excludedThisClass;
  private final Class<?> excludedThisClassFields;

  public SpecificClassExclusionStrategy(Class<?> excludedThisClass,
                                        Class<?> excluedThisClassFields) {
    this.excludedThisClass = excludedThisClass;
    this.excludedThisClassFields = excluedThisClassFields;
  }

  @Override
  public boolean shouldSkipClass(Class<?> clazz) {
    return clazz != null && (clazz.equals(excludedThisClass)
        || shouldSkipClass(clazz.getSuperclass()));
  }

  @Override
  public boolean shouldSkipField(FieldAttributes f) {
    return f.getDeclaringClass().equals(excludedThisClassFields);
  }

}