package com.basic.util;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

import android.util.Base64;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;

/**
 * Copyright (c) 2015, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public class GsonUtil {
  private static Gson gson;
  private static final GsonBuilder gsonBuilder = new GsonBuilder();

  public static Gson getGson() {
    if (gson == null) {
      gsonBuilder.excludeFieldsWithModifiers(
          Modifier.FINAL, Modifier.TRANSIENT, Modifier.STATIC
      );
      try {
        Class clazz = Class.forName("com.activeandroid.Model");
        gsonBuilder.setExclusionStrategies(
            new SpecificClassExclusionStrategy(null, clazz));
      } catch (ClassNotFoundException e) {
        e.printStackTrace();
      }
      gson = gsonBuilder.create();
    }
    return gson;
  }

  public static final Gson customGson = new GsonBuilder().registerTypeHierarchyAdapter(byte[].class,
      new ByteArrayToBase64TypeAdapter()).create();

  // Using Android's base64 libraries. This can be replaced with any base64 library.
  private static class ByteArrayToBase64TypeAdapter implements JsonSerializer<byte[]>, JsonDeserializer<byte[]> {
    public byte[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
      return Base64.decode(json.getAsString(), Base64.NO_WRAP);
    }

    public JsonElement serialize(byte[] src, Type typeOfSrc, JsonSerializationContext context) {
      return new JsonPrimitive(Base64.encodeToString(src, Base64.NO_WRAP));
    }
  }
}
