package com.basic.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

/**
 * Copyright (c) 2016, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public class FileUtils {

  /**
   * 写文件，末尾添加内容
   *
   * @param filePath  文件目录
   * @param fileName  文件名
   * @param write_str 内容
   */
  public static void writeFileAppend(String filePath, String fileName, String write_str) {
    File fileDir = new File(filePath);
    if (!fileDir.exists()) {
      if (!fileDir.mkdirs()) {
        return;
      }
    }

    BufferedWriter out = null;

    try {
      File f = new File(filePath + fileName);
      if (!f.exists()) {
        if (!f.createNewFile()) {
          return;
        }
      }

      out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(f, true)));
      out.write(write_str);
    } catch (Exception e) {
      e.printStackTrace();
    } finally {
      if (out != null) {
        try {
          out.close();
        } catch (IOException e) {
          e.printStackTrace();
        }
      }
    }
  }

  /**
   * 写文件，覆盖源文件
   *
   * @param filePath  文件路径
   * @param fileName  文件名
   * @param write_str 内容
   */
  public static void writeFile(String filePath, String fileName, String write_str) {
    File fileDir = new File(filePath);
    if (!fileDir.exists()) {
      if (!fileDir.mkdirs()) {
        return;
      }
    }

    File file = new File(filePath + fileName);
    try {
      if (!file.exists()) {
        if (!file.createNewFile()) {
          return;
        }
      }

      FileOutputStream fos = new FileOutputStream(file);
      byte[] bytes = write_str.getBytes();
      fos.write(bytes);
      fos.close();
    } catch (IOException e) {
      e.printStackTrace();
    }
  }

  public static void delete(File file) {
    if (file != null) {
      if (file.isDirectory()) {
        if (file.listFiles() != null) {
          for (File child : file.listFiles()) {
            delete(child);
          }
        }
      }
      file.delete();
    }
  }

  /**
   * 获取文件夹大小，以Byte为单位
   *
   * @param dir dir
   * @return long
   */
  public static long getDirSize(File dir) {
    long ret = 0;
    if (dir == null) {
      return 0;
    }

    if (!dir.isDirectory()) {
      ret = dir.length();
      return ret;
    }

    File[] files = dir.listFiles();
    for (File file : files) {
      if (file.isFile()) {
        ret += file.length();
      } else if (file.isDirectory()) {
        ret += getDirSize(file);
      }
    }
    return ret;
  }
}
