package com.basic.util;

import java.io.File;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;

public class Constants {

  public static String getImagePath(Context ctx) {
    return getPath(ctx, "image");
  }

  public static String getLogPath(Context context) {
    return getPath(context, "logs");
  }

  public static String getSessionPath(Context context) {
    return getPath(context, "session");
  }

  public static String getPath(Context ctx, String type) {
    String p;
    File fileDir;
    if (Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) { //SD 卡可用
      String mntPath;
      if (Environment.getExternalStorageDirectory().getAbsolutePath().contains("mnt/sdcard")) {
        mntPath = Environment.getExternalStorageDirectory().getAbsolutePath();
      } else {
        mntPath = "/mnt/sdcard";
      }
      if (TextUtils.isEmpty(type)) {
        p = mntPath + "/bongmi/" + ctx.getPackageName() + "/";
      } else {
        p = mntPath + "/bongmi/" + ctx.getPackageName() + "/" + type + "/";
      }
      fileDir = new File(p);
    } else {
      if (TextUtils.isEmpty(type)) {
        fileDir = ctx.getDir("notype", Context.MODE_PRIVATE);
      } else {
        fileDir = ctx.getDir(type, Context.MODE_PRIVATE);
      }
      p = fileDir.getAbsolutePath();
    }
    if (!fileDir.exists()) {
      if (!fileDir.mkdirs()) {
        Log.d("Constants", "create " + fileDir.getAbsolutePath() + " failed");
      }
    }
    return p;
  }
}
