package com.basic.util;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.view.View;
import android.view.ViewTreeObserver;

/**
 * Copyright (c) 2015, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public class BlurBuilder {
  private static final float BITMAP_SCALE = 0.4f;
  private static final float BLUR_RADIUS = 7.5f;

  public static Bitmap blur(View v, float bitmapScale, float blurRadius) {
    Bitmap retBmp = getScreenshot(v);
    if (retBmp == null) {
      return null;
    }
    return blur(v.getContext(), retBmp, bitmapScale, blurRadius);
  }

  public static Bitmap blur(View v) {
    return blur(v, BITMAP_SCALE, BLUR_RADIUS);
  }

  public static Bitmap blur(Context ctx, Bitmap image, float bitmapScale, float blurRadius) {
    int width = Math.round(image.getWidth() * bitmapScale);
    int height = Math.round(image.getHeight() * bitmapScale);

    Bitmap inputBitmap = Bitmap.createScaledBitmap(image, width, height, false);
    Bitmap outputBitmap = Bitmap.createBitmap(inputBitmap);

    RenderScript rs = RenderScript.create(ctx);
    ScriptIntrinsicBlur theIntrinsic = ScriptIntrinsicBlur.create(rs, Element.U8_4(rs));
    Allocation tmpIn = Allocation.createFromBitmap(rs, inputBitmap);
    Allocation tmpOut = Allocation.createFromBitmap(rs, outputBitmap);
    theIntrinsic.setRadius(blurRadius);
    theIntrinsic.setInput(tmpIn);
    theIntrinsic.forEach(tmpOut);
    tmpOut.copyTo(outputBitmap);
    return outputBitmap;
  }

  public static Bitmap getScreenshot(View v) {
    try {
      Bitmap b = Bitmap.createBitmap(v.getWidth(), v.getHeight(), Bitmap.Config.ARGB_8888);
      Canvas c = new Canvas(b);
      v.draw(c);
      return b;
    } catch (OutOfMemoryError e) {
      e.printStackTrace();
      return null;
    }
  }

  public static void setWindowBackground(final Activity activity) {
    final View content = activity.findViewById(android.R.id.content).getRootView();
    if (content.getWidth() > 0) {
      Bitmap image = BlurBuilder.blur(content);
      if (image != null) {
        activity.getWindow().setBackgroundDrawable(new BitmapDrawable(activity.getResources(), image));
      }
    } else {
      content.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener() {
        @Override
        public void onGlobalLayout() {
          Bitmap image = BlurBuilder.blur(content);
          if (image != null) {
            activity.getWindow().setBackgroundDrawable(new BitmapDrawable(activity.getResources(), image));
          }
        }
      });
    }
  }
}
