package com.basic.util;

import android.animation.ValueAnimator;
import android.view.View;

/**
 * Copyright (c) 2016, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public class AnimationUtil {
  public static void moveVertical(View view, float start, float end, int duration,
                                  AnimationCallback animationCallback) {
    move(view, start, end, duration, 1, animationCallback);
  }

  public static void moveHorizontal(View view, float start, float end, int duration,
                                    AnimationCallback animationCallback) {
    move(view, start, end, duration, 2, animationCallback);
  }

  private static void move(final View view, float start, final float end, int duration,
                           final int direct, final AnimationCallback animationCallback) {
    ValueAnimator valueAnimator = ValueAnimator.ofFloat(start, end);
    valueAnimator.setDuration(duration);
//    valueAnimator.setInterpolator(new LinearInterpolator());
    valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
      @Override
      public void onAnimationUpdate(ValueAnimator animation) {
        float current = (float) animation.getAnimatedValue();
        if (direct == 1) {
          view.setY(current);
        } else {
          view.setX(current);
        }
        if (current == end) {
          animationCallback.animationEnd();
        }
      }
    });
    valueAnimator.start();
  }

  public interface AnimationCallback {
    void animationEnd();
  }
}
