package com.basic.thread;

import java.util.HashMap;
import java.util.Map;

import android.os.Message;

/**
 * Copyright (c) 2015, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public class LollypopThreadPool {
  private final Map<String, LollypopHandler> handlerMap = new HashMap<>();
  private static LollypopThreadPool ourInstance = new LollypopThreadPool();

  public static LollypopThreadPool getInstance() {
    return ourInstance;
  }

  private LollypopThreadPool() {
  }

  public LollypopHandler get(String name) {
    return get(new LollypopHandlerInterface() {
      @Override
      public void handleMessage(Message msg) {

      }
    }, name);
  }

  public LollypopHandler get(LollypopHandlerInterface lollypopHandlerInterface,
                             String name) {
    return get(lollypopHandlerInterface, name, Thread.NORM_PRIORITY);
  }

  public LollypopHandler get(LollypopHandlerInterface lollypopHandlerInterface,
                             String name, int priority) {
    if (handlerMap.containsKey(name)) {
      return handlerMap.get(name);
    }

    LollypopThread thread = new LollypopThread(name, priority);
    thread.start();

    LollypopHandler threadHandler = new LollypopHandler(
        lollypopHandlerInterface, thread.getLooper());
    handlerMap.put(name, threadHandler);
    return threadHandler;
  }
}
