package com.basic.thread;

import java.lang.ref.WeakReference;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.basic.util.Callback;

/**
 * Copyright (c) 2015, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public class LollypopHandler extends Handler implements Callback {
  public static final int WHAT_SUC = 1;
  public static final int WHAT_FAIL = -1;

  private WeakReference<LollypopHandlerInterface> weakReference;

  public LollypopHandler() {
    super();
  }

  public LollypopHandler(Looper looper) {
    super(looper);
  }

  public LollypopHandler(LollypopHandlerInterface handlerInterface) {
    super();
    weakReference = new WeakReference<>(handlerInterface);
  }

  public LollypopHandler(LollypopHandlerInterface handlerInterface,
                         Looper looper) {
    super(looper);
    weakReference = new WeakReference<>(handlerInterface);
  }

  @Override
  public void handleMessage(Message msg) {
    LollypopHandlerInterface handlerInterface = weakReference.get();
    if (handlerInterface != null) {
      handlerInterface.handleMessage(msg);
    }
  }

  @Override
  public void doCallback(Boolean result, Object obj) {

  }
}
