package com.basic.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import android.os.Handler;
import android.util.Log;

/**
 * Copyright (c) 2016, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public class RefreshManager {
  private static RefreshManager ourInstance = new RefreshManager();

  private final Map<Integer, RefreshCallback> refreshCallbackMap = new HashMap<>();
  private final static List<Integer> currentCodes = new ArrayList<>();
  private final static Object refreshLock = new Object();
  private final Handler mainThreadHandler = new Handler();

  public static RefreshManager getInstance() {
    return ourInstance;
  }

  private RefreshManager() {
  }

  public void registerRefreshCallback(int code, RefreshCallback refreshCallback) {
    synchronized (refreshLock) {
      refreshCallbackMap.put(code, refreshCallback);
    }
  }

  public void unRegisterRefreshCallback(int code) {
    synchronized (refreshLock) {
      if (refreshCallbackMap.containsKey(code)) {
        refreshCallbackMap.remove(code);
      }
    }
  }

  public void refreshView(int code) {
    synchronized (currentCodes) {
      Log.d("BaseApplication", "add refresh view code : " + code);
      currentCodes.add(code);
      mainThreadHandler.post(runnable);
    }
  }

  private final Runnable runnable = new Runnable() {
    @Override
    public void run() {
      mainThreadHandler.removeCallbacks(this);
      synchronized (currentCodes) {
        while (currentCodes.size() > 0) {
          int code = currentCodes.remove(0);
          Log.d("BaseApplication", "refresh view code : " + code);
          RefreshCallback refreshCallback = refreshCallbackMap.get(code);
          if (refreshCallback == null) {
            continue;
          }

          refreshCallback.doCallback(code);
        }
      }
    }
  };

  public interface RefreshCallback {
    void doCallback(int code);
  }
}
