package com.basic.controller;

import java.util.ArrayList;

import android.Manifest;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import com.basic.activity.BaseActivity;
import com.basic.util.TimeUtil;
import com.orhanobut.logger.Logger;

/**
 * Copyright (c) 2016, Bongmi
 * All rights reserved
 * Author: jianghao@bongmi.com
 */
public class PermissionRequestManager {
  public static final int REQUEST_PERMISSION_CODE = 181;
  private static final String REQUEST_PERMISSION_TIME =
      "REQUEST_PERMISSION_TIME";

  private static PermissionRequestManager instance
      = new PermissionRequestManager();

  private PermissionRequestManager() {}

  public static PermissionRequestManager getInstance() {
    return instance;
  }

  public boolean requestPermissions(BaseActivity activity, int familyMemberId) {
    ArrayList<String> permissions = new ArrayList<>();
    if (!activity.checkPermission(Manifest.permission.WRITE_EXTERNAL_STORAGE)) {
      permissions.add(Manifest.permission.WRITE_EXTERNAL_STORAGE);
    }
    if (!activity.checkPermission(Manifest.permission.ACCESS_COARSE_LOCATION)) {
      permissions.add(Manifest.permission.ACCESS_COARSE_LOCATION);
    }
    if (!activity.checkPermission(Manifest.permission.ACCESS_FINE_LOCATION)) {
      permissions.add(Manifest.permission.ACCESS_FINE_LOCATION);
    }
    Logger.d("请求权限数量 ： " + permissions.size());
    if (permissions.size() > 0) {
      if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
        activity.requestPermissions(
            permissions.toArray(new String[permissions.size()]),
            REQUEST_PERMISSION_CODE
        );
      }

      int currentTime = TimeUtil.getTimestamp(
          TimeUtil.getDateBeginTimeInMillis(
              System.currentTimeMillis()));
      setRequestPermissionTime(activity, currentTime, familyMemberId);
      return true;
    }

    return false;
  }

  public boolean checkShowRequest(Context context, int familyMemberId) {
    int lastRequestTime = getRequestPermissionTime(context, familyMemberId);
    int currentTime = TimeUtil.getTimestamp(TimeUtil
        .getDateBeginTimeInMillis(System.currentTimeMillis()));
    return !(currentTime == lastRequestTime);
  }

  private void setRequestPermissionTime(Context context,
                                        int timestamp,
                                        int familyMemberId) {
    SharedPreferences sharedPreferences = context.getSharedPreferences(
        REQUEST_PERMISSION_TIME + familyMemberId, Activity.MODE_PRIVATE);
    SharedPreferences.Editor editor = sharedPreferences.edit();
    editor.putInt(REQUEST_PERMISSION_TIME, timestamp);
    editor.apply();
  }

  private int getRequestPermissionTime(Context context, int familyMemberId) {
    SharedPreferences settings = context.getSharedPreferences(
        REQUEST_PERMISSION_TIME + familyMemberId, Activity.MODE_PRIVATE);
    return settings.getInt(REQUEST_PERMISSION_TIME, 0);
  }
}