package com.basic.activity;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

import android.Manifest;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Toast;
import com.basic.application.BaseApplication;
import com.basic.util.BitmapUtil;
import com.basic.util.Constants;
import com.basic.widgets.ActionBar;
import com.orhanobut.logger.Logger;

/**
 * Copyright (c) 2016, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public class BaseActivity extends AppCompatActivity {
  protected ActionBar actionBar;
  protected boolean isSetFont;
  protected String photoName = null;

  @Override
  protected void onCreate(@Nullable Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
  }

  @Override
  protected void onResume() {
    super.onResume();

    setFont(android.R.id.content);
  }

  protected void setFont(int root) {
    if (isSetFont) {
      return;
    }

    isSetFont = true;
    BaseApplication application = (BaseApplication) getApplicationContext();
    ViewGroup viewGroup = (ViewGroup) findViewById(root);
    application.setTypeFace(application.getRegularTypeface(), viewGroup);
  }

  /**
   * 添加默认标题栏，有返回按钮，中间标题.
   */
  protected void addDefaultActionBar(int resourceId,
                                     int barDefaultTitleId,
                                     int barDefaultBackId,
                                     int barDefaultRightIconId) {
    actionBar = new ActionBar(this, resourceId, barDefaultTitleId,
        barDefaultBackId, barDefaultRightIconId);
    BaseApplication application = (BaseApplication) getApplicationContext();
    actionBar.setTypeface(application.getRegularTypeface());
  }

  protected void setDefaultActionBarTitle(String title) {
    if (actionBar != null) {
      actionBar.setTitle(title);
    }
  }

  /**
   * 显示bar右边按钮.
   */
  protected void showDefaultActionBarRight(View.OnClickListener click) {
    if (actionBar != null) {
      actionBar.showRightIcon(click);
    }
  }

  /**
   * 修改状态栏颜色.
   */
  protected void initSystemBar(int color) {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
      setTranslucentStatus(true);
    }
    SystemBarTint tintManager = new SystemBarTint(this);
    tintManager.setStatusBarTintEnabled(true);
    tintManager.setStatusBarTintColor(color);
    //    if(Build.VERSION.SDK_INT>=Build.VERSION_CODES.LOLLIPOP){
    //      if(getSupportActionBar()!=null){ //添加阴影
    //        getSupportActionBar().setElevation(10);
    //      }
    //    }
  }

  /**
   * 隐藏标题栏.
   */
  protected void hideActionBar() {
    android.support.v7.app.ActionBar actionBar = getSupportActionBar();
    if (actionBar != null) {
      actionBar.hide();
    }
  }

  @TargetApi(19)
  protected void setTranslucentStatus(boolean on) {
    Window win = this.getWindow();
    WindowManager.LayoutParams winParams = win.getAttributes();
    final int bits = WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS;
    if (on) {
      winParams.flags |= bits;
    } else {
      winParams.flags &= ~bits;
    }
    win.setAttributes(winParams);
  }

  /**
   * 显示手机信息.
   */
  public void showMetrics() {
    //dpi
    DisplayMetrics metrics = new DisplayMetrics();
    getWindowManager().getDefaultDisplay().getMetrics(metrics);
    String msg = "屏幕DPI : " + metrics.densityDpi + "(" + metrics.density + ")"
        + " , 屏幕宽 : " + metrics.widthPixels
        + " , 屏幕长 : " + metrics.heightPixels;
    Toast.makeText(this, msg, Toast.LENGTH_SHORT).show();
  }

  public DisplayMetrics getMetrics() {
    /*Log.i(TAG, "status bar 高度 : " + getStatusBarHeight());
    Log.i(TAG, "action bar 高度 : " + getActionBarHeight());*/

    DisplayMetrics metrics = new DisplayMetrics();
    getWindowManager().getDefaultDisplay().getMetrics(metrics);
    String msg = "屏幕DPI : " + metrics.densityDpi + "(" + metrics.density + ")"
        + " , 屏幕宽 : " + metrics.widthPixels
        + " , 屏幕长 : " + metrics.heightPixels;
    Logger.i(msg);
    return metrics;
  }

  public int getActionBarHeight() {
    int actionBarHeight = 0;
    TypedValue tv = new TypedValue();
    if (getTheme().resolveAttribute(android.R.attr.actionBarSize, tv, true)) {
      actionBarHeight = TypedValue.complexToDimensionPixelSize(
          tv.data, getResources().getDisplayMetrics());
    }
    return actionBarHeight;
  }

  public int getStatusBarHeight() {
    int result = 0;
    int resourceId = getResources().getIdentifier(
        "status_bar_height", "dimen", "android");
    if (resourceId > 0) {
      result = getResources().getDimensionPixelSize(resourceId);
    }
    return result;
  }

  public boolean checkPermission(String permissionString) {
    int permission = ContextCompat.checkSelfPermission(this, permissionString);
    Logger.d("请求权限 ： " + permissionString + ", " + permission);
    return permission == PackageManager.PERMISSION_GRANTED;
  }

  // 在onRequestPermissionsResult中回调
  protected void requestCamera(int requestCode) {
    if (ContextCompat.checkSelfPermission(this, Manifest.permission.CAMERA)
        != PackageManager.PERMISSION_GRANTED) {
      ActivityCompat.requestPermissions(
          this, new String[]{Manifest.permission.CAMERA,
              Manifest.permission.WRITE_EXTERNAL_STORAGE},
          requestCode
      );
    }
  }

  protected void requestGallery(int requestCode) {
    if (ContextCompat.checkSelfPermission(this,
        Manifest.permission.WRITE_EXTERNAL_STORAGE)
        != PackageManager.PERMISSION_GRANTED) {
      ActivityCompat.requestPermissions(
          this, new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE},
          requestCode
      );
    }
  }

  /**
   * 选择视频.
   */
  protected Intent getVideoIntent() {
    Intent intent = new Intent(Intent.ACTION_PICK, null);
    intent.setDataAndType(
        MediaStore.Video.Media.EXTERNAL_CONTENT_URI, "video/*");//取视频
    return intent;
  }

  /**
   * 进行拍照.
   */
  @SuppressLint("SimpleDateFormat")
  protected Intent getCaptureIntent() {
    Date date = new Date(System.currentTimeMillis());
    SimpleDateFormat dateFormat = new SimpleDateFormat("'IMG'_yyyyMMddHHmmss");
    photoName = dateFormat.format(date) + ".jpg";
    Intent intent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
    File vFile = new File(Constants.getImagePath(this), photoName);
    if (!vFile.exists()) {
      File vDirPath = vFile.getParentFile();
      if (!vDirPath.exists()) {
        boolean mkFlag = vDirPath.mkdirs();
        if (!mkFlag) {
          return null;
        }
      }
    }
    Uri uri = Uri.fromFile(vFile);
    // 下面这句指定调用相机拍照后的照片存储的路径
    intent.putExtra(MediaStore.EXTRA_OUTPUT, uri);
    intent.putExtra(MediaStore.EXTRA_VIDEO_QUALITY, 1);
    return intent;
  }

  protected String getCapturePath() {
    File temp = new File(Constants.getImagePath(this) + photoName);
    if (!temp.exists()) {
      return null;
    }
    return Constants.getImagePath(this) + photoName;
  }

  /**
   * 获取照片bitmap.
   */
  protected Bitmap getCaptureBitmap() {
    File temp = new File(Constants.getImagePath(this) + photoName);
    if (temp.exists()) {
      //Uri.fromFile(temp).getPath();
      try {
        return MediaStore.Images.Media.getBitmap(
            this.getContentResolver(), Uri.fromFile(temp));
      } catch (IOException e) {
        e.printStackTrace();
      } catch (OutOfMemoryError e) {
        e.printStackTrace();
        WindowManager windowManager =
            (WindowManager) this.getSystemService(Context.WINDOW_SERVICE);
        Display display = windowManager.getDefaultDisplay();
        int screenWidth = display.getWidth();
        int screenHeight = display.getHeight();
        return BitmapUtil.fitSizeImg(temp.getPath(), screenWidth, screenHeight);
      }
    }
    return null;
  }

  protected File getPhotoFileByBmp(Bitmap mBitmap) throws IOException {
    File file = new File(Constants.getImagePath(this) + photoName);
    file.createNewFile();
    FileOutputStream fOut = null;
    try {
      fOut = new FileOutputStream(file);
    } catch (FileNotFoundException e) {
      e.printStackTrace();
    }
    mBitmap.compress(Bitmap.CompressFormat.JPEG, 100, fOut);
    try {
      assert fOut != null;
      fOut.flush();
    } catch (IOException e) {
      e.printStackTrace();
    }
    try {
      fOut.close();
    } catch (IOException e) {
      e.printStackTrace();
    }
    return file;
  }
}
