/*
 * Decompiled with CFR 0.152.
 */
package cn.lemon.view.adapter;

import android.util.Log;
import android.util.SparseArray;
import android.util.SparseIntArray;
import cn.lemon.view.adapter.BaseViewHolder;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Map;

public class ViewHolderManager {
    private final String TAG = "ViewHolderManager";
    private int mViewType = 10;
    private Map<Class<? extends BaseViewHolder>, Integer> mHolderToTypeMap = new HashMap<Class<? extends BaseViewHolder>, Integer>();
    private SparseArray<Class<? extends BaseViewHolder>> mTypeToHolderMap = new SparseArray();
    private SparseIntArray mPositionToTypeMap = new SparseIntArray();

    public void putViewType(int position, int type) {
        this.mPositionToTypeMap.put(position, type);
    }

    public int getViewType(int position) {
        return this.mPositionToTypeMap.get(position);
    }

    public void addViewHolder(Class<? extends BaseViewHolder> viewHolder) {
        if (!this.mHolderToTypeMap.containsKey(viewHolder)) {
            Class dataClass = (Class)((ParameterizedType)viewHolder.getGenericSuperclass()).getActualTypeArguments()[0];
            ++this.mViewType;
            this.mHolderToTypeMap.put(viewHolder, this.mViewType);
            this.mTypeToHolderMap.put(this.mViewType, viewHolder);
            Log.d((String)"ViewHolderManager", (String)("addViewHolder dataClassType : " + dataClass.getName()));
        }
    }

    public int getViewType(Class<? extends BaseViewHolder> holder) {
        if (!this.mHolderToTypeMap.containsKey(holder)) {
            throw new IllegalArgumentException("please invoke add ViewHolder method");
        }
        return this.mHolderToTypeMap.get(holder);
    }

    public Class<? extends BaseViewHolder> getViewHolderClass(int viewType) {
        if (this.mTypeToHolderMap.get(viewType) == null) {
            throw new IllegalArgumentException("please invoke add ViewHolder method");
        }
        return (Class)this.mTypeToHolderMap.get(viewType);
    }
}

