/*
 * Decompiled with CFR 0.152.
 */
package cn.lemon.view.adapter;

import android.content.Context;
import android.os.Message;
import android.support.annotation.LayoutRes;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import cn.lemon.view.R;
import cn.lemon.view.adapter.Action;
import cn.lemon.view.adapter.BaseViewHolder;
import cn.lemon.view.adapter.IHandler;
import cn.lemon.view.adapter.WeakHandler;
import cn.lemon.view.util.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class RecyclerAdapter<T>
extends RecyclerView.Adapter<BaseViewHolder<T>>
implements IHandler {
    private static final String TAG = RecyclerAdapter.class.getSimpleName();
    private static final int MSG_SHOW_NO_MORE = 2;
    private static final int MSG_SHOW_LOAD_MORE = 4;
    private static final int MSG_SHOW_LOAD_MORE_ERROR = 8;
    public static final int HEADER_TYPE = 111;
    public static final int FOOTER_TYPE = 222;
    public static final int STATUS_TYPE = 333;
    protected int mViewCount = 0;
    private boolean hasHeader = false;
    private boolean hasFooter = false;
    protected boolean mLoadMoreEnable = false;
    protected boolean mNoMoreEnable = false;
    protected boolean mIsLoadMoring = false;
    protected boolean mIsNoMoring = false;
    protected List<Action> mLoadMoreActions = new ArrayList<Action>();
    protected List<Action> mErrorActions = new ArrayList<Action>();
    protected List<T> mData = new ArrayList<T>();
    private View headerView;
    private View footerView;
    private View mLoadMoreLayout;
    private View mLoadMoreView;
    private TextView mLoadMoreError;
    private TextView mNoMoreView;
    protected View mStatusView;
    private Context mContext;
    private WeakHandler mHandler = new WeakHandler(this);

    public RecyclerAdapter(Context context) {
        this.mContext = context;
    }

    public RecyclerAdapter(Context context, T[] data) {
        this(context, Arrays.asList(data));
    }

    public RecyclerAdapter(Context context, List<T> data) {
        this.mContext = context;
        this.mData = data;
        this.mViewCount += data.size();
        this.notifyDataSetChanged();
    }

    private void initEndStatusView() {
        if (this.hasEndStatusView() && this.mStatusView == null) {
            this.mStatusView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.view_status_last, null);
            this.mStatusView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
            this.mLoadMoreLayout = this.mStatusView.findViewById(R.id.load_more_Layout);
            this.mLoadMoreView = this.mStatusView.findViewById(R.id.load_more_loading);
            this.mLoadMoreError = (TextView)this.mStatusView.findViewById(R.id.load_more_error);
            this.mNoMoreView = (TextView)this.mStatusView.findViewById(R.id.no_more_view);
            ++this.mViewCount;
            this.mLoadMoreError.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    RecyclerAdapter.this.mHandler.sendEmptyMessage(4);
                    for (Action action : RecyclerAdapter.this.mErrorActions) {
                        action.onAction();
                    }
                }
            });
        }
    }

    public void setLoadMoreEnable(boolean b) {
        this.mLoadMoreEnable = b;
        this.initEndStatusView();
    }

    public void setShowNoMoreEnable(boolean b) {
        this.mNoMoreEnable = b;
        this.initEndStatusView();
    }

    public boolean isShowNoMoring() {
        return this.mIsNoMoring;
    }

    public BaseViewHolder<T> onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 111) {
            return new BaseViewHolder(this.headerView);
        }
        if (viewType == 222) {
            return new BaseViewHolder(this.footerView);
        }
        if (viewType == 333) {
            return new BaseViewHolder(this.mStatusView);
        }
        return this.onCreateBaseViewHolder(parent, viewType);
    }

    public abstract BaseViewHolder<T> onCreateBaseViewHolder(ViewGroup var1, int var2);

    public void onBindViewHolder(BaseViewHolder<T> holder, int position) {
        this.log("onBindViewHolder()  viewCount : " + this.mViewCount + " position : " + position);
        if (holder == null || position < 0) {
            return;
        }
        int dataSize = this.mData.size();
        if (this.hasEndStatusView()) {
            if (!this.hasHeader && !this.hasFooter && position < dataSize) {
                holder.setData(this.mData.get(position));
            } else if (this.hasHeader && !this.hasFooter && position > 0 && position < this.mViewCount - 1 && position - 1 < dataSize) {
                holder.setData(this.mData.get(position - 1));
            } else if (!this.hasHeader && position < this.mViewCount - 2 && position < dataSize) {
                holder.setData(this.mData.get(position));
            } else if (position > 0 && position < this.mViewCount - 2 && position - 1 < dataSize) {
                holder.setData(this.mData.get(position - 1));
            }
        } else if (!this.hasHeader && !this.hasFooter && position < dataSize) {
            holder.setData(this.mData.get(position));
        } else if (this.hasHeader && !this.hasFooter && position > 0 && position < this.mViewCount && position - 1 < dataSize) {
            holder.setData(this.mData.get(position - 1));
        } else if (!this.hasHeader && position < this.mViewCount - 1 && position < dataSize) {
            holder.setData(this.mData.get(position));
        } else if (position > 0 && position < this.mViewCount - 1 && position - 1 < dataSize) {
            holder.setData(this.mData.get(position - 1));
        }
        if (this.mLoadMoreEnable && !this.mIsNoMoring && !this.mIsLoadMoring && this.isValidLoadMore(position)) {
            this.performLoadMore();
        }
    }

    protected void performLoadMore() {
        this.log("load more");
        this.mIsLoadMoring = true;
        this.setViewVisible(this.mLoadMoreLayout, true);
        this.setViewVisible(this.mLoadMoreView, true);
        this.setViewVisible((View)this.mLoadMoreError, false);
        this.setViewVisible((View)this.mNoMoreView, false);
        for (Action action : this.mLoadMoreActions) {
            action.onAction();
        }
    }

    protected boolean isValidLoadMore(int position) {
        if (this.hasEndStatusView()) {
            if (this.hasHeader) {
                return position > 1 && position == this.mViewCount - 3 && this.mViewCount != 2;
            }
            return position > 0 && position == this.mViewCount - 2 && this.mViewCount != 1;
        }
        return false;
    }

    public int getItemViewType(int position) {
        if (this.hasHeader && position == 0) {
            return 111;
        }
        if (this.hasFooter && this.hasEndStatusView() && position == this.mViewCount - 2) {
            return 222;
        }
        if (this.hasFooter && !this.hasEndStatusView() && position == this.mViewCount - 1) {
            return 222;
        }
        if (this.hasEndStatusView() && position == this.mViewCount - 1) {
            return 333;
        }
        return super.getItemViewType(position);
    }

    public int getItemCount() {
        return this.mViewCount;
    }

    public void showNoMore() {
        if (!this.mNoMoreEnable) {
            return;
        }
        this.mIsNoMoring = true;
        this.mHandler.sendEmptyMessage(2);
    }

    public void showLoadMoreError() {
        if (!this.mLoadMoreEnable) {
            return;
        }
        this.mHandler.sendEmptyMessage(8);
    }

    public void addLoadMoreErrorAction(Action action) {
        if (action == null) {
            return;
        }
        this.mErrorActions.add(action);
    }

    public void openLoadMore() {
        this.mIsNoMoring = false;
        this.mHandler.sendEmptyMessage(4);
    }

    public void addLoadMoreAction(Action action) {
        if (action == null) {
            return;
        }
        this.mLoadMoreActions.add(action);
    }

    public void add(T object) {
        if (!this.mIsNoMoring && object != null) {
            this.mIsLoadMoring = false;
            this.mData.add(object);
            int position = this.hasFooter && this.hasEndStatusView() ? this.mViewCount - 2 : (this.hasFooter && !this.hasEndStatusView() ? this.mViewCount - 1 : (!this.hasFooter && this.hasEndStatusView() ? this.mViewCount - 1 : this.mViewCount));
            ++this.mViewCount;
            this.notifyItemInserted(position);
        }
    }

    public void insert(T object, int itemPosition) {
        int maxPosition;
        int n = maxPosition = this.hasEndStatusView() ? this.mViewCount - 2 : this.mViewCount - 1;
        if (this.mData != null && itemPosition < maxPosition && object != null) {
            int dataPosition = this.hasHeader ? itemPosition - 1 : itemPosition;
            this.mData.add(dataPosition, object);
            ++this.mViewCount;
            this.notifyItemInserted(itemPosition);
        }
    }

    public void addAll(List<T> data) {
        if (data == null) {
            return;
        }
        int size = data.size();
        if (!this.mIsNoMoring && size > 0) {
            this.mIsLoadMoring = false;
            this.mData.addAll(data);
            int positionStart = this.hasFooter && this.hasEndStatusView() ? this.mViewCount - 2 : (this.hasFooter && !this.hasEndStatusView() ? this.mViewCount - 1 : (!this.hasFooter && this.hasEndStatusView() ? this.mViewCount - 1 : this.mViewCount));
            this.mViewCount += size;
            this.notifyItemRangeInserted(positionStart, size);
            this.log("addAll()  startPosition : " + positionStart + "  itemCount : " + size);
        }
    }

    public void addAll(T[] objects) {
        this.addAll(Arrays.asList(objects));
    }

    public void replace(T object, int itemPosition) {
        int dataPosition;
        if (this.mData != null && object != null && (dataPosition = this.hasHeader ? itemPosition - 1 : itemPosition) < this.mData.size()) {
            this.mData.set(dataPosition, object);
            ++this.mViewCount;
            this.notifyItemChanged(itemPosition);
        }
    }

    public void remove(T object) {
        if (object != null && !this.mData.contains(object)) {
            this.log("without the object : " + object.getClass().getName());
            return;
        }
        int dataPosition = this.mData.indexOf(object);
        int itemPosition = this.hasHeader ? dataPosition + 1 : dataPosition;
        this.remove(itemPosition);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void remove(int itemPosition) {
        int dataSize = this.mData.size();
        if (this.hasHeader) {
            int dataPosition = itemPosition - 1;
            if (dataPosition >= 0 && dataPosition < dataSize) {
                this.mData.remove(dataPosition);
                this.notifyItemRemoved(itemPosition);
                --this.mViewCount;
                return;
            }
            if (dataPosition < dataSize) throw new IndexOutOfBoundsException("RecyclerView has header,position is should more than 0 .if you want remove header , pleasure user removeHeader()");
            throw new IllegalArgumentException("itemPosition is greater than data size");
        }
        int dataPosition = itemPosition;
        if (dataPosition >= dataSize) {
            throw new IllegalArgumentException("itemPosition is greater than data size");
        }
        this.mData.remove(dataPosition);
        this.notifyItemRemoved(itemPosition);
        --this.mViewCount;
    }

    public void clear() {
        this.mData.clear();
        int n = this.mViewCount = this.hasEndStatusView() ? 1 : 0;
        if (this.hasHeader) {
            ++this.mViewCount;
        }
        if (this.hasFooter) {
            ++this.mViewCount;
        }
        this.mIsNoMoring = false;
        this.mIsLoadMoring = false;
        this.setViewVisible(this.mLoadMoreLayout, false);
        this.setViewVisible((View)this.mNoMoreView, false);
        this.notifyDataSetChanged();
    }

    public void setHeader(View header) {
        this.hasHeader = true;
        this.headerView = header;
        ++this.mViewCount;
    }

    public void setHeader(@LayoutRes int res) {
        this.setHeader(LayoutInflater.from((Context)this.mContext).inflate(res, null));
    }

    public View getHeader() {
        return this.headerView;
    }

    public View getFooter() {
        return this.footerView;
    }

    public void setFooter(View footer) {
        this.hasFooter = true;
        this.footerView = footer;
        ++this.mViewCount;
    }

    public void setFooter(@LayoutRes int res) {
        this.setFooter(LayoutInflater.from((Context)this.mContext).inflate(res, null));
    }

    public void removeHeader() {
        if (this.hasHeader) {
            this.hasHeader = false;
            this.notifyItemRemoved(0);
        }
    }

    public void removeFooter() {
        if (this.hasFooter) {
            this.hasFooter = false;
            if (this.hasEndStatusView() && this.mViewCount > 1) {
                this.notifyItemRemoved(this.mViewCount - 2);
            } else if (!this.hasEndStatusView() && this.mViewCount > 0) {
                this.notifyItemRemoved(this.mViewCount - 1);
            }
        }
    }

    public List<T> getData() {
        return this.mData;
    }

    public Context getContext() {
        return this.mContext;
    }

    protected void setViewVisible(View view, boolean visibile) {
        if (view != null) {
            view.setVisibility(visibile ? 0 : 8);
        }
    }

    protected boolean hasEndStatusView() {
        return this.mLoadMoreEnable || this.mNoMoreEnable;
    }

    @Override
    public void handMsg(Message message) {
        switch (message.what) {
            case 8: {
                this.mIsLoadMoring = true;
                this.setViewVisible(this.mLoadMoreLayout, true);
                this.setViewVisible(this.mLoadMoreView, false);
                this.setViewVisible((View)this.mLoadMoreError, true);
                this.setViewVisible((View)this.mNoMoreView, false);
                break;
            }
            case 4: {
                this.mIsLoadMoring = true;
                this.setViewVisible(this.mLoadMoreLayout, true);
                this.setViewVisible(this.mLoadMoreView, true);
                this.setViewVisible((View)this.mLoadMoreError, false);
                this.setViewVisible((View)this.mNoMoreView, false);
                break;
            }
            case 2: {
                this.mIsLoadMoring = false;
                this.setViewVisible(this.mLoadMoreLayout, false);
                this.setViewVisible((View)this.mNoMoreView, true);
                break;
            }
        }
    }

    protected void log(String content) {
        LogUtils.log(TAG, content);
    }
}

